/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.video;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import net.sf.fmj.media.AbstractCodec;
import net.sf.fmj.media.util.ImageToBuffer;

public abstract class ImageIODecoder
extends AbstractCodec
implements Codec {
    private final Format[] supportedOutputFormats = new Format[]{new RGBFormat(null, -1, Format.byteArray, -1.0f, -1, -1, -1, -1)};

    public ImageIODecoder(String string) {
        if (!ImageIO.getImageReadersByFormatName(string).hasNext()) {
            throw new RuntimeException("No ImageIO reader found for " + string);
        }
    }

    public abstract Format[] getSupportedInputFormats();

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return this.supportedOutputFormats;
        }
        VideoFormat videoFormat = (VideoFormat)format;
        Format[] formatArray = new Format[]{new RGBFormat(videoFormat.getSize(), -1, Format.byteArray, videoFormat.getFrameRate(), -1, -1, -1, -1)};
        return formatArray;
    }

    public int process(Buffer buffer, Buffer buffer2) {
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])buffer.getData(), buffer.getOffset(), buffer.getLength());
            BufferedImage bufferedImage = ImageIO.read(byteArrayInputStream);
            byteArrayInputStream.close();
            Buffer buffer3 = ImageToBuffer.createBuffer(bufferedImage, ((VideoFormat)this.outputFormat).getFrameRate());
            buffer2.setData(buffer3.getData());
            buffer2.setOffset(buffer3.getOffset());
            buffer2.setLength(buffer3.getLength());
            buffer2.setFormat(buffer3.getFormat());
            return 0;
        }
        catch (IOException iOException) {
            buffer2.setDiscard(true);
            buffer2.setLength(0);
            return 1;
        }
    }

    public Format setInputFormat(Format format) {
        VideoFormat videoFormat = (VideoFormat)format;
        if (videoFormat.getSize() == null) {
            return null;
        }
        return super.setInputFormat(format);
    }
}

