/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.stats;

import java.util.Collection;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriStatsExtension;
import net.java.sip.communicator.util.Logger;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.stats.Statistics;
import org.jitsi.videobridge.stats.StatsTransport;
import org.jitsi.videobridge.xmpp.ComponentImpl;
import org.jivesoftware.smack.packet.IQ;
import org.osgi.framework.BundleContext;

public class ColibriStatsTransport
extends StatsTransport {
    private static final Logger logger = Logger.getLogger(ColibriStatsTransport.class);

    private static IQ buildStatsIQ(Statistics statistics) {
        final ColibriStatsExtension ext = Statistics.toXMPP(statistics);
        IQ iq = new IQ(){

            public String getChildElementXML() {
                return ext.toXML();
            }
        };
        iq.setType(IQ.Type.RESULT);
        return iq;
    }

    public void publishStatistics(Statistics stats) {
        BundleContext bundleContext = this.getBundleContext();
        if (bundleContext != null) {
            Collection<Videobridge> videobridges = Videobridge.getVideobridges(bundleContext);
            IQ statsIQ = null;
            for (Videobridge videobridge : videobridges) {
                Conference[] conferences;
                Collection<ComponentImpl> components = videobridge.getComponents();
                if (components.isEmpty() || (conferences = videobridge.getConferences()).length == 0) continue;
                if (statsIQ == null) {
                    statsIQ = ColibriStatsTransport.buildStatsIQ(stats);
                }
                for (Conference conference : conferences) {
                    String focus = conference.getLastKnowFocus();
                    if (focus == null) continue;
                    statsIQ.setTo(focus);
                    for (ComponentImpl component : components) {
                        try {
                            component.send(statsIQ);
                        }
                        catch (Exception ex) {
                            logger.error((Object)"Failed to publish statistics.");
                        }
                    }
                }
            }
        }
    }
}

