/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmyspaceiml;

import junit.framework.Assert;
import junit.framework.TestCase;
import net.sf.jmyspaceiml.MSIMConnection;
import net.sf.jmyspaceiml.MSIMException;
import net.sf.jmyspaceiml.MessageListener;
import net.sf.jmyspaceiml.packet.ActionMessage;
import net.sf.jmyspaceiml.packet.ErrorMessage;
import net.sf.jmyspaceiml.packet.InstantMessage;
import net.sf.jmyspaceiml.packet.MediaMessage;
import net.sf.jmyspaceiml.packet.PacketType;
import net.sf.jmyspaceiml.packet.ProfileMessage;
import net.sf.jmyspaceiml.packet.StatusMessage;

public class TestMSIMConnection
extends TestCase {
    private static final String GOOD_EMAIL = "";
    private static final String GOOD_PASSWORD = "";

    public void testGoodLogin() {
        MSIMConnection connection = new MSIMConnection();
        connection.connect();
        connection.login("", "");
        TestMSIMConnection.assertTrue((boolean)connection.isConnected());
        connection.disconnect();
        TestMSIMConnection.assertFalse((boolean)connection.isConnected());
    }

    public void testBadpassword() {
        MSIMConnection connection = new MSIMConnection();
        try {
            connection.connect();
            connection.login("", "badpassword");
        }
        catch (MSIMException e) {
            TestMSIMConnection.assertEquals((String)"260", (String)e.getMessage());
        }
        TestMSIMConnection.assertFalse((boolean)connection.isConnected());
    }

    public void testInvalidEmail() {
        MSIMConnection connection = new MSIMConnection();
        try {
            connection.connect();
            connection.login("rtg54@hotmail", "");
        }
        catch (MSIMException e) {
            TestMSIMConnection.assertEquals((String)"260", (String)e.getMessage());
        }
        TestMSIMConnection.assertFalse((boolean)connection.isConnected());
    }

    public void testSendMessage() {
        MSIMConnection connection = new MSIMConnection();
        connection.connect();
        connection.login("", "");
        TestMSIMConnection.assertTrue((boolean)connection.isConnected());
        InstantMessage message = new InstantMessage();
        message.setTo("6221");
        message.setBody("boo");
        connection.sendPacket(message);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        connection.disconnect();
        TestMSIMConnection.assertFalse((boolean)connection.isConnected());
    }

    public void testMessageListenerOne() {
        MSIMConnection connection = new MSIMConnection();
        MessageListener listener = new MessageListener(){

            public void processIncomingMessage(InstantMessage message) {
                Assert.assertEquals((Object)((Object)PacketType.INSTANT_MESSAGE), (Object)((Object)message.getType()));
                Assert.assertEquals((String)"jack", (String)message.getTo());
                Assert.assertEquals((String)"boo", (String)message.getBody());
            }

            public void processIncomingMessage(ProfileMessage message) {
            }

            public void processIncomingMessage(StatusMessage message) {
            }

            public void processIncomingMessage(ActionMessage message) {
            }

            public void processIncomingMessage(MediaMessage message) {
            }

            public void processIncomingMessage(ErrorMessage message) {
            }
        };
        TestMSIMConnection.assertEquals((int)0, (int)connection.getMessageListeners().size());
        connection.addMessageListener(listener);
        TestMSIMConnection.assertEquals((int)1, (int)connection.getMessageListeners().size());
        InstantMessage message = new InstantMessage();
        message.setTo("jack");
        message.setBody("boo");
        connection.invokeMessageListener(message);
        connection.removeMessageListener(listener);
        TestMSIMConnection.assertEquals((int)0, (int)connection.getMessageListeners().size());
    }

    public void testMessageListenerTwo() {
        MSIMConnection connection = new MSIMConnection();
        TestMSIMConnection.assertEquals((int)0, (int)connection.getMessageListeners().size());
        MessageListener listener = null;
        connection.addMessageListener(listener);
        TestMSIMConnection.assertEquals((int)0, (int)connection.getMessageListeners().size());
    }

    public void testGetRoster() {
        MSIMConnection connection = new MSIMConnection();
        connection.connect();
        connection.login("", "");
        TestMSIMConnection.assertTrue((boolean)connection.isConnected());
        connection.getContactManager().getContacts();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        connection.disconnect();
        TestMSIMConnection.assertFalse((boolean)connection.isConnected());
    }
}

