/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.tlv;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTlvChain
implements TlvChain {
    private int totalSize;

    protected AbstractTlvChain() {
        this(-1);
    }

    protected AbstractTlvChain(int totalSize) {
        DefensiveTools.checkRange((int)totalSize, (String)"totalSize", (int)-1);
        this.totalSize = totalSize;
    }

    protected final synchronized void copy(TlvChain chain) {
        DefensiveTools.checkNull((Object)chain, (String)"chain");
        this.totalSize = this.getTotalSize();
        List<Tlv> tlvList = this.getTlvList();
        Map<Integer, List<Tlv>> tlvMap = this.getTlvMap();
        tlvList.clear();
        tlvMap.clear();
        if (chain instanceof AbstractTlvChain) {
            AbstractTlvChain atc = (AbstractTlvChain)chain;
            tlvList.addAll(atc.getTlvList());
            tlvMap.putAll(atc.getTlvMap());
        } else {
            for (Tlv tlv : chain.getTlvs()) {
                this.addTlvImpl(tlv);
            }
        }
    }

    protected final synchronized void initFromBlock(ByteBlock block, int maxTlvs) {
        DefensiveTools.checkNull((Object)block, (String)"block");
        DefensiveTools.checkRange((int)maxTlvs, (String)"maxTlvs", (int)-1);
        ByteBlock next = block;
        int start = next.getOffset();
        for (int i = 0; Tlv.isValidTLV(next) && (maxTlvs == -1 || i < maxTlvs); ++i) {
            Tlv tlv = new Tlv(next);
            this.addTlvImpl(tlv);
            next = next.subBlock(tlv.getTotalSize());
        }
        this.totalSize = next.getOffset() - start;
    }

    protected void addTlvImpl(Tlv tlv) {
        DefensiveTools.checkNull((Object)tlv, (String)"tlv");
        this.getTlvList().add(tlv);
        Integer type = tlv.getType();
        List<Tlv> siblings = this.getTlvMap().get(type);
        if (siblings == null) {
            siblings = this.createSiblingList();
            this.getTlvMap().put(type, siblings);
        }
        siblings.add(tlv);
    }

    @Override
    public boolean hasTlv(int type) {
        DefensiveTools.checkRange((int)type, (String)"type", (int)0);
        return this.getTlvMap().containsKey(type);
    }

    @Override
    public List<Tlv> getTlvs() {
        return DefensiveTools.getUnmodifiableCopy(this.getTlvList());
    }

    @Override
    public Iterator<Tlv> iterator() {
        return this.getTlvs().iterator();
    }

    @Override
    public int getTlvCount() {
        return this.getTlvList().size();
    }

    @Override
    public Tlv getFirstTlv(int type) {
        DefensiveTools.checkRange((int)type, (String)"type", (int)0);
        List<Tlv> list = this.getTlvMap().get(type);
        return list == null ? null : list.get(0);
    }

    @Override
    public Tlv getLastTlv(int type) {
        DefensiveTools.checkRange((int)type, (String)"type", (int)0);
        List<Tlv> list = this.getTlvMap().get(type);
        return list == null ? null : list.get(list.size() - 1);
    }

    @Override
    public List<Tlv> getTlvs(int type) {
        DefensiveTools.checkRange((int)type, (String)"type", (int)0);
        List<Tlv> list = this.getTlvMap().get(type);
        if (list == null) {
            return DefensiveTools.emptyList();
        }
        return DefensiveTools.getUnmodifiableCopy(list);
    }

    @Override
    public String getString(int type) {
        DefensiveTools.checkRange((int)type, (String)"type", (int)0);
        return this.hasTlv(type) ? this.getLastTlv(type).getDataAsString() : null;
    }

    @Override
    public String getUtf8String(int type) {
        DefensiveTools.checkRange((int)type, (String)"type", (int)0);
        return this.hasTlv(type) ? this.getLastTlv(type).getDataAsUtf8() : null;
    }

    @Override
    @Nullable
    public String getString(int type, @Nullable String charset) {
        DefensiveTools.checkRange((int)type, (String)"type", (int)0);
        if (!this.hasTlv(type)) {
            return null;
        }
        ByteBlock stringBlock = this.getLastTlv(type).getData();
        return OscarTools.getString(stringBlock, charset);
    }

    @Override
    public int getUShort(int type) {
        DefensiveTools.checkRange((int)type, (String)"type", (int)0);
        return this.hasTlv(type) ? this.getLastTlv(type).getDataAsUShort() : -1;
    }

    @Override
    public long getUInt(int type) {
        Tlv tlv = this.getFirstTlv(type);
        if (tlv == null) {
            return -1L;
        }
        return tlv.getDataAsUInt();
    }

    @Override
    public synchronized int getTotalSize() {
        return this.totalSize;
    }

    public long getWritableLength() {
        int sum = 0;
        for (Tlv tlv : this.getTlvList()) {
            sum = (int)((long)sum + tlv.getWritableLength());
        }
        return sum;
    }

    public void write(OutputStream out) throws IOException {
        for (Tlv tlv : this.getTlvList()) {
            tlv.write(out);
        }
    }

    protected abstract List<Tlv> getTlvList();

    protected abstract Map<Integer, List<Tlv>> getTlvMap();

    protected List<Tlv> createSiblingList() {
        return new LinkedList<Tlv>();
    }

    public String toString() {
        return this.getTlvList().toString();
    }
}

