/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import net.java.sip.communicator.impl.protocol.jabber.JingleNodesCandidate;
import org.ice4j.TransportAddress;
import org.ice4j.socket.DelegatingDatagramSocket;
import org.ice4j.socket.StunDatagramPacketFilter;

public class JingleNodesCandidateDatagramSocket
extends DatagramSocket {
    private TransportAddress localEndPoint = null;
    private JingleNodesCandidate jingleNodesCandidate;
    private long nbReceivedRtpPackets = 0L;
    private long nbSentRtpPackets = 0L;
    private long nbLostRtpPackets = 0L;
    private long lastRtpSequenceNumber = -1L;
    private long lastLostPacketLogTime = 0L;

    public JingleNodesCandidateDatagramSocket(JingleNodesCandidate jingleNodesCandidate, TransportAddress localEndPoint) throws SocketException {
        super((SocketAddress)null);
        this.jingleNodesCandidate = jingleNodesCandidate;
        this.localEndPoint = localEndPoint;
    }

    @Override
    public void send(DatagramPacket p) throws IOException {
        byte[] data = p.getData();
        int dataLen = p.getLength();
        int dataOffset = p.getOffset();
        DatagramPacket packet = new DatagramPacket(data, dataOffset, dataLen, new InetSocketAddress(this.localEndPoint.getAddress(), this.localEndPoint.getPort()));
        super.send(packet);
        ++this.nbSentRtpPackets;
        DelegatingDatagramSocket.logPacketToPcap((DatagramPacket)packet, (long)this.nbSentRtpPackets, (boolean)true, (InetAddress)super.getLocalAddress(), (int)super.getLocalPort());
    }

    @Override
    public void receive(DatagramPacket p) throws IOException {
        super.receive(p);
        ++this.nbReceivedRtpPackets;
        DelegatingDatagramSocket.logPacketToPcap((DatagramPacket)p, (long)this.nbReceivedRtpPackets, (boolean)false, (InetAddress)super.getLocalAddress(), (int)super.getLocalPort());
        this.updateRtpLosses(p);
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.getLocalSocketAddress().getAddress();
    }

    @Override
    public int getLocalPort() {
        return this.getLocalSocketAddress().getPort();
    }

    @Override
    public InetSocketAddress getLocalSocketAddress() {
        return this.jingleNodesCandidate.getTransportAddress();
    }

    private void updateRtpLosses(DatagramPacket p) {
        if (!StunDatagramPacketFilter.isStunPacket((DatagramPacket)p)) {
            long newSeq = DelegatingDatagramSocket.getRtpSequenceNumber((DatagramPacket)p);
            if (this.lastRtpSequenceNumber != -1L) {
                this.nbLostRtpPackets += DelegatingDatagramSocket.getNbLost((long)this.lastRtpSequenceNumber, (long)newSeq);
            }
            this.lastRtpSequenceNumber = newSeq;
            this.lastLostPacketLogTime = DelegatingDatagramSocket.logRtpLosses((long)this.nbLostRtpPackets, (long)this.nbReceivedRtpPackets, (long)this.lastLostPacketLogTime);
        }
    }
}

