/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.server;

import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.services.server.AbstractSkeleton;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class HessianSkeleton
extends AbstractSkeleton {
    private Object _service;

    public HessianSkeleton(Object service, Class apiClass) {
        super(apiClass);
        this._service = service;
        if (!apiClass.isAssignableFrom(service.getClass())) {
            throw new IllegalArgumentException("Service " + service + " must be an instance of " + apiClass.getName());
        }
    }

    public void invoke(HessianInput in, HessianOutput out) throws Throwable {
        in.startCall();
        Method method = this.getMethod(in.getMethod());
        if (method == null) {
            if ("_hessian_getAttribute".equals(in.getMethod())) {
                String attrName = in.readString();
                in.completeCall();
                String value = null;
                if ("java.api.class".equals(attrName)) {
                    value = this.getAPIClassName();
                } else if ("java.home.class".equals(attrName)) {
                    value = this.getHomeClassName();
                } else if ("java.object.class".equals(attrName)) {
                    value = this.getObjectClassName();
                }
                out.startReply();
                out.writeObject(value);
                out.completeReply();
                return;
            }
            if (method == null) {
                out.startReply();
                out.writeFault("NoSuchMethodException", "The service has no method named: " + in.getMethod(), null);
                out.completeReply();
                return;
            }
        }
        Class<?>[] args = method.getParameterTypes();
        Object[] values = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            values[i] = in.readObject(args[i]);
        }
        in.completeCall();
        Object result = null;
        try {
            result = method.invoke(this._service, values);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            out.startReply();
            out.writeFault("ServiceException", e.getMessage(), e);
            out.completeReply();
            return;
        }
        out.startReply();
        out.writeObject(result);
        out.completeReply();
    }
}

