/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util.executor;

import com.hazelcast.logging.ILogger;
import com.hazelcast.util.executor.StripedRunnable;
import com.hazelcast.util.executor.TimeoutRunnable;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class StripedExecutor
implements Executor {
    public static final AtomicLong THREAD_ID_GENERATOR = new AtomicLong();
    private final int size;
    private final Worker[] workers;
    private final Random rand = new Random();
    private final int maximumQueueSize;
    private final ILogger logger;
    private volatile boolean live = true;

    public StripedExecutor(ILogger logger, String threadNamePrefix, ThreadGroup threadGroup, int threadCount, int maximumQueueSize) {
        this.logger = logger;
        this.maximumQueueSize = maximumQueueSize;
        this.size = threadCount;
        this.workers = new Worker[threadCount];
        for (int i = 0; i < threadCount; ++i) {
            Worker worker = new Worker(threadGroup, threadNamePrefix);
            worker.start();
            this.workers[i] = worker;
        }
    }

    public int getWorkQueueSize() {
        int size = 0;
        for (Worker worker : this.workers) {
            size += worker.workQueue.size();
        }
        return size;
    }

    public void shutdown() {
        this.live = false;
        for (Worker worker : this.workers) {
            worker.workQueue.clear();
            worker.interrupt();
        }
    }

    public boolean isLive() {
        return this.live;
    }

    @Override
    public void execute(Runnable command) {
        if (command == null) {
            throw new NullPointerException("command can't be null");
        }
        if (!this.live) {
            throw new RejectedExecutionException("Executor is terminated!");
        }
        Worker worker = this.getWorker(command);
        worker.schedule(command);
    }

    private Worker getWorker(Runnable command) {
        int key = command instanceof StripedRunnable ? ((StripedRunnable)command).getKey() : this.rand.nextInt();
        int index = key == Integer.MIN_VALUE ? 0 : Math.abs(key) % this.size;
        return this.workers[index];
    }

    private final class Worker
    extends Thread {
        private final BlockingQueue<Runnable> workQueue;

        private Worker(ThreadGroup threadGroup, String threadNamePrefix) {
            super(threadGroup, threadNamePrefix + "-" + THREAD_ID_GENERATOR.incrementAndGet());
            this.workQueue = new LinkedBlockingQueue<Runnable>(StripedExecutor.this.maximumQueueSize);
        }

        private void schedule(Runnable command) {
            boolean offered;
            long timeout = 0L;
            TimeUnit timeUnit = TimeUnit.SECONDS;
            if (command instanceof TimeoutRunnable) {
                TimeoutRunnable timeoutRunnable = (TimeoutRunnable)command;
                timeout = timeoutRunnable.getTimeout();
                timeUnit = timeoutRunnable.getTimeUnit();
            }
            try {
                offered = timeout == 0L ? this.workQueue.offer(command) : this.workQueue.offer(command, timeout, timeUnit);
            }
            catch (InterruptedException e) {
                throw new RejectedExecutionException("Thread is interrupted while offering work");
            }
            if (!offered) {
                throw new RejectedExecutionException("Task: " + command + " is rejected, the worker queue is full!");
            }
        }

        @Override
        public void run() {
            block4: while (true) {
                try {
                    while (true) {
                        try {
                            Runnable task = this.workQueue.take();
                            this.process(task);
                            continue block4;
                        }
                        catch (InterruptedException e) {
                            if (StripedExecutor.this.live) continue;
                            return;
                        }
                        break;
                    }
                }
                catch (Throwable t) {
                    StripedExecutor.this.logger.severe(this.getName() + " caught an exception", t);
                    continue;
                }
                break;
            }
        }

        private void process(Runnable task) {
            try {
                task.run();
            }
            catch (Throwable e) {
                StripedExecutor.this.logger.severe(this.getName() + " caught an exception while processing task:" + task, e);
            }
        }
    }
}

