/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl.record;

import com.hazelcast.core.Member;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.replicatedmap.impl.operation.ReplicatedMapDataSerializerHook;
import com.hazelcast.replicatedmap.impl.record.VectorClockTimestamp;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class ReplicatedRecord<K, V>
implements IdentifiedDataSerializable {
    private static final AtomicLongFieldUpdater<ReplicatedRecord> HITS_UPDATER = AtomicLongFieldUpdater.newUpdater(ReplicatedRecord.class, "hits");
    private static final AtomicLongFieldUpdater<ReplicatedRecord> LAST_ACCESS_TIME_UPDATER = AtomicLongFieldUpdater.newUpdater(ReplicatedRecord.class, "hits");
    private static final AtomicReferenceFieldUpdater<ReplicatedRecord, VectorClockTimestamp> VECTOR_CLOCK_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ReplicatedRecord.class, VectorClockTimestamp.class, "vectorClockTimestamp");
    private volatile long hits;
    private volatile long lastAccessTime;
    private K key;
    private V value;
    private volatile VectorClockTimestamp vectorClockTimestamp;
    private int latestUpdateHash;
    private long ttlMillis;
    private volatile long updateTime = Clock.currentTimeMillis();

    public ReplicatedRecord() {
    }

    public ReplicatedRecord(K key, V value, VectorClockTimestamp vectorClockTimestamp, int hash, long ttlMillis) {
        this.key = key;
        this.value = value;
        this.vectorClockTimestamp = vectorClockTimestamp;
        this.latestUpdateHash = hash;
        this.ttlMillis = ttlMillis;
    }

    public K getKey() {
        this.access();
        return this.key;
    }

    public V getValue() {
        this.access();
        return this.value;
    }

    public boolean isTombstone() {
        return this.value == null;
    }

    public VectorClockTimestamp getVectorClockTimestamp() {
        return this.vectorClockTimestamp;
    }

    public VectorClockTimestamp applyAndIncrementVectorClock(VectorClockTimestamp otherVectorClockTimestamp, Member member) {
        VectorClockTimestamp vectorClockTimestampCopy;
        VectorClockTimestamp vectorClockTimestamp;
        do {
            vectorClockTimestamp = this.vectorClockTimestamp;
            vectorClockTimestampCopy = VectorClockTimestamp.copyVector(vectorClockTimestamp);
            vectorClockTimestampCopy = vectorClockTimestampCopy.applyVector0(otherVectorClockTimestamp);
        } while (!VECTOR_CLOCK_UPDATER.compareAndSet(this, vectorClockTimestamp, vectorClockTimestampCopy = vectorClockTimestampCopy.incrementClock0(member)));
        return vectorClockTimestampCopy;
    }

    public VectorClockTimestamp applyVectorClock(VectorClockTimestamp otherVectorClockTimestamp) {
        VectorClockTimestamp vectorClockTimestampCopy;
        VectorClockTimestamp vectorClockTimestamp;
        do {
            vectorClockTimestamp = this.vectorClockTimestamp;
            vectorClockTimestampCopy = VectorClockTimestamp.copyVector(vectorClockTimestamp);
        } while (!VECTOR_CLOCK_UPDATER.compareAndSet(this, vectorClockTimestamp, vectorClockTimestampCopy = vectorClockTimestampCopy.applyVector0(otherVectorClockTimestamp)));
        return vectorClockTimestampCopy;
    }

    public VectorClockTimestamp incrementVectorClock(Member member) {
        VectorClockTimestamp vectorClockTimestampCopy;
        VectorClockTimestamp vectorClockTimestamp;
        do {
            vectorClockTimestamp = this.vectorClockTimestamp;
            vectorClockTimestampCopy = VectorClockTimestamp.copyVector(vectorClockTimestamp);
        } while (!VECTOR_CLOCK_UPDATER.compareAndSet(this, vectorClockTimestamp, vectorClockTimestampCopy = vectorClockTimestampCopy.incrementClock0(member)));
        return vectorClockTimestampCopy;
    }

    public long getTtlMillis() {
        return this.ttlMillis;
    }

    public V setValue(V value, int hash, long ttlMillis) {
        this.access();
        V oldValue = this.value;
        this.value = value;
        this.latestUpdateHash = hash;
        this.updateTime = Clock.currentTimeMillis();
        this.ttlMillis = ttlMillis;
        return oldValue;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public int getLatestUpdateHash() {
        return this.latestUpdateHash;
    }

    public long getHits() {
        return this.hits;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void access() {
        HITS_UPDATER.incrementAndGet(this);
        LAST_ACCESS_TIME_UPDATER.set(this, Clock.currentTimeMillis());
    }

    @Override
    public int getFactoryId() {
        return ReplicatedMapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 1;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.key);
        out.writeObject(this.value);
        this.vectorClockTimestamp.writeData(out);
        out.writeInt(this.latestUpdateHash);
        out.writeLong(this.ttlMillis);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.key = in.readObject();
        this.value = in.readObject();
        this.vectorClockTimestamp = new VectorClockTimestamp();
        this.vectorClockTimestamp.readData(in);
        this.latestUpdateHash = in.readInt();
        this.ttlMillis = in.readLong();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicatedRecord that = (ReplicatedRecord)o;
        if (this.latestUpdateHash != that.latestUpdateHash) {
            return false;
        }
        if (this.ttlMillis != that.ttlMillis) {
            return false;
        }
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + this.latestUpdateHash;
        result = 31 * result + (int)(this.ttlMillis ^ this.ttlMillis >>> 32);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ReplicatedRecord{");
        sb.append("key=").append(this.key);
        sb.append(", value=").append(this.value);
        sb.append(", vector=").append(this.vectorClockTimestamp);
        sb.append(", latestUpdateHash=").append(this.latestUpdateHash);
        sb.append(", ttlMillis=").append(this.ttlMillis);
        sb.append('}');
        return sb.toString();
    }
}

