/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.atomiclong.client;

import com.hazelcast.client.ClientEngine;
import com.hazelcast.client.impl.client.PartitionClientRequest;
import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.concurrent.atomiclong.client.AtomicLongPortableHook;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.AtomicLongPermission;
import java.io.IOException;
import java.security.Permission;

public abstract class ReadRequest
extends PartitionClientRequest
implements Portable,
SecureRequest {
    protected String name;

    public ReadRequest() {
    }

    public ReadRequest(String name) {
        this.name = name;
    }

    @Override
    protected int getPartition() {
        ClientEngine clientEngine = this.getClientEngine();
        Data key = this.serializationService.toData(this.name);
        return clientEngine.getPartitionService().getPartitionId(key);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:atomicLongService";
    }

    @Override
    public int getFactoryId() {
        return AtomicLongPortableHook.F_ID;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public Permission getRequiredPermission() {
        return new AtomicLongPermission(this.name, "read");
    }
}

