/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.fec;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.util.Logger;

class FECReceiver
implements PacketTransformer {
    private static final Logger logger = Logger.getLogger(FECReceiver.class);
    private static final Comparator<? super Integer> seqNumComparator = new Comparator<Integer>(){

        @Override
        public int compare(Integer a, Integer b) {
            if (a.equals(b)) {
                return 0;
            }
            if (a > b) {
                if (a - b < 32768) {
                    return 1;
                }
                return -1;
            }
            if (b - a < 32768) {
                return -1;
            }
            return 1;
        }
    };
    private int nbFec = 0;
    private int nbRecovered = 0;
    private int ssrc;
    private static final int MEDIA_BUFF_SIZE = 16;
    private static final int FEC_BUFF_SIZE = 4;
    private static int OUTPUT_BUFFER_MAX_SIZE = 4;
    private final SortedMap<Integer, RawPacket> mediaPackets = new TreeMap<Integer, RawPacket>(seqNumComparator);
    private final SortedMap<Integer, RawPacket> fecPackets = new TreeMap<Integer, RawPacket>(seqNumComparator);
    private final Reconstructor reconstructor;
    private final ReorderBuffer outputBuffer;
    private final Set<RawPacket> packetsToRemove = new HashSet<RawPacket>();
    private boolean handleFec = true;
    private byte ulpfecPT;

    FECReceiver(int ssrc, byte ulpfecPT) {
        this.ssrc = ssrc;
        this.ulpfecPT = ulpfecPT;
        this.outputBuffer = new ReorderBuffer(ssrc, OUTPUT_BUFFER_MAX_SIZE);
        this.reconstructor = new Reconstructor(this.mediaPackets, ssrc);
        if (logger.isInfoEnabled()) {
            logger.info("New FECReceiver for SSRC=" + ssrc);
        }
    }

    @Override
    public RawPacket[] transform(RawPacket[] pkts) {
        return pkts;
    }

    @Override
    public synchronized RawPacket[] reverseTransform(RawPacket[] pkts) {
        for (int i = 0; i < pkts.length; ++i) {
            RawPacket pkt = pkts[i];
            if (pkt == null) continue;
            if (pkt.getPayloadType() == this.ulpfecPT) {
                ++this.nbFec;
                pkts[i] = null;
                if (!this.handleFec) continue;
                this.saveFec(pkt);
                continue;
            }
            if (!this.handleFec) continue;
            this.saveMedia(pkt);
        }
        if (this.handleFec) {
            this.packetsToRemove.clear();
            for (Map.Entry<Integer, RawPacket> entry : this.fecPackets.entrySet()) {
                RawPacket fecPacket = entry.getValue();
                this.reconstructor.setFecPacket(fecPacket);
                if (this.reconstructor.numMissing == 0) {
                    this.packetsToRemove.add(fecPacket);
                    continue;
                }
                if (!this.reconstructor.canRecover()) continue;
                this.packetsToRemove.add(fecPacket);
                RawPacket recovered = this.reconstructor.recover();
                if (recovered == null) continue;
                ++this.nbRecovered;
                this.saveMedia(recovered);
                boolean found = false;
                for (int i = 0; i < pkts.length; ++i) {
                    if (pkts[i] != null) continue;
                    pkts[i] = recovered;
                    found = true;
                    break;
                }
                if (found) continue;
                RawPacket[] pkts2 = new RawPacket[pkts.length + 1];
                System.arraycopy(pkts, 0, pkts2, 0, pkts.length);
                pkts2[pkts.length] = recovered;
                pkts = pkts2;
            }
            for (RawPacket p : this.packetsToRemove) {
                this.fecPackets.remove(p.getSequenceNumber());
            }
        }
        return this.outputBuffer.reverseTransform(pkts);
    }

    @Override
    public void close() {
        if (logger.isInfoEnabled()) {
            logger.info("Closing FECReceiver for SSRC=" + this.ssrc + ". Received " + this.nbFec + " ulpfec packets, recovered " + this.nbRecovered + " media packets.");
        }
    }

    public void setUlpfecPT(byte ulpfecPT) {
        this.ulpfecPT = ulpfecPT;
    }

    private void saveFec(RawPacket p) {
        if (this.fecPackets.size() >= 4) {
            this.fecPackets.remove(this.fecPackets.firstKey());
        }
        this.fecPackets.put(p.getSequenceNumber(), p);
    }

    private void saveMedia(RawPacket p) {
        RawPacket newMedia;
        if (this.mediaPackets.size() < 16) {
            newMedia = new RawPacket();
            newMedia.setBuffer(new byte[1500]);
            newMedia.setOffset(0);
        } else {
            newMedia = (RawPacket)this.mediaPackets.remove(this.mediaPackets.firstKey());
        }
        int pLen = p.getLength();
        if (pLen > newMedia.getBuffer().length) {
            newMedia.setBuffer(new byte[pLen]);
        }
        System.arraycopy(p.getBuffer(), p.getOffset(), newMedia.getBuffer(), 0, pLen);
        newMedia.setLength(pLen);
        this.mediaPackets.put(newMedia.getSequenceNumber(), newMedia);
    }

    private class ReorderBuffer
    implements PacketTransformer {
        private int maxSize;
        private int ssrc;
        private int lastSent = -1;
        private SortedMap<Integer, RawPacket> buffer = new TreeMap<Integer, RawPacket>();

        ReorderBuffer(int ssrc, int maxSize) {
            this.ssrc = ssrc;
            this.maxSize = maxSize;
        }

        @Override
        public RawPacket[] reverseTransform(RawPacket[] pkts) {
            for (int i = 0; i < pkts.length; ++i) {
                RawPacket pkt = pkts[i];
                if (pkt == null || pkt.getPayloadType() == 0) continue;
                int pktSeq = pkt.getSequenceNumber();
                if (seqNumComparator.compare(pktSeq, this.lastSent) == -1 || pktSeq == this.lastSent) continue;
                this.buffer.put(pktSeq, pkt);
                pkts[i] = null;
            }
            if (!this.buffer.isEmpty()) {
                if (this.buffer.size() >= this.maxSize) {
                    pkts = this.addUntilMissing(pkts);
                } else if (this.buffer.firstKey() == (this.lastSent + 1) % 65536) {
                    pkts = this.addUntilMissing(pkts);
                }
            }
            return pkts;
        }

        @Override
        public RawPacket[] transform(RawPacket[] pkts) {
            return pkts;
        }

        @Override
        public void close() {
        }

        private RawPacket[] addUntilMissing(RawPacket[] pkts) {
            if (this.buffer.isEmpty()) {
                return pkts;
            }
            int count = 1;
            int firstSeq = ((RawPacket)this.buffer.get(this.buffer.firstKey())).getSequenceNumber();
            while (this.buffer.containsKey(firstSeq + count)) {
                ++count;
            }
            int free = 0;
            for (RawPacket pkt : pkts) {
                if (pkt != null) continue;
                ++free;
            }
            if (free < count) {
                RawPacket[] pkts2 = new RawPacket[pkts.length - free + count];
                System.arraycopy(pkts, 0, pkts2, 0, pkts.length);
                pkts = pkts2;
            }
            int freeIdx = 0;
            for (int i = 0; i < count; ++i) {
                while (pkts[freeIdx] != null) {
                    ++freeIdx;
                }
                this.lastSent = this.buffer.firstKey();
                pkts[freeIdx] = (RawPacket)this.buffer.remove(this.lastSent);
            }
            return pkts;
        }

        private int getLastSeq(RawPacket[] pkts) {
            int last = -1;
            for (RawPacket pkt : pkts) {
                if (pkt == null) continue;
                int cur = pkt.getSequenceNumber();
                if (last != -1 && seqNumComparator.compare(cur, last) != 1) continue;
                last = cur;
            }
            return last;
        }

        private void reset() {
            this.lastSent = -1;
        }
    }

    private class Reconstructor {
        private Set<RawPacket> neededPackets = new HashSet<RawPacket>();
        private RawPacket fecPacket = null;
        private int numMissing = -1;
        private int sequenceNumber = -1;
        private int ssrc;
        private Map<Integer, RawPacket> mediaPackets;

        Reconstructor(Map<Integer, RawPacket> mediaPackets, int ssrc) {
            this.mediaPackets = mediaPackets;
            this.ssrc = ssrc;
        }

        private boolean canRecover() {
            return this.numMissing == 1;
        }

        private void setFecPacket(RawPacket p) {
            this.neededPackets.clear();
            this.numMissing = 0;
            this.sequenceNumber = -1;
            this.fecPacket = p;
            byte[] buf = this.fecPacket.getBuffer();
            int idx = this.fecPacket.getOffset() + this.fecPacket.getHeaderLength();
            int maskLen = (buf[idx] & 0x40) == 0 ? 2 : 6;
            int base = this.fecPacket.readUnsignedShortAsInt(this.fecPacket.getHeaderLength() + 2);
            idx += 12;
            block0: for (int i = 0; i < maskLen; ++i) {
                for (int j = 0; j < 8; ++j) {
                    if ((buf[idx + i] & (1 << 7 - j & 0xFF)) != 0) {
                        RawPacket pkt = this.mediaPackets.get(base + i * 8 + j);
                        if (pkt != null) {
                            this.neededPackets.add(pkt);
                        } else {
                            this.sequenceNumber = base + i * 8 + j;
                            ++this.numMissing;
                        }
                    }
                    if (this.numMissing > 1) break block0;
                }
            }
            if (this.numMissing != 1) {
                this.sequenceNumber = -1;
            }
        }

        private RawPacket recover() {
            int protectionLength;
            if (!this.canRecover()) {
                return null;
            }
            byte[] fecBuf = this.fecPacket.getBuffer();
            int idx = this.fecPacket.getOffset() + this.fecPacket.getHeaderLength();
            int lengthRecovery = (fecBuf[idx + 8] & 0xFF) << 8 | fecBuf[idx + 9] & 0xFF;
            for (RawPacket p : this.neededPackets) {
                lengthRecovery ^= p.getLength() - 12;
            }
            byte[] recoveredBuf = new byte[(lengthRecovery &= 0xFFFF) + 12];
            System.arraycopy(fecBuf, idx, recoveredBuf, 0, 8);
            for (RawPacket p : this.neededPackets) {
                int pOffset = p.getOffset();
                byte[] pBuf = p.getBuffer();
                for (int i = 0; i < 8; ++i) {
                    int n = i;
                    recoveredBuf[n] = (byte)(recoveredBuf[n] ^ pBuf[pOffset + i]);
                }
            }
            recoveredBuf[0] = (byte)(recoveredBuf[0] & 0x3F);
            recoveredBuf[0] = (byte)(recoveredBuf[0] | 0x80);
            boolean longMask = (fecBuf[idx] & 0x40) != 0;
            if ((protectionLength = (fecBuf[idx += 10] & 0xFF) << 8 | fecBuf[idx + 1] & 0xFF) < lengthRecovery) {
                logger.warn("Recovered only a partial RTP packet. Discarding.");
                return null;
            }
            idx += 4;
            if (longMask) {
                idx += 4;
            }
            System.arraycopy(fecBuf, idx, recoveredBuf, 12, lengthRecovery);
            for (RawPacket p : this.neededPackets) {
                byte[] pBuf = p.getBuffer();
                int pLen = p.getLength();
                int pOff = p.getOffset();
                for (int i = 12; i < lengthRecovery + 12 && i < pLen; ++i) {
                    int n = i;
                    recoveredBuf[n] = (byte)(recoveredBuf[n] ^ pBuf[pOff + i]);
                }
            }
            RawPacket recovered = new RawPacket(recoveredBuf, 0, lengthRecovery + 12);
            recovered.setSSRC(this.ssrc);
            recovered.setSequenceNumber(this.sequenceNumber);
            return recovered;
        }
    }
}

