/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.gui;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;

public abstract class UIContactDetail {
    private String prefix;
    private final String address;
    private final String displayName;
    private Map<Class<? extends OperationSet>, ProtocolProviderService> preferredProviders;
    private Map<Class<? extends OperationSet>, String> preferredProtocols;
    private final Collection<String> labels;
    private final String category;
    private final Object descriptor;

    public UIContactDetail(String address, String displayName, Object descriptor) {
        this(address, displayName, null, null, null, null, descriptor);
    }

    public UIContactDetail(String address, String displayName, String category, Collection<String> labels, Map<Class<? extends OperationSet>, ProtocolProviderService> preferredProviders, Map<Class<? extends OperationSet>, String> preferredProtocols, Object descriptor) {
        this.address = address;
        this.displayName = displayName;
        this.category = category;
        this.labels = labels;
        this.preferredProviders = preferredProviders;
        this.preferredProtocols = preferredProtocols;
        this.descriptor = descriptor;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getAddress() {
        if (this.prefix != null && this.prefix.trim().length() >= 0) {
            return this.prefix + this.address;
        }
        return this.address;
    }

    public String getCategory() {
        return this.category;
    }

    public Iterator<String> getLabels() {
        if (this.labels != null) {
            return this.labels.iterator();
        }
        return null;
    }

    public ProtocolProviderService getPreferredProtocolProvider(Class<? extends OperationSet> opSetClass) {
        if (this.preferredProviders != null) {
            return this.preferredProviders.get(opSetClass);
        }
        return null;
    }

    public void addPreferredProtocolProvider(Class<? extends OperationSet> opSetClass, ProtocolProviderService protocolProvider) {
        if (this.preferredProviders == null) {
            this.preferredProviders = new HashMap<Class<? extends OperationSet>, ProtocolProviderService>();
        }
        this.preferredProviders.put(opSetClass, protocolProvider);
    }

    public String getPreferredProtocol(Class<? extends OperationSet> opSetClass) {
        if (this.preferredProtocols != null) {
            return this.preferredProtocols.get(opSetClass);
        }
        return null;
    }

    public void addPreferredProtocol(Class<? extends OperationSet> opSetClass, String protocol) {
        if (this.preferredProtocols == null) {
            this.preferredProtocols = new HashMap<Class<? extends OperationSet>, String>();
        }
        this.preferredProtocols.put(opSetClass, protocol);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Object getDescriptor() {
        return this.descriptor;
    }

    public abstract PresenceStatus getPresenceStatus();
}

