/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.sctp4j;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jitsi.sctp4j.SctpNotification;
import org.jitsi.sctp4j.SctpSocket;
import org.jitsi.util.Logger;

public class Sctp {
    private static final Logger logger = Logger.getLogger(Sctp.class);
    public static final int MSG_NOTIFICATION = 8192;
    private static int sctpEngineCount;
    private static boolean initialized;
    private static Map<Long, SctpSocket> sockets;

    public static synchronized void init() {
        if (!initialized) {
            Sctp.usrsctp_init(0);
            initialized = true;
        }
    }

    private static native boolean usrsctp_init(int var0);

    public static SctpSocket createSocket(int localPort) {
        Long ptr = Sctp.usersctp_socket(localPort);
        if (ptr != 0L) {
            SctpSocket sock = new SctpSocket(ptr, localPort);
            sockets.put(ptr, sock);
            return sock;
        }
        return null;
    }

    private static native long usersctp_socket(int var0);

    static native int usrsctp_send(long var0, byte[] var2, boolean var3, int var4, int var5);

    static native void usrsctp_listen(long var0);

    static native boolean usrsctp_accept(long var0);

    static native boolean usrsctp_connect(long var0, int var2);

    static void closeSocket(Long ptr) {
        Sctp.usrsctp_close(ptr);
        sockets.remove(ptr);
    }

    private static native void usrsctp_close(long var0);

    public static synchronized void finish() throws IOException {
    }

    private static native boolean usrsctp_finish();

    public static int onSctpOutboundPacket(long socketAddr, byte[] data, int tos, int set_df) {
        SctpSocket socket = sockets.get(socketAddr);
        if (socket != null) {
            return socket.onSctpOut(data, tos, set_df);
        }
        logger.error("No SctpSocket found for ptr: " + socketAddr);
        return -1;
    }

    public static void onSctpInboundPacket(long socketAddr, final byte[] data, final int sid, final int ssn, final int tsn, final long ppid, final int context, final int flags) {
        final SctpSocket socket = sockets.get(socketAddr);
        if (socket != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if ((flags & 0x2000) > 0) {
                        SctpNotification notification = SctpNotification.parse(data);
                        socket.onNotification(notification);
                    } else {
                        socket.onSctpIn(data, sid, ssn, tsn, ppid, context, flags);
                    }
                }
            }).start();
        } else {
            logger.error("No SctpSocket found for ptr: " + socketAddr);
        }
    }

    static void onConnIn(long socketPtr, byte[] packet) {
        Sctp.on_network_in(socketPtr, packet);
    }

    private static native void on_network_in(long var0, byte[] var2);

    static {
        String lib = "jnsctp";
        try {
            System.loadLibrary(lib);
        }
        catch (Throwable t) {
            logger.error("Failed to load native library " + lib + ": " + t.getMessage());
            throw new RuntimeException(t);
        }
        sockets = new HashMap<Long, SctpSocket>();
    }
}

