/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp.translator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.media.Format;
import javax.media.format.UnsupportedFormatException;
import javax.media.protocol.DataSource;
import javax.media.rtp.GlobalReceptionStats;
import javax.media.rtp.GlobalTransmissionStats;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.RTPManager;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.RemoteListener;
import javax.media.rtp.SendStream;
import javax.media.rtp.SendStreamListener;
import javax.media.rtp.SessionListener;
import javax.media.rtp.event.ReceiveStreamEvent;
import net.sf.fmj.media.rtp.RTPSessionMgr;
import org.jitsi.impl.neomedia.RTCPFeedbackMessagePacket;
import org.jitsi.impl.neomedia.protocol.FakePushBufferDataSource;
import org.jitsi.impl.neomedia.rtp.StreamRTPManager;
import org.jitsi.impl.neomedia.rtp.translator.OutputDataStreamImpl;
import org.jitsi.impl.neomedia.rtp.translator.PushSourceStreamDesc;
import org.jitsi.impl.neomedia.rtp.translator.RTPConnectorDesc;
import org.jitsi.impl.neomedia.rtp.translator.RTPConnectorImpl;
import org.jitsi.impl.neomedia.rtp.translator.SendStreamDesc;
import org.jitsi.impl.neomedia.rtp.translator.SendStreamImpl;
import org.jitsi.impl.neomedia.rtp.translator.StreamRTPManagerDesc;
import org.jitsi.service.neomedia.AbstractRTPTranslator;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.util.Logger;

public class RTPTranslatorImpl
extends AbstractRTPTranslator
implements ReceiveStreamListener {
    private static final Logger logger = Logger.getLogger(RTPTranslatorImpl.class);
    private static final boolean CREATE_FAKE_SEND_STREAM_IF_NECESSARY = false;
    private RTPConnectorImpl connector;
    private SendStream fakeSendStream;
    private final RTPManager manager = RTPManager.newInstance();
    private final List<SendStreamDesc> sendStreams = new LinkedList<SendStreamDesc>();
    private final List<StreamRTPManagerDesc> streamRTPManagers = new ArrayList<StreamRTPManagerDesc>();

    public RTPTranslatorImpl() {
        this.manager.addReceiveStreamListener(this);
    }

    public synchronized void addFormat(StreamRTPManager streamRTPManager, Format format, int payloadType) {
        this.manager.addFormat(format, payloadType);
        this.getStreamRTPManagerDesc(streamRTPManager, true).addFormat(format, payloadType);
    }

    public synchronized void addReceiveStreamListener(StreamRTPManager streamRTPManager, ReceiveStreamListener listener) {
        this.getStreamRTPManagerDesc(streamRTPManager, true).addReceiveStreamListener(listener);
    }

    public void addRemoteListener(StreamRTPManager streamRTPManager, RemoteListener listener) {
        this.manager.addRemoteListener(listener);
    }

    public void addSendStreamListener(StreamRTPManager streamRTPManager, SendStreamListener listener) {
    }

    public void addSessionListener(StreamRTPManager streamRTPManager, SessionListener listener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void closeFakeSendStreamIfNotNecessary() {
        block8: {
            try {
                if (this.sendStreams.isEmpty() && this.streamRTPManagers.size() >= 2 || this.fakeSendStream == null) break block8;
                try {
                    this.fakeSendStream.close();
                }
                catch (NullPointerException npe) {
                    logger.error("Failed to close fake send stream", npe);
                }
                finally {
                    this.fakeSendStream = null;
                }
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                if (!logger.isDebugEnabled()) break block8;
                logger.debug("Failed to close the fake SendStream of this RTPTranslator.", t);
            }
        }
    }

    synchronized void closeSendStream(SendStreamDesc sendStreamDesc) {
        if (this.sendStreams.contains(sendStreamDesc) && sendStreamDesc.getSendStreamCount() < 1) {
            SendStream sendStream = sendStreamDesc.sendStream;
            try {
                sendStream.close();
            }
            catch (NullPointerException npe) {
                logger.error("Failed to close send stream", npe);
            }
            this.sendStreams.remove(sendStreamDesc);
        }
    }

    private synchronized void createFakeSendStreamIfNecessary() {
        if (this.fakeSendStream == null && this.sendStreams.isEmpty() && this.streamRTPManagers.size() > 1) {
            Format supportedFormat = null;
            for (StreamRTPManagerDesc s : this.streamRTPManagers) {
                Format[] formats = s.getFormats();
                if (formats == null || formats.length <= 0) continue;
                for (Format f : formats) {
                    if (f == null) continue;
                    supportedFormat = f;
                    break;
                }
                if (supportedFormat == null) continue;
                break;
            }
            if (supportedFormat != null) {
                try {
                    this.fakeSendStream = this.manager.createSendStream(new FakePushBufferDataSource(supportedFormat), 0);
                }
                catch (Throwable t) {
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    logger.error("Failed to create a fake SendStream to ensure that this RTPTranslator is able to disperse RTP and RTCP received from remote peers even when the local peer is not generating media to be transmitted.", t);
                }
            }
        }
    }

    public synchronized SendStream createSendStream(StreamRTPManager streamRTPManager, DataSource dataSource, int streamIndex) throws IOException, UnsupportedFormatException {
        SendStream sendStream;
        SendStreamDesc sendStreamDesc = null;
        for (SendStreamDesc s : this.sendStreams) {
            if (s.dataSource != dataSource || s.streamIndex != streamIndex) continue;
            sendStreamDesc = s;
            break;
        }
        if (sendStreamDesc == null && (sendStream = this.manager.createSendStream(dataSource, streamIndex)) != null) {
            sendStreamDesc = new SendStreamDesc(this, dataSource, streamIndex, sendStream);
            this.sendStreams.add(sendStreamDesc);
            this.closeFakeSendStreamIfNotNecessary();
        }
        return sendStreamDesc == null ? null : sendStreamDesc.getSendStream(streamRTPManager, true);
    }

    @Override
    public synchronized void dispose() {
        this.manager.removeReceiveStreamListener(this);
        try {
            this.manager.dispose();
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            logger.error("Failed to dispose of RTPManager", t);
        }
    }

    public synchronized void dispose(StreamRTPManager streamRTPManager) {
        Iterator<StreamRTPManagerDesc> streamRTPManagerIter = this.streamRTPManagers.iterator();
        while (streamRTPManagerIter.hasNext()) {
            StreamRTPManagerDesc streamRTPManagerDesc = streamRTPManagerIter.next();
            if (streamRTPManagerDesc.streamRTPManager != streamRTPManager) continue;
            RTPConnectorDesc connectorDesc = streamRTPManagerDesc.connectorDesc;
            if (connectorDesc != null) {
                if (this.connector != null) {
                    this.connector.removeConnector(connectorDesc);
                }
                connectorDesc.connector.close();
                streamRTPManagerDesc.connectorDesc = null;
            }
            streamRTPManagerIter.remove();
            this.closeFakeSendStreamIfNotNecessary();
            break;
        }
    }

    private synchronized StreamRTPManagerDesc findStreamRTPManagerDescByReceiveSSRC(int receiveSSRC, StreamRTPManagerDesc exclusion) {
        int count = this.streamRTPManagers.size();
        for (int i = 0; i < count; ++i) {
            StreamRTPManagerDesc s = this.streamRTPManagers.get(i);
            if (s == exclusion || !s.containsReceiveSSRC(receiveSSRC)) continue;
            return s;
        }
        return null;
    }

    public Object getControl(StreamRTPManager streamRTPManager, String controlType) {
        return this.manager.getControl(controlType);
    }

    public GlobalReceptionStats getGlobalReceptionStats(StreamRTPManager streamRTPManager) {
        return this.manager.getGlobalReceptionStats();
    }

    public GlobalTransmissionStats getGlobalTransmissionStats(StreamRTPManager streamRTPManager) {
        return this.manager.getGlobalTransmissionStats();
    }

    public long getLocalSSRC(StreamRTPManager streamRTPManager) {
        return ((RTPSessionMgr)this.manager).getLocalSSRC();
    }

    public synchronized Vector<ReceiveStream> getReceiveStreams(StreamRTPManager streamRTPManager) {
        Vector managerReceiveStreams;
        StreamRTPManagerDesc streamRTPManagerDesc = this.getStreamRTPManagerDesc(streamRTPManager, false);
        Vector<ReceiveStream> receiveStreams = null;
        if (streamRTPManagerDesc != null && (managerReceiveStreams = this.manager.getReceiveStreams()) != null) {
            receiveStreams = new Vector<ReceiveStream>(managerReceiveStreams.size());
            for (Object s : managerReceiveStreams) {
                ReceiveStream receiveStream = (ReceiveStream)s;
                int receiveSSRC = (int)receiveStream.getSSRC();
                if (!streamRTPManagerDesc.containsReceiveSSRC(receiveSSRC)) continue;
                receiveStreams.add(receiveStream);
            }
        }
        return receiveStreams;
    }

    public synchronized Vector<SendStream> getSendStreams(StreamRTPManager streamRTPManager) {
        Vector managerSendStreams = this.manager.getSendStreams();
        Vector<SendStreamImpl> sendStreams = null;
        if (managerSendStreams != null) {
            sendStreams = new Vector<SendStreamImpl>(managerSendStreams.size());
            for (SendStreamDesc sendStreamDesc : this.sendStreams) {
                SendStreamImpl sendStream;
                if (!managerSendStreams.contains(sendStreamDesc.sendStream) || (sendStream = sendStreamDesc.getSendStream(streamRTPManager, false)) == null) continue;
                sendStreams.add(sendStream);
            }
        }
        return sendStreams;
    }

    private synchronized StreamRTPManagerDesc getStreamRTPManagerDesc(StreamRTPManager streamRTPManager, boolean create) {
        StreamRTPManagerDesc s;
        for (StreamRTPManagerDesc s2 : this.streamRTPManagers) {
            if (s2.streamRTPManager != streamRTPManager) continue;
            return s2;
        }
        if (create) {
            s = new StreamRTPManagerDesc(streamRTPManager);
            this.streamRTPManagers.add(s);
        } else {
            s = null;
        }
        return s;
    }

    public synchronized void initialize(StreamRTPManager streamRTPManager, RTPConnector connector) {
        if (this.connector == null) {
            this.connector = new RTPConnectorImpl(this);
            this.manager.initialize(this.connector);
        }
        StreamRTPManagerDesc streamRTPManagerDesc = this.getStreamRTPManagerDesc(streamRTPManager, true);
        RTPConnectorDesc connectorDesc = streamRTPManagerDesc.connectorDesc;
        if (connectorDesc == null || connectorDesc.connector != connector) {
            if (connectorDesc != null) {
                this.connector.removeConnector(connectorDesc);
            }
            connectorDesc = connector == null ? null : new RTPConnectorDesc(streamRTPManagerDesc, connector);
            streamRTPManagerDesc.connectorDesc = connectorDesc;
            if (connectorDesc != null) {
                this.connector.addConnector(connectorDesc);
            }
        }
    }

    static void logRTCP(Object obj, String methodName, byte[] buffer, int offset, int length) {
        int rtcpLength;
        byte b1;
        int pt;
        byte b0;
        int v;
        if (length >= 8 && (v = ((b0 = buffer[offset]) & 0xC0) >>> 6) == 2 && (pt = (b1 = buffer[offset + 1]) & 0xFF) == 203 && (rtcpLength = (RTPTranslatorImpl.readUnsignedShort(buffer, offset + 2) + 1) * 4) <= length) {
            int sc = b0 & 0x1F;
            int off = offset + 4;
            int i = 0;
            int end = offset + length;
            while (i < sc && off + 4 <= end) {
                int ssrc = RTPTranslatorImpl.readInt(buffer, off);
                logger.trace(obj.getClass().getName() + '.' + methodName + ": RTCP BYE SSRC/CSRC " + Long.toString((long)ssrc & 0xFFFFFFFFL));
                ++i;
                off += 4;
            }
        }
    }

    synchronized int didRead(PushSourceStreamDesc streamDesc, byte[] buffer, int offset, int length) throws IOException {
        OutputDataStreamImpl outputStream;
        boolean data = streamDesc.data;
        StreamRTPManagerDesc streamRTPManagerDesc = streamDesc.connectorDesc.streamRTPManagerDesc;
        Format format = null;
        if (data) {
            if (!streamRTPManagerDesc.streamRTPManager.getMediaStream().getDirection().allowsReceiving()) {
                return length;
            }
            if (length >= 12 && (buffer[offset] & 0xC0) >>> 6 == 2) {
                int ssrc = RTPTranslatorImpl.readInt(buffer, offset + 8);
                if (!streamRTPManagerDesc.containsReceiveSSRC(ssrc)) {
                    if (this.findStreamRTPManagerDescByReceiveSSRC(ssrc, streamRTPManagerDesc) == null) {
                        streamRTPManagerDesc.addReceiveSSRC(ssrc);
                    } else {
                        return 0;
                    }
                }
                int pt = buffer[offset + 1] & 0x7F;
                format = streamRTPManagerDesc.getFormat(pt);
            }
        } else if (logger.isTraceEnabled()) {
            RTPTranslatorImpl.logRTCP(this, "read", buffer, offset, length);
        }
        OutputDataStreamImpl outputDataStreamImpl = outputStream = data ? this.connector.getDataOutputStream() : this.connector.getControlOutputStream();
        if (outputStream != null) {
            outputStream.write(buffer, offset, length, format, streamRTPManagerDesc);
        }
        return length;
    }

    public static int readInt(byte[] buf, int off) {
        return (buf[off++] & 0xFF) << 24 | (buf[off++] & 0xFF) << 16 | (buf[off++] & 0xFF) << 8 | buf[off] & 0xFF;
    }

    public static int readUnsignedShort(byte[] buf, int off) {
        return (buf[off++] & 0xFF) << 8 | buf[off] & 0xFF;
    }

    public synchronized void removeReceiveStreamListener(StreamRTPManager streamRTPManager, ReceiveStreamListener listener) {
        StreamRTPManagerDesc streamRTPManagerDesc = this.getStreamRTPManagerDesc(streamRTPManager, false);
        if (streamRTPManagerDesc != null) {
            streamRTPManagerDesc.removeReceiveStreamListener(listener);
        }
    }

    public void removeRemoteListener(StreamRTPManager streamRTPManager, RemoteListener listener) {
        this.manager.removeRemoteListener(listener);
    }

    public void removeSendStreamListener(StreamRTPManager streamRTPManager, SendStreamListener listener) {
    }

    public void removeSessionListener(StreamRTPManager streamRTPManager, SessionListener listener) {
    }

    @Override
    public void update(ReceiveStreamEvent event) {
        int receiveSSRC;
        StreamRTPManagerDesc streamRTPManagerDesc;
        ReceiveStream receiveStream;
        if (event != null && (receiveStream = event.getReceiveStream()) != null && (streamRTPManagerDesc = this.findStreamRTPManagerDescByReceiveSSRC(receiveSSRC = (int)receiveStream.getSSRC(), null)) != null) {
            for (ReceiveStreamListener listener : streamRTPManagerDesc.getReceiveStreamListeners()) {
                listener.update(event);
            }
        }
    }

    boolean willWrite(StreamRTPManagerDesc source, byte[] buffer, int offset, int length, StreamRTPManagerDesc destination, boolean data) {
        MediaStream src = source == null ? null : source.streamRTPManager.getMediaStream();
        MediaStream dst = destination.streamRTPManager.getMediaStream();
        return this.willWrite(src, buffer, offset, length, dst, data);
    }

    public boolean writeRTCPFeedbackMessage(RTCPFeedbackMessagePacket rtcpFeedbackMessage, MediaStream destination) {
        RTPConnectorImpl connector = this.connector;
        return connector == null ? false : connector.writeRTCPFeedbackMessage(rtcpFeedbackMessage, destination);
    }
}

