/*
 * Decompiled with CFR 0.152.
 */
package com.strangeberry.jmdns.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridLayout;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Enumeration;
import javax.jmdns.JmmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.ServiceTypeListener;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class Browser
extends JFrame
implements ServiceListener,
ServiceTypeListener,
ListSelectionListener {
    private static final long serialVersionUID = 5750114542524415107L;
    JmmDNS jmmdns;
    String type;
    DefaultListModel types;
    JList typeList;
    DefaultListModel services;
    JList serviceList;
    JTextArea info;

    Browser(JmmDNS jmmDNS) throws IOException {
        super("JmDNS Browser");
        this.jmmdns = jmmDNS;
        Color color = new Color(230, 230, 230);
        EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
        Container container = this.getContentPane();
        container.setLayout(new GridLayout(1, 3));
        this.types = new DefaultListModel();
        this.typeList = new JList(this.types);
        this.typeList.setBorder(emptyBorder);
        this.typeList.setBackground(color);
        this.typeList.setSelectionMode(0);
        this.typeList.addListSelectionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add("North", new JLabel("Types"));
        jPanel.add("Center", new JScrollPane(this.typeList, 20, 30));
        container.add(jPanel);
        this.services = new DefaultListModel();
        this.serviceList = new JList(this.services);
        this.serviceList.setBorder(emptyBorder);
        this.serviceList.setBackground(color);
        this.serviceList.setSelectionMode(0);
        this.serviceList.addListSelectionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add("North", new JLabel("Services"));
        jPanel2.add("Center", new JScrollPane(this.serviceList, 20, 30));
        container.add(jPanel2);
        this.info = new JTextArea();
        this.info.setBorder(emptyBorder);
        this.info.setBackground(color);
        this.info.setEditable(false);
        this.info.setLineWrap(true);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add("North", new JLabel("Details"));
        jPanel3.add("Center", new JScrollPane(this.info, 20, 30));
        container.add(jPanel3);
        this.setDefaultCloseOperation(3);
        this.setLocation(100, 100);
        this.setSize(600, 400);
        this.jmmdns.addServiceTypeListener(this);
        String[] stringArray = new String[]{};
        for (int i = 0; i < stringArray.length; ++i) {
            this.jmmdns.registerServiceType(stringArray[i]);
        }
        this.setVisible(true);
    }

    @Override
    public void serviceAdded(ServiceEvent serviceEvent) {
        final String string = serviceEvent.getName();
        System.out.println("ADD: " + string);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Browser.this.insertSorted(Browser.this.services, string);
            }
        });
    }

    @Override
    public void serviceRemoved(ServiceEvent serviceEvent) {
        final String string = serviceEvent.getName();
        System.out.println("REMOVE: " + string);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Browser.this.services.removeElement(string);
            }
        });
    }

    @Override
    public void serviceResolved(ServiceEvent serviceEvent) {
        String string = serviceEvent.getName();
        System.out.println("RESOLVED: " + string);
        if (string.equals(this.serviceList.getSelectedValue())) {
            ServiceInfo[] serviceInfoArray = this.jmmdns.getServiceInfos(this.type, string);
            this.dislayInfo(serviceInfoArray);
        }
    }

    @Override
    public void serviceTypeAdded(ServiceEvent serviceEvent) {
        final String string = serviceEvent.getType();
        System.out.println("TYPE: " + string);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Browser.this.insertSorted(Browser.this.types, string);
            }
        });
    }

    @Override
    public void subTypeForServiceTypeAdded(ServiceEvent serviceEvent) {
        System.out.println("SUBTYPE: " + serviceEvent.getType());
    }

    void insertSorted(DefaultListModel defaultListModel, String string) {
        int n = defaultListModel.getSize();
        for (int i = 0; i < n; ++i) {
            int n2 = string.compareToIgnoreCase((String)defaultListModel.elementAt(i));
            if (n2 == 0) {
                return;
            }
            if (n2 >= 0) continue;
            defaultListModel.insertElementAt(string, i);
            return;
        }
        defaultListModel.addElement(string);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            if (listSelectionEvent.getSource() == this.typeList) {
                this.type = (String)this.typeList.getSelectedValue();
                System.out.println("VALUE CHANGED: type: " + this.type);
                this.jmmdns.removeServiceListener(this.type, this);
                this.services.setSize(0);
                this.info.setText("");
                if (this.type != null) {
                    this.jmmdns.addServiceListener(this.type, this);
                }
            } else if (listSelectionEvent.getSource() == this.serviceList) {
                String string = (String)this.serviceList.getSelectedValue();
                System.out.println("VALUE CHANGED: type: " + this.type + " service: " + string);
                if (string == null) {
                    this.info.setText("");
                } else {
                    ServiceInfo[] serviceInfoArray = this.jmmdns.getServiceInfos(this.type, string);
                    this.dislayInfo(serviceInfoArray);
                }
            }
        }
    }

    private void dislayInfo(ServiceInfo[] serviceInfoArray) {
        if (serviceInfoArray.length == 0) {
            System.out.println("INFO: null");
            this.info.setText("service not found\n");
        } else {
            StringBuilder stringBuilder = new StringBuilder(2048);
            System.out.println("INFO: " + serviceInfoArray.length);
            for (ServiceInfo serviceInfo : serviceInfoArray) {
                System.out.println("INFO: " + serviceInfo);
                stringBuilder.append(serviceInfo.getName());
                stringBuilder.append('.');
                stringBuilder.append(serviceInfo.getTypeWithSubtype());
                stringBuilder.append('\n');
                stringBuilder.append(serviceInfo.getServer());
                stringBuilder.append(':');
                stringBuilder.append(serviceInfo.getPort());
                stringBuilder.append('\n');
                for (InetAddress inetAddress : serviceInfo.getInetAddresses()) {
                    stringBuilder.append(inetAddress);
                    stringBuilder.append(':');
                    stringBuilder.append(serviceInfo.getPort());
                    stringBuilder.append('\n');
                }
                Enumeration<String> enumeration = serviceInfo.getPropertyNames();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    stringBuilder.append(string);
                    stringBuilder.append('=');
                    stringBuilder.append(serviceInfo.getPropertyString(string));
                    stringBuilder.append('\n');
                }
                stringBuilder.append("------------------------\n");
            }
            this.info.setText(stringBuilder.toString());
        }
    }

    @Override
    public String toString() {
        return "RVBROWSER";
    }

    public static void main(String[] stringArray) throws IOException {
        new Browser(JmmDNS.Factory.getInstance());
    }

    class ServiceTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 5607994569609827570L;

        ServiceTableModel() {
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "service";
                }
                case 1: {
                    return "address";
                }
                case 2: {
                    return "port";
                }
                case 3: {
                    return "text";
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return Browser.this.services.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return Browser.this.services.elementAt(n);
        }
    }
}

