/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.XATransactionMessageType;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Collection;
import java.util.HashSet;

@SuppressWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class XATransactionCollectTransactionsCodec {
    public static final XATransactionMessageType REQUEST_TYPE = XATransactionMessageType.XATRANSACTION_COLLECTTRANSACTIONS;
    public static final int RESPONSE_TYPE = 115;
    public static final boolean RETRYABLE = false;

    public static ClientMessage encodeRequest() {
        int requiredDataSize = RequestParameters.calculateDataSize();
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(false);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        RequestParameters parameters = new RequestParameters();
        return parameters;
    }

    public static ClientMessage encodeResponse(Collection<Data> list) {
        int requiredDataSize = ResponseParameters.calculateDataSize(list);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(115);
        clientMessage.set(list.size());
        for (Data list_item : list) {
            clientMessage.set(list_item);
        }
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        HashSet<Data> list = null;
        int list_size = clientMessage.getInt();
        list = new HashSet<Data>(list_size);
        for (int list_index = 0; list_index < list_size; ++list_index) {
            Data list_item = clientMessage.getData();
            list.add(list_item);
        }
        parameters.list = list;
        return parameters;
    }

    public static class ResponseParameters {
        public Collection<Data> list;

        public static int calculateDataSize(Collection<Data> list) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += 4;
            for (Data list_item : list) {
                dataSize += ParameterUtil.calculateDataSize(list_item);
            }
            return dataSize;
        }
    }

    public static class RequestParameters {
        public static final XATransactionMessageType TYPE = REQUEST_TYPE;

        public static int calculateDataSize() {
            int dataSize = ClientMessage.HEADER_SIZE;
            return dataSize;
        }
    }
}

