/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.renderer.audio;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.GainControl;
import javax.media.MediaLocator;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.control.DiagnosticsControl;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.impl.neomedia.device.PortAudioSystem;
import org.jitsi.impl.neomedia.device.UpdateAvailableDeviceListListener;
import org.jitsi.impl.neomedia.jmfext.media.protocol.portaudio.DataSource;
import org.jitsi.impl.neomedia.jmfext.media.protocol.portaudio.PortAudioStream;
import org.jitsi.impl.neomedia.jmfext.media.renderer.audio.AbstractAudioRenderer;
import org.jitsi.impl.neomedia.portaudio.Pa;
import org.jitsi.impl.neomedia.portaudio.PortAudioException;
import org.jitsi.service.neomedia.BasicVolumeControl;
import org.jitsi.util.Logger;

public class PortAudioRenderer
extends AbstractAudioRenderer<PortAudioSystem> {
    private static final Logger logger = Logger.getLogger(PortAudioRenderer.class);
    private static final Format[] EMPTY_SUPPORTED_INPUT_FORMATS = new Format[0];
    private static final byte FLAG_OPEN = 1;
    private static final byte FLAG_STARTED = 2;
    private static final String PLUGIN_NAME = "PortAudio Renderer";
    private static final Format[] SUPPORTED_INPUT_FORMATS;
    private static final double[] SUPPORTED_INPUT_SAMPLE_RATES;
    private byte[] bufferLeft;
    private int bufferLeftLength = 0;
    private int bytesPerBuffer;
    private final DiagnosticsControl diagnosticsControl = new DiagnosticsControl(){

        @Override
        public Component getControlComponent() {
            return null;
        }

        @Override
        public long getMalfunctioningSince() {
            return PortAudioRenderer.this.writeIsMalfunctioningSince;
        }

        @Override
        public String toString() {
            long info;
            int index;
            String id;
            MediaLocator locator = PortAudioRenderer.this.getLocator();
            String name = null;
            if (locator != null && (id = DataSource.getDeviceID(locator)) != null && (index = Pa.getDeviceIndex(id, 0, 1)) != -1 && (info = Pa.GetDeviceInfo(index)) != 0L) {
                name = Pa.DeviceInfo_getName(info);
            }
            return name;
        }
    };
    private byte flags = 0;
    private int framesPerBuffer;
    private long outputParameters = 0L;
    private final UpdateAvailableDeviceListListener paUpdateAvailableDeviceListListener = new UpdateAvailableDeviceListListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void didUpdateAvailableDeviceList() throws Exception {
            PortAudioRenderer portAudioRenderer = PortAudioRenderer.this;
            synchronized (portAudioRenderer) {
                PortAudioRenderer.this.waitWhileStreamIsBusy();
                byte flags = PortAudioRenderer.this.flags;
                try {
                    if ((1 & flags) == 1) {
                        PortAudioRenderer.this.open();
                        if ((2 & flags) == 2) {
                            PortAudioRenderer.this.start();
                        }
                    }
                }
                finally {
                    PortAudioRenderer.this.flags = flags;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void willUpdateAvailableDeviceList() throws Exception {
            PortAudioRenderer portAudioRenderer = PortAudioRenderer.this;
            synchronized (portAudioRenderer) {
                PortAudioRenderer.this.waitWhileStreamIsBusy();
                byte flags = PortAudioRenderer.this.flags;
                try {
                    if (PortAudioRenderer.this.stream != 0L) {
                        PortAudioRenderer.this.close();
                    }
                }
                finally {
                    PortAudioRenderer.this.flags = flags;
                }
            }
        }
    };
    private boolean started = false;
    private long stream = 0L;
    private boolean streamIsBusy = false;
    private Format[] supportedInputFormats;
    private long writeIsMalfunctioningSince = 0L;

    public PortAudioRenderer() {
        this(true);
    }

    public PortAudioRenderer(boolean enableVolumeControl) {
        super("portaudio", enableVolumeControl ? AudioSystem.DataFlow.PLAYBACK : AudioSystem.DataFlow.NOTIFY);
        if (this.audioSystem != null) {
            ((PortAudioSystem)this.audioSystem).addUpdateAvailableDeviceListListener(this.paUpdateAvailableDeviceListListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        try {
            this.stop();
        }
        finally {
            if (this.stream != 0L) {
                try {
                    Pa.CloseStream(this.stream);
                    this.stream = 0L;
                    this.started = false;
                    this.flags = (byte)(this.flags & 0xFFFFFFFC);
                    if (this.writeIsMalfunctioningSince != 0L) {
                        this.setWriteIsMalfunctioning(false);
                    }
                }
                catch (PortAudioException paex) {
                    logger.error("Failed to close PortAudio stream.", paex);
                }
            }
            if (this.stream == 0L && this.outputParameters != 0L) {
                Pa.StreamParameters_free(this.outputParameters);
                this.outputParameters = 0L;
            }
            super.close();
        }
    }

    @Override
    public String getName() {
        return PLUGIN_NAME;
    }

    @Override
    public Format[] getSupportedInputFormats() {
        if (this.supportedInputFormats == null) {
            long deviceInfo;
            int deviceIndex;
            String deviceID;
            MediaLocator locator = this.getLocator();
            if (locator == null || (deviceID = DataSource.getDeviceID(locator)) == null || deviceID.length() == 0 || (deviceIndex = Pa.getDeviceIndex(deviceID, 0, 1)) == -1 || (deviceInfo = Pa.GetDeviceInfo(deviceIndex)) == 0L) {
                this.supportedInputFormats = SUPPORTED_INPUT_FORMATS;
            } else {
                int minOutputChannels = 1;
                int maxOutputChannels = Math.min(Pa.DeviceInfo_getMaxOutputChannels(deviceInfo), 2);
                ArrayList<Format> supportedInputFormats = new ArrayList<Format>(SUPPORTED_INPUT_FORMATS.length);
                for (Format supportedInputFormat : SUPPORTED_INPUT_FORMATS) {
                    this.getSupportedInputFormats(supportedInputFormat, deviceIndex, minOutputChannels, maxOutputChannels, supportedInputFormats);
                }
                this.supportedInputFormats = supportedInputFormats.isEmpty() ? EMPTY_SUPPORTED_INPUT_FORMATS : supportedInputFormats.toArray(EMPTY_SUPPORTED_INPUT_FORMATS);
            }
        }
        return this.supportedInputFormats.length == 0 ? EMPTY_SUPPORTED_INPUT_FORMATS : (Format[])this.supportedInputFormats.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSupportedInputFormats(Format format, int deviceIndex, int minOutputChannels, int maxOutputChannels, List<Format> supportedInputFormats) {
        AudioFormat audioFormat = (AudioFormat)format;
        int sampleSizeInBits = audioFormat.getSampleSizeInBits();
        long sampleFormat = Pa.getPaSampleFormat(sampleSizeInBits);
        double sampleRate = audioFormat.getSampleRate();
        for (int channels = minOutputChannels; channels <= maxOutputChannels; ++channels) {
            long outputParameters = Pa.StreamParameters_new(deviceIndex, channels, sampleFormat, 0.0);
            if (outputParameters == 0L) continue;
            try {
                if (!Pa.IsFormatSupported(0L, outputParameters, sampleRate)) continue;
                supportedInputFormats.add(new AudioFormat(audioFormat.getEncoding(), sampleRate, sampleSizeInBits, channels, audioFormat.getEndian(), audioFormat.getSigned(), -1, -1.0, audioFormat.getDataType()));
                continue;
            }
            finally {
                Pa.StreamParameters_free(outputParameters);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void open() throws ResourceUnavailableException {
        try {
            ((PortAudioSystem)this.audioSystem).willOpenStream();
            try {
                this.doOpen();
            }
            finally {
                ((PortAudioSystem)this.audioSystem).didOpenStream();
            }
        }
        catch (Throwable t) {
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to open PortAudioRenderer", t);
            }
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            if (t instanceof ResourceUnavailableException) {
                throw (ResourceUnavailableException)t;
            }
            ResourceUnavailableException rue = new ResourceUnavailableException();
            rue.initCause(t);
            throw rue;
        }
        super.open();
    }

    private void doOpen() throws ResourceUnavailableException {
        if (this.stream == 0L) {
            MediaLocator locator = this.getLocator();
            if (locator == null) {
                throw new ResourceUnavailableException("No locator/MediaLocator is set.");
            }
            String deviceID = DataSource.getDeviceID(locator);
            int deviceIndex = Pa.getDeviceIndex(deviceID, 0, 1);
            if (deviceIndex == -1) {
                throw new ResourceUnavailableException("The audio device " + deviceID + " appears to be disconnected.");
            }
            AudioFormat inputFormat = (AudioFormat)this.inputFormat;
            if (inputFormat == null) {
                throw new ResourceUnavailableException("inputFormat not set");
            }
            int channels = inputFormat.getChannels();
            if (channels == -1) {
                channels = 1;
            }
            long sampleFormat = Pa.getPaSampleFormat(inputFormat.getSampleSizeInBits());
            double sampleRate = inputFormat.getSampleRate();
            this.framesPerBuffer = (int)(sampleRate * 20.0 / (double)(channels * 1000));
            try {
                this.outputParameters = Pa.StreamParameters_new(deviceIndex, channels, sampleFormat, Pa.getSuggestedLatency());
                this.stream = Pa.OpenStream(0L, this.outputParameters, sampleRate, this.framesPerBuffer, 3L, null);
            }
            catch (PortAudioException paex) {
                logger.error("Failed to open PortAudio stream.", paex);
                throw new ResourceUnavailableException(paex.getMessage());
            }
            finally {
                this.started = false;
                if (this.stream == 0L) {
                    this.flags = (byte)(this.flags & 0xFFFFFFFC);
                    if (this.outputParameters != 0L) {
                        Pa.StreamParameters_free(this.outputParameters);
                        this.outputParameters = 0L;
                    }
                } else {
                    this.flags = (byte)(this.flags | 3);
                }
            }
            if (this.stream == 0L) {
                throw new ResourceUnavailableException("Pa_OpenStream");
            }
            this.bytesPerBuffer = Pa.GetSampleSize(sampleFormat) * channels * this.framesPerBuffer;
            if (this.writeIsMalfunctioningSince != 0L) {
                this.setWriteIsMalfunctioning(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void playbackDevicePropertyChange(PropertyChangeEvent ev) {
        block6: {
            this.waitWhileStreamIsBusy();
            byte flags = this.flags;
            try {
                if ((1 & flags) != 1) break block6;
                this.close();
                try {
                    this.open();
                }
                catch (ResourceUnavailableException rue) {
                    throw new UndeclaredThrowableException(rue);
                }
                if ((2 & flags) == 2) {
                    this.start();
                }
            }
            finally {
                this.flags = flags;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int process(Buffer buffer) {
        PortAudioRenderer portAudioRenderer = this;
        synchronized (portAudioRenderer) {
            if (!this.started || this.stream == 0L) {
                if (this.writeIsMalfunctioningSince != 0L) {
                    this.setWriteIsMalfunctioning(false);
                }
                return 0;
            }
            this.streamIsBusy = true;
        }
        long errorCode = 0L;
        Pa.HostApiTypeId hostApiType = null;
        try {
            this.process((byte[])buffer.getData(), buffer.getOffset(), buffer.getLength());
        }
        catch (PortAudioException pae) {
            errorCode = pae.getErrorCode();
            hostApiType = pae.getHostApiType();
            logger.error("Failed to process Buffer.", pae);
        }
        finally {
            boolean yield = false;
            PortAudioRenderer portAudioRenderer2 = this;
            synchronized (portAudioRenderer2) {
                this.streamIsBusy = false;
                this.notifyAll();
                if (errorCode == 0L) {
                    if (this.writeIsMalfunctioningSince != 0L) {
                        this.setWriteIsMalfunctioning(false);
                    }
                } else if (-9987L == errorCode || Pa.HostApiTypeId.paMME.equals((Object)hostApiType) && 6L == errorCode) {
                    if (this.writeIsMalfunctioningSince == 0L) {
                        this.setWriteIsMalfunctioning(true);
                    }
                    yield = true;
                }
            }
            if (yield) {
                PortAudioStream.yield();
            }
        }
        return 0;
    }

    private void process(byte[] buffer, int offset, int length) throws PortAudioException {
        int numberOfWrites;
        if (this.bufferLeft != null && this.bufferLeftLength > 0) {
            int numberOfBytesInBufferLeftToBytesPerBuffer = this.bytesPerBuffer - this.bufferLeftLength;
            int numberOfBytesToCopyToBufferLeft = numberOfBytesInBufferLeftToBytesPerBuffer < length ? numberOfBytesInBufferLeftToBytesPerBuffer : length;
            System.arraycopy(buffer, offset, this.bufferLeft, this.bufferLeftLength, numberOfBytesToCopyToBufferLeft);
            offset += numberOfBytesToCopyToBufferLeft;
            length -= numberOfBytesToCopyToBufferLeft;
            this.bufferLeftLength += numberOfBytesToCopyToBufferLeft;
            if (this.bufferLeftLength == this.bytesPerBuffer) {
                Pa.WriteStream(this.stream, this.bufferLeft, this.framesPerBuffer);
                this.bufferLeftLength = 0;
            }
        }
        if ((numberOfWrites = length / this.bytesPerBuffer) > 0) {
            GainControl gainControl = this.getGainControl();
            if (gainControl != null) {
                BasicVolumeControl.applyGain(gainControl, buffer, offset, length);
            }
            Pa.WriteStream(this.stream, buffer, offset, this.framesPerBuffer, numberOfWrites);
            int bytesWritten = numberOfWrites * this.bytesPerBuffer;
            offset += bytesWritten;
            length -= bytesWritten;
        }
        if (length > 0) {
            if (this.bufferLeft == null) {
                this.bufferLeft = new byte[this.bytesPerBuffer];
            }
            System.arraycopy(buffer, offset, this.bufferLeft, 0, length);
            this.bufferLeftLength = length;
        }
    }

    @Override
    public void setLocator(MediaLocator locator) {
        super.setLocator(locator);
        this.supportedInputFormats = null;
    }

    private void setWriteIsMalfunctioning(boolean writeIsMalfunctioning) {
        if (writeIsMalfunctioning) {
            if (this.writeIsMalfunctioningSince == 0L) {
                this.writeIsMalfunctioningSince = System.currentTimeMillis();
                PortAudioSystem.monitorFunctionalHealth(this.diagnosticsControl);
            }
        } else {
            this.writeIsMalfunctioningSince = 0L;
        }
    }

    @Override
    public synchronized void start() {
        if (!this.started && this.stream != 0L) {
            try {
                Pa.StartStream(this.stream);
                this.started = true;
                this.flags = (byte)(this.flags | 2);
            }
            catch (PortAudioException paex) {
                logger.error("Failed to start PortAudio stream.", paex);
            }
        }
    }

    @Override
    public synchronized void stop() {
        this.waitWhileStreamIsBusy();
        if (this.started && this.stream != 0L) {
            try {
                Pa.StopStream(this.stream);
                this.started = false;
                this.flags = (byte)(this.flags & 0xFFFFFFFD);
                this.bufferLeft = null;
                if (this.writeIsMalfunctioningSince != 0L) {
                    this.setWriteIsMalfunctioning(false);
                }
            }
            catch (PortAudioException paex) {
                logger.error("Failed to close PortAudio stream.", paex);
            }
        }
    }

    private void waitWhileStreamIsBusy() {
        boolean interrupted = false;
        while (this.streamIsBusy) {
            try {
                this.wait();
            }
            catch (InterruptedException iex) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    static {
        SUPPORTED_INPUT_SAMPLE_RATES = new double[]{8000.0, 11025.0, 16000.0, 22050.0, 32000.0, 44100.0, 48000.0};
        int count = SUPPORTED_INPUT_SAMPLE_RATES.length;
        SUPPORTED_INPUT_FORMATS = new Format[count];
        for (int i = 0; i < count; ++i) {
            PortAudioRenderer.SUPPORTED_INPUT_FORMATS[i] = new AudioFormat("LINEAR", SUPPORTED_INPUT_SAMPLE_RATES[i], 16, -1, 0, 1, -1, -1.0, Format.byteArray);
        }
    }
}

