/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import java.text.ParseException;
import java.util.Vector;

public class StringTokenizer {
    protected String buffer;
    protected int bufferLen;
    protected int ptr;
    protected int savedPtr;

    protected StringTokenizer() {
    }

    public StringTokenizer(String string) {
        this.buffer = string;
        this.bufferLen = string.length();
        this.ptr = 0;
    }

    public String nextToken() {
        int n = this.ptr;
        while (this.ptr < this.bufferLen) {
            char c = this.buffer.charAt(this.ptr);
            ++this.ptr;
            if (c != '\n') continue;
            break;
        }
        return this.buffer.substring(n, this.ptr);
    }

    public boolean hasMoreChars() {
        return this.ptr < this.bufferLen;
    }

    public static boolean isHexDigit(char c) {
        return c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f' || StringTokenizer.isDigit(c);
    }

    public static boolean isAlpha(char c) {
        if (c <= '\u007f') {
            return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
        }
        return Character.isLowerCase(c) || Character.isUpperCase(c);
    }

    public static boolean isDigit(char c) {
        if (c <= '\u007f') {
            return c <= '9' && c >= '0';
        }
        return Character.isDigit(c);
    }

    public static boolean isAlphaDigit(char c) {
        if (c <= '\u007f') {
            return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c <= '9' && c >= '0';
        }
        return Character.isLowerCase(c) || Character.isUpperCase(c) || Character.isDigit(c);
    }

    public String getLine() {
        int n = this.ptr;
        while (this.ptr < this.bufferLen && this.buffer.charAt(this.ptr) != '\n') {
            ++this.ptr;
        }
        if (this.ptr < this.bufferLen && this.buffer.charAt(this.ptr) == '\n') {
            ++this.ptr;
        }
        return this.buffer.substring(n, this.ptr);
    }

    public String peekLine() {
        int n = this.ptr;
        String string = this.getLine();
        this.ptr = n;
        return string;
    }

    public char lookAhead() throws ParseException {
        return this.lookAhead(0);
    }

    public char lookAhead(int n) throws ParseException {
        try {
            return this.buffer.charAt(this.ptr + n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return '\u0000';
        }
    }

    public char getNextChar() throws ParseException {
        if (this.ptr >= this.bufferLen) {
            throw new ParseException(this.buffer + " getNextChar: End of buffer", this.ptr);
        }
        return this.buffer.charAt(this.ptr++);
    }

    public void consume() {
        this.ptr = this.savedPtr;
    }

    public void consume(int n) {
        this.ptr += n;
    }

    public Vector getLines() {
        Vector<String> vector = new Vector<String>();
        while (this.hasMoreChars()) {
            String string = this.getLine();
            vector.addElement(string);
        }
        return vector;
    }

    public String getNextToken(char c) throws ParseException {
        char c2;
        int n = this.ptr;
        while ((c2 = this.lookAhead(0)) != c) {
            if (c2 == '\u0000') {
                throw new ParseException("EOL reached", 0);
            }
            this.consume(1);
        }
        return this.buffer.substring(n, this.ptr);
    }

    public static String getSDPFieldName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        try {
            int n = string.indexOf("=");
            string2 = string.substring(0, n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
        return string2;
    }
}

