/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.utility;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Codec;
import javax.media.Demultiplexer;
import javax.media.Effect;
import javax.media.Format;
import javax.media.Multiplexer;
import javax.media.PlugInManager;
import javax.media.Renderer;
import javax.media.protocol.ContentDescriptor;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.PlugInInfo;

public class PlugInUtility {
    private static final Logger logger = LoggerSingleton.logger;
    private static final boolean TRACE = false;

    public static PlugInInfo getPlugInInfo(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Object obj = clazz.newInstance();
            if (obj instanceof Demultiplexer) {
                Demultiplexer demultiplexer = (Demultiplexer)obj;
                ContentDescriptor[] contentDescriptorArray = demultiplexer.getSupportedInputContentDescriptors();
                Format[] formatArray = new Format[contentDescriptorArray.length];
                for (int i = 0; i < contentDescriptorArray.length; ++i) {
                    formatArray[i] = contentDescriptorArray[i];
                }
                return new PlugInInfo(string, formatArray, new Format[0], 1);
            }
            if (obj instanceof Codec) {
                Codec codec = (Codec)obj;
                Format[] formatArray = codec.getSupportedInputFormats();
                Format[] formatArray2 = codec.getSupportedOutputFormats(null);
                return new PlugInInfo(string, formatArray, formatArray2, obj instanceof Effect ? 3 : 2);
            }
            if (obj instanceof Renderer) {
                Renderer renderer = (Renderer)obj;
                Format[] formatArray = renderer.getSupportedInputFormats();
                return new PlugInInfo(string, formatArray, new Format[0], 4);
            }
            if (obj instanceof Multiplexer) {
                Multiplexer multiplexer = (Multiplexer)obj;
                return new PlugInInfo(string, new Format[0], multiplexer.getSupportedOutputContentDescriptors(null), 5);
            }
            logger.warning("PlugInUtility: Unknown or unsupported plug-in: " + obj.getClass());
            return null;
        }
        catch (Throwable throwable) {
            logger.log(Level.FINE, "PlugInUtility: Unable to get plugin info for " + string + ": " + throwable);
            return null;
        }
    }

    public static boolean registerPlugIn(String string) {
        PlugInInfo plugInInfo = PlugInUtility.getPlugInInfo(string);
        if (plugInInfo == null) {
            return false;
        }
        try {
            return PlugInManager.addPlugIn(plugInInfo.className, plugInInfo.in, plugInInfo.out, plugInInfo.type);
        }
        catch (Throwable throwable) {
            logger.fine("PlugInUtility: Unable to register plugin " + string + ": " + throwable);
            return false;
        }
    }
}

