/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ui.application;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.media.protocol.ContentDescriptor;
import net.sf.fmj.ui.wizards.ProcessorWizardConfig;
import net.sf.fmj.ui.wizards.RTPTransmitWizardConfig;
import net.sf.fmj.ui.wizards.TrackConfig;
import net.sf.fmj.ui.wizards.TranscodeWizardConfig;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.SerializationUtils;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class PlayerPanelPrefs {
    private static final Logger logger = LoggerSingleton.logger;
    private static final String version = "0.1";
    public List<String> recentUrls = new ArrayList<String>();
    public boolean autoPlay = true;
    public boolean autoLoop = false;
    public RTPTransmitWizardConfig rtpTransmitWizardConfig = new RTPTransmitWizardConfig();
    public TranscodeWizardConfig transcodeWizardConfig = new TranscodeWizardConfig();
    private static final String ELEMENT_REGISTRY = "fmj-studio-prefs";
    private static final String ATTR_VERSION = "version";
    private static final String ELEMENT_RECENT_URLS = "recent-urls";
    private static final String ELEMENT_RECENT_URL = "url";
    private static final String ELEMENT_RTP_TRANSMIT_WIZARD_CONFIG = "rtp-transmit-wizard-config";
    private static final String ELEMENT_TRANSCODE_WIZARD_CONFIG = "transcode-wizard-config";

    public static File getFile() {
        String string = System.getProperty("user.home");
        return new File(string + File.separator + ".fmjstudio.prefs.xml");
    }

    private static Element buildElement_ProcessorWizardConfig(ProcessorWizardConfig processorWizardConfig, String string) {
        Element element;
        Element element2 = new Element(string);
        if (processorWizardConfig.url != null) {
            element = new Element("source-url");
            element.setText(processorWizardConfig.url);
            element2.addContent((Content)element);
        }
        if (processorWizardConfig.contentDescriptor != null) {
            element = new Element("content-descriptor-encoding");
            element.setText(processorWizardConfig.contentDescriptor.getEncoding());
            element2.addContent((Content)element);
        }
        if (processorWizardConfig.trackConfigs != null) {
            element = new Element("track-configs");
            element2.addContent((Content)element);
            for (int i = 0; i < processorWizardConfig.trackConfigs.length; ++i) {
                TrackConfig trackConfig = processorWizardConfig.trackConfigs[i];
                Element element3 = new Element("track-config");
                element.addContent((Content)element3);
                Element element4 = new Element("enabled");
                element3.addContent((Content)element4);
                element4.setText("" + trackConfig.enabled);
                if (trackConfig.format == null) continue;
                element4 = new Element("format-serialized");
                try {
                    element4.setText(SerializationUtils.serialize(trackConfig.format));
                    element3.addContent((Content)element4);
                    continue;
                }
                catch (IOException iOException) {
                    logger.warning("Unable to serialize format: " + trackConfig.format + ": " + element);
                }
            }
        }
        if (processorWizardConfig.destUrl != null) {
            element = new Element("dest-url");
            element.setText(processorWizardConfig.destUrl.toString());
            element2.addContent((Content)element);
        }
        return element2;
    }

    private static void parseElement_ProcessorWizardConfig(Element element, ProcessorWizardConfig processorWizardConfig) {
        Object object;
        Element element2 = element.getChild("source-url");
        if (element2 != null) {
            processorWizardConfig.url = element2.getTextTrim();
        }
        if ((element2 = element.getChild("content-descriptor-encoding")) != null) {
            processorWizardConfig.contentDescriptor = new ContentDescriptor(element2.getTextTrim());
        }
        if ((element2 = element.getChild("track-configs")) != null) {
            object = element2.getChildren("track-config");
            TrackConfig[] trackConfigArray = new TrackConfig[object.size()];
            for (int i = 0; i < object.size(); ++i) {
                trackConfigArray[i] = new TrackConfig();
                Element element3 = (Element)object.get(i);
                Element element4 = element3.getChild("enabled");
                if (element4 != null) {
                    trackConfigArray[i].enabled = element4.getTextTrim().equals("true");
                }
                if ((element4 = element3.getChild("format")) == null) continue;
                try {
                    trackConfigArray[i].format = SerializationUtils.deserialize(element4.getTextTrim());
                    continue;
                }
                catch (IOException iOException) {
                    logger.warning("Unable to deserialize format: " + element4.getTextTrim() + ": " + iOException);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    logger.warning("Unable to deserialize format: " + element4.getTextTrim() + ": " + classNotFoundException);
                }
            }
        }
        if ((element2 = element.getChild("dest-url")) != null) {
            processorWizardConfig.destUrl = object = element2.getTextTrim();
        }
    }

    private Document buildDocument() throws IOException {
        Document document = new Document();
        Element element = new Element(ELEMENT_REGISTRY);
        element.setAttribute(ATTR_VERSION, version);
        document.setRootElement(element);
        element.addContent((Content)this.buildElement_RecentUrls());
        Element element2 = new Element("auto-play");
        element2.setText("" + this.autoPlay);
        element.addContent((Content)element2);
        element2 = new Element("auto-loop");
        element2.setText("" + this.autoLoop);
        element.addContent((Content)element2);
        element.addContent((Content)this.buildElement_RTPTransmitWizardConfig());
        element.addContent((Content)this.buildElement_TranscodeWizardConfig());
        return document;
    }

    private Element buildElement_RecentUrls() {
        Element element = new Element(ELEMENT_RECENT_URLS);
        for (String string : this.recentUrls) {
            Element element2 = new Element(ELEMENT_RECENT_URL);
            element2.setText(string);
            element.addContent((Content)element2);
        }
        return element;
    }

    private Element buildElement_RTPTransmitWizardConfig() {
        return PlayerPanelPrefs.buildElement_ProcessorWizardConfig(this.rtpTransmitWizardConfig, ELEMENT_RTP_TRANSMIT_WIZARD_CONFIG);
    }

    private Element buildElement_TranscodeWizardConfig() {
        return PlayerPanelPrefs.buildElement_ProcessorWizardConfig(this.transcodeWizardConfig, ELEMENT_TRANSCODE_WIZARD_CONFIG);
    }

    public void load(Reader reader) throws IOException {
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            Document document = sAXBuilder.build(reader);
            this.loadDocument(document);
        }
        catch (JDOMException jDOMException) {
            throw new IOException(jDOMException.getMessage());
        }
    }

    private void loadDocument(Document document) throws IOException {
        Element element = document.getRootElement();
        String string = element.getAttributeValue(ATTR_VERSION);
        logger.info("FMJStudio preferences document version " + string);
        Element element2 = element.getChild(ELEMENT_RECENT_URLS);
        this.parseElement_RecentUrls(element2);
        Element element3 = element.getChild("auto-play");
        if (element3 != null) {
            this.autoPlay = element3.getTextTrim().equals("true");
        }
        if ((element3 = element.getChild("auto-loop")) != null) {
            this.autoLoop = element3.getTextTrim().equals("true");
        }
        this.parseElement_RTPTransmitWizardConfig(element.getChild(ELEMENT_RTP_TRANSMIT_WIZARD_CONFIG));
        this.parseElement_TranscodeWizardConfig(element.getChild(ELEMENT_TRANSCODE_WIZARD_CONFIG));
    }

    private void parseElement_RecentUrls(Element element) {
        this.recentUrls.clear();
        List list = element.getChildren(ELEMENT_RECENT_URL);
        for (int i = 0; i < list.size(); ++i) {
            Element element2 = (Element)list.get(i);
            this.recentUrls.add(element2.getTextTrim());
        }
    }

    private void parseElement_RTPTransmitWizardConfig(Element element) {
        this.rtpTransmitWizardConfig = new RTPTransmitWizardConfig();
        if (element != null) {
            PlayerPanelPrefs.parseElement_ProcessorWizardConfig(element, this.rtpTransmitWizardConfig);
        }
    }

    private void parseElement_TranscodeWizardConfig(Element element) {
        this.transcodeWizardConfig = new TranscodeWizardConfig();
        if (element != null) {
            PlayerPanelPrefs.parseElement_ProcessorWizardConfig(element, this.transcodeWizardConfig);
        }
    }

    public void write(Writer writer) throws IOException {
        Document document = this.buildDocument();
        XMLOutputter xMLOutputter = new XMLOutputter();
        xMLOutputter.setFormat(Format.getPrettyFormat());
        xMLOutputter.output(document, writer);
    }
}

