/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.multiplexer;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.JPEGFormat;
import javax.media.protocol.ContentDescriptor;
import net.sf.fmj.media.format.GIFFormat;
import net.sf.fmj.media.format.PNGFormat;
import net.sf.fmj.media.multiplexer.AbstractInputStreamMux;
import net.sf.fmj.utility.LoggerSingleton;

public class MultipartMixedReplaceMux
extends AbstractInputStreamMux {
    private static final Logger logger = LoggerSingleton.logger;
    public static final String BOUNDARY = "--ssBoundaryFMJ";
    public static final String TIMESTAMP_KEY = "X-FMJ-Timestamp";
    private static final int MAX_TRACKS = 1;

    public MultipartMixedReplaceMux() {
        super(new ContentDescriptor("multipart.x_mixed_replace"));
    }

    protected void doProcess(Buffer buffer, int n, OutputStream outputStream) throws IOException {
        if (buffer.isEOM()) {
            outputStream.close();
            return;
        }
        if (buffer.isDiscard()) {
            return;
        }
        outputStream.write("--ssBoundaryFMJ\n".getBytes());
        outputStream.write(("Content-Type: image/" + buffer.getFormat().getEncoding() + "\n").getBytes());
        outputStream.write(("Content-Length: " + buffer.getLength() + "\n").getBytes());
        outputStream.write(("X-FMJ-Timestamp: " + buffer.getTimeStamp() + "\n").getBytes());
        outputStream.write("\n".getBytes());
        outputStream.write((byte[])buffer.getData(), buffer.getOffset(), buffer.getLength());
        outputStream.write("\n\n".getBytes());
    }

    public Format[] getSupportedInputFormats() {
        return new Format[]{new JPEGFormat(), new GIFFormat(), new PNGFormat()};
    }

    public Format setInputFormat(Format format, int n) {
        logger.finer("setInputFormat " + format + " " + n);
        boolean bl = false;
        for (Format format2 : this.getSupportedInputFormats()) {
            if (!format.matches(format2)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            logger.warning("Input format does not match any supported input format: " + format);
            return null;
        }
        if (this.inputFormats != null) {
            this.inputFormats[n] = format;
        }
        return format;
    }

    public int setNumTracks(int n) {
        return super.setNumTracks(n > 1 ? 1 : n);
    }
}

