/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice.harvest;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.ice4j.StackProperties;
import org.ice4j.StunException;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.attribute.UsernameAttribute;
import org.ice4j.ice.Agent;
import org.ice4j.ice.CandidateExtendedType;
import org.ice4j.ice.CandidateTcpType;
import org.ice4j.ice.Component;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.ice.IceProcessingState;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.NetworkUtils;
import org.ice4j.ice.ServerReflexiveCandidate;
import org.ice4j.ice.TcpHostCandidate;
import org.ice4j.ice.harvest.AwsCandidateHarvester;
import org.ice4j.ice.harvest.CandidateHarvester;
import org.ice4j.ice.harvest.GoogleTurnSSLCandidateHarvester;
import org.ice4j.ice.harvest.HostCandidateHarvester;
import org.ice4j.message.Message;
import org.ice4j.socket.DatagramPacketFilter;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.socket.IceTcpSocketWrapper;
import org.ice4j.socket.MultiplexingSocket;
import org.ice4j.socket.MuxServerSocketChannelFactory;
import org.ice4j.socket.StunDatagramPacketFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiplexingTcpHostHarvester
extends CandidateHarvester {
    private static final Logger logger = Logger.getLogger(MultiplexingTcpHostHarvester.class.getName());
    private static final int PURGE_INTERVAL = 20;
    private AcceptThread acceptThread;
    private boolean close = false;
    private final Map<String, WeakReference<Component>> components = new HashMap<String, WeakReference<Component>>();
    private final List<TransportAddress> localAddresses = new LinkedList<TransportAddress>();
    private final Map<InetAddress, InetAddress> mappedAddresses = new HashMap<InetAddress, InetAddress>();
    private final Set<Integer> mappedPorts = new HashSet<Integer>();
    private final List<SocketChannel> newChannels = new LinkedList<SocketChannel>();
    private int purgeCounter = 0;
    private final Selector readSelector = Selector.open();
    private ReadThread readThread;
    private final List<ServerSocketChannel> serverSocketChannels = new LinkedList<ServerSocketChannel>();
    private final boolean ssltcp;

    static void closeNoExceptions(Channel channel) {
        MuxServerSocketChannelFactory.closeNoExceptions(channel);
    }

    private static List<TransportAddress> getLocalAddresses(int port, List<NetworkInterface> interfaces) throws IOException {
        LinkedList<TransportAddress> addresses = new LinkedList<TransportAddress>();
        for (NetworkInterface iface : interfaces) {
            if (NetworkUtils.isInterfaceLoopback(iface) || !NetworkUtils.isInterfaceUp(iface) || !HostCandidateHarvester.isInterfaceAllowed(iface)) continue;
            Enumeration<InetAddress> ifaceAddresses = iface.getInetAddresses();
            while (ifaceAddresses.hasMoreElements()) {
                InetAddress addr = ifaceAddresses.nextElement();
                addresses.add(new TransportAddress(addr, port, Transport.TCP));
            }
        }
        return addresses;
    }

    public MultiplexingTcpHostHarvester(int port) throws IOException {
        this(port, false);
    }

    public MultiplexingTcpHostHarvester(int port, boolean ssltcp) throws IOException {
        this(port, Collections.list(NetworkInterface.getNetworkInterfaces()), ssltcp);
    }

    public MultiplexingTcpHostHarvester(int port, List<NetworkInterface> interfaces, boolean ssltcp) throws IOException {
        this(MultiplexingTcpHostHarvester.getLocalAddresses(port, interfaces), ssltcp);
    }

    public MultiplexingTcpHostHarvester(List<TransportAddress> transportAddresses) throws IOException {
        this(transportAddresses, false);
    }

    public MultiplexingTcpHostHarvester(List<TransportAddress> transportAddresses, boolean ssltcp) throws IOException {
        this.ssltcp = ssltcp;
        this.addLocalAddresses(transportAddresses);
        this.init();
    }

    private void addLocalAddresses(List<TransportAddress> transportAddresses) throws IOException {
        boolean useIPv6 = !StackProperties.getBoolean("org.ice4j.ipv6.DISABLED", false);
        boolean useIPv6LinkLocal = !StackProperties.getBoolean("org.ice4j.ice.harvest.DISABLE_LINK_LOCAL_ADDRESSES", false);
        String[] allowedAddressesStr = StackProperties.getStringArray("org.ice4j.ice.harvest.ALLOWED_ADDRESSES", ";");
        InetAddress[] allowedAddresses = null;
        if (allowedAddressesStr != null) {
            allowedAddresses = new InetAddress[allowedAddressesStr.length];
            for (int i = 0; i < allowedAddressesStr.length; ++i) {
                allowedAddresses[i] = InetAddress.getByName(allowedAddressesStr[i]);
            }
        }
        String[] blockedAddressesStr = StackProperties.getStringArray("org.ice4j.ice.harvest.BLOCKED_ADDRESSES", ";");
        InetAddress[] blockedAddresses = null;
        if (blockedAddressesStr != null) {
            blockedAddresses = new InetAddress[blockedAddressesStr.length];
            for (int i = 0; i < blockedAddressesStr.length; ++i) {
                blockedAddresses[i] = InetAddress.getByName(blockedAddressesStr[i]);
            }
        }
        for (TransportAddress transportAddress : transportAddresses) {
            boolean found;
            InetAddress address = transportAddress.getAddress();
            if (address.isLoopbackAddress() || !useIPv6 && address instanceof Inet6Address) continue;
            if (!useIPv6LinkLocal && address instanceof Inet6Address && address.isLinkLocalAddress()) {
                logger.info("Not using link-local address " + address + " for" + " TCP candidates.");
                continue;
            }
            if (allowedAddresses != null) {
                found = false;
                for (InetAddress allowedAddress : allowedAddresses) {
                    if (!allowedAddress.equals(address)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    logger.info("Not using " + address + " for TCP candidates, " + "because it is not in the allowed list.");
                    continue;
                }
            }
            if (blockedAddresses != null) {
                found = false;
                for (InetAddress blockedAddress : blockedAddresses) {
                    if (!blockedAddress.equals(address)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    logger.info("Not using " + address + " for TCP candidates, " + "because it is in the blocked list.");
                    continue;
                }
            }
            this.localAddresses.add(transportAddress);
        }
    }

    public void addMappedAddress(InetAddress publicAddress, InetAddress localAddress) {
        this.mappedAddresses.put(publicAddress, localAddress);
    }

    public void addMappedPort(int port) {
        this.mappedPorts.add(port);
    }

    public void close() {
        this.close = true;
    }

    private List<LocalCandidate> createLocalCandidates(Component component) {
        LinkedList<TcpHostCandidate> hostCandidates = new LinkedList<TcpHostCandidate>();
        for (TransportAddress transportAddress : this.localAddresses) {
            TcpHostCandidate tcpHostCandidate = new TcpHostCandidate(transportAddress, component);
            tcpHostCandidate.setTcpType(CandidateTcpType.PASSIVE);
            if (this.ssltcp) {
                tcpHostCandidate.setSSL(true);
            }
            hostCandidates.add(tcpHostCandidate);
        }
        LinkedList<ServerReflexiveCandidate> mappedCandidates = new LinkedList<ServerReflexiveCandidate>();
        for (Map.Entry<InetAddress, InetAddress> entry : this.mappedAddresses.entrySet()) {
            InetAddress inetAddress = entry.getValue();
            for (TcpHostCandidate base : hostCandidates) {
                TransportAddress baseTransportAddress = base.getTransportAddress();
                if (!inetAddress.equals(baseTransportAddress.getAddress())) continue;
                InetAddress publicAddress = entry.getKey();
                ServerReflexiveCandidate mappedCandidate = new ServerReflexiveCandidate(new TransportAddress(publicAddress, baseTransportAddress.getPort(), Transport.TCP), base, base.getStunServerAddress(), CandidateExtendedType.STATICALLY_MAPPED_CANDIDATE);
                if (base.isSSL()) {
                    mappedCandidate.setSSL(true);
                }
                mappedCandidate.setTcpType(CandidateTcpType.PASSIVE);
                mappedCandidates.add(mappedCandidate);
            }
        }
        LinkedList<ServerReflexiveCandidate> linkedList = new LinkedList<ServerReflexiveCandidate>();
        for (TcpHostCandidate tcpHostCandidate : hostCandidates) {
            for (Integer port : this.mappedPorts) {
                ServerReflexiveCandidate portMappedCandidate = new ServerReflexiveCandidate(new TransportAddress(tcpHostCandidate.getTransportAddress().getAddress(), (int)port, Transport.TCP), tcpHostCandidate, tcpHostCandidate.getStunServerAddress(), CandidateExtendedType.STATICALLY_MAPPED_CANDIDATE);
                if (tcpHostCandidate.isSSL()) {
                    portMappedCandidate.setSSL(true);
                }
                portMappedCandidate.setTcpType(CandidateTcpType.PASSIVE);
                linkedList.add(portMappedCandidate);
            }
        }
        for (LocalCandidate localCandidate : mappedCandidates) {
            TcpHostCandidate base = (TcpHostCandidate)localCandidate.getBase();
            for (Integer port : this.mappedPorts) {
                ServerReflexiveCandidate portMappedCandidate = new ServerReflexiveCandidate(new TransportAddress(localCandidate.getTransportAddress().getAddress(), (int)port, Transport.TCP), base, base.getStunServerAddress(), CandidateExtendedType.STATICALLY_MAPPED_CANDIDATE);
                if (base.isSSL()) {
                    portMappedCandidate.setSSL(true);
                }
                portMappedCandidate.setTcpType(CandidateTcpType.PASSIVE);
                linkedList.add(portMappedCandidate);
            }
        }
        LinkedList<LocalCandidate> linkedList2 = new LinkedList<LocalCandidate>();
        linkedList2.addAll(hostCandidates);
        linkedList2.addAll(mappedCandidates);
        linkedList2.addAll(linkedList);
        return linkedList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Component getComponent(String localUfrag) {
        Map<String, WeakReference<Component>> map = this.components;
        synchronized (map) {
            WeakReference<Component> wr = this.components.get(localUfrag);
            if (wr != null) {
                Component component = (Component)wr.get();
                if (component == null) {
                    this.components.remove(localUfrag);
                }
                return component;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<LocalCandidate> harvest(Component component) {
        IceMediaStream stream = component.getParentStream();
        Agent agent = stream.getParentAgent();
        if (stream.getComponentCount() != 1 || agent.getStreamCount() != 1) {
            logger.info("More than one Component for an Agent, cannot harvest.");
            return new LinkedList<LocalCandidate>();
        }
        List<LocalCandidate> candidates = this.createLocalCandidates(component);
        for (LocalCandidate candidate : candidates) {
            component.addLocalCandidate(candidate);
        }
        Map<String, WeakReference<Component>> map = this.components;
        synchronized (map) {
            this.components.put(agent.getLocalUfrag(), new WeakReference<Component>(component));
            this.purgeComponents();
        }
        return candidates;
    }

    private void init() throws IOException {
        TransportAddress ec2Mask;
        for (TransportAddress transportAddress : this.localAddresses) {
            ServerSocketChannel channel = MuxServerSocketChannelFactory.openAndBindMuxServerSocketChannel(null, new InetSocketAddress(transportAddress.getAddress(), transportAddress.getPort()), 0, new DatagramPacketFilter(){

                public boolean accept(DatagramPacket p) {
                    return MultiplexingTcpHostHarvester.this.isFirstDatagramPacket(p);
                }
            });
            this.serverSocketChannels.add(channel);
        }
        TransportAddress ec2Face = AwsCandidateHarvester.getFace();
        if (ec2Face != null && (ec2Mask = AwsCandidateHarvester.getMask()) != null) {
            this.addMappedAddress(ec2Mask.getAddress(), ec2Face.getAddress());
            logger.info("Adding an EC2 mapping for TCP: " + ec2Face + "->" + ec2Mask);
        }
        this.acceptThread = new AcceptThread();
        this.acceptThread.start();
        this.readThread = new ReadThread();
        this.readThread.start();
    }

    private boolean isFirstDatagramPacket(DatagramPacket p) {
        boolean b;
        block5: {
            int off;
            byte[] buf;
            int len;
            block6: {
                len = p.getLength();
                b = false;
                if (len <= 0) break block5;
                buf = p.getData();
                off = p.getOffset();
                if (!this.ssltcp) break block6;
                byte[] googleTurnSslTcp = GoogleTurnSSLCandidateHarvester.SSL_CLIENT_HANDSHAKE;
                if (len < googleTurnSslTcp.length) break block5;
                b = true;
                int i = 0;
                int iEnd = googleTurnSslTcp.length;
                int j = off;
                while (i < iEnd) {
                    if (googleTurnSslTcp[i] != buf[j]) {
                        b = false;
                        break block5;
                    }
                    ++i;
                    ++j;
                }
                break block5;
            }
            if (len >= 10 && buf[off + 2] == 0 && buf[off + 3] == 1) {
                byte[] magicCookie = Message.MAGIC_COOKIE;
                b = true;
                int i = 0;
                int iEnd = magicCookie.length;
                int j = off + 6;
                while (i < iEnd) {
                    if (magicCookie[i] != buf[j]) {
                        b = false;
                        break;
                    }
                    ++i;
                    ++j;
                }
            }
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeComponents() {
        ++this.purgeCounter;
        if (this.purgeCounter % 20 == 0) {
            Map<String, WeakReference<Component>> map = this.components;
            synchronized (map) {
                Iterator<WeakReference<Component>> i = this.components.values().iterator();
                while (i.hasNext()) {
                    if (i.next().get() != null) continue;
                    i.remove();
                }
            }
        }
    }

    @Override
    public boolean isHostHarvester() {
        return true;
    }

    private class ReadThread
    extends Thread {
        public ReadThread() throws IOException {
            this.setName("MultiplexingTcpHostHarvester ReadThread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkForNewChannels() {
            List list = MultiplexingTcpHostHarvester.this.newChannels;
            synchronized (list) {
                for (SocketChannel channel : MultiplexingTcpHostHarvester.this.newChannels) {
                    try {
                        channel.configureBlocking(false);
                        channel.register(MultiplexingTcpHostHarvester.this.readSelector, 1, new ChannelDesc(channel));
                    }
                    catch (IOException ioe) {
                        logger.info("Failed to register channel: " + ioe);
                        MultiplexingTcpHostHarvester.closeNoExceptions(channel);
                    }
                }
                MultiplexingTcpHostHarvester.this.newChannels.clear();
            }
        }

        private void cleanup() {
            long now = System.currentTimeMillis();
            for (SelectionKey key : MultiplexingTcpHostHarvester.this.readSelector.keys()) {
                long lastActive;
                ChannelDesc channelDesc;
                if (!key.isValid() || (channelDesc = (ChannelDesc)key.attachment()) == null || (lastActive = channelDesc.lastActive) == -1L || now - lastActive <= 15000L) continue;
                key.cancel();
                SocketChannel channel = channelDesc.channel;
                logger.info("Read timeout for socket: " + channel.socket());
                MultiplexingTcpHostHarvester.closeNoExceptions(channel);
            }
        }

        private TcpHostCandidate findCandidate(Component component, Socket socket) {
            InetAddress localAddress = socket.getLocalAddress();
            int localPort = socket.getLocalPort();
            for (LocalCandidate candidate : component.getLocalCandidates()) {
                TransportAddress transportAddress = candidate.getTransportAddress();
                if (!(candidate instanceof TcpHostCandidate) || !Transport.TCP.equals((Object)transportAddress.getTransport()) || localPort != transportAddress.getPort() || !localAddress.equals(transportAddress.getAddress())) continue;
                return (TcpHostCandidate)candidate;
            }
            return null;
        }

        private void handSocketToComponent(Socket socket, Component component, DatagramPacket datagramPacket) {
            IceProcessingState state = component.getParentStream().getParentAgent().getState();
            if (!IceProcessingState.WAITING.equals((Object)state) && !IceProcessingState.RUNNING.equals((Object)state)) {
                logger.info("Not adding a socket to an ICE agent with state " + (Object)((Object)state));
                return;
            }
            IceTcpSocketWrapper candidateSocket = null;
            IceSocketWrapper stunSocket = null;
            try {
                MultiplexingSocket multiplexing = new MultiplexingSocket(socket);
                candidateSocket = new IceTcpSocketWrapper(multiplexing);
                stunSocket = new IceTcpSocketWrapper(multiplexing.getSocket(new StunDatagramPacketFilter()));
                stunSocket = new PushBackIceSocketWrapper(stunSocket, datagramPacket);
            }
            catch (IOException ioe) {
                logger.info("Failed to create sockets: " + ioe);
            }
            TcpHostCandidate candidate = this.findCandidate(component, socket);
            if (candidate != null) {
                component.getParentStream().getParentAgent().getStunStack().addSocket(stunSocket);
                candidate.addSocket(candidateSocket);
            } else {
                logger.info("Failed to find the local candidate for socket: " + socket);
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void readFromChannel(ChannelDesc channel, SelectionKey key) {
            if (channel.buffer == null) {
                channel.buffer = MultiplexingTcpHostHarvester.this.ssltcp && !channel.sslHandshakeRead ? ByteBuffer.allocate(GoogleTurnSSLCandidateHarvester.SSL_CLIENT_HANDSHAKE.length) : (channel.length == -1 ? ByteBuffer.allocate(2) : ByteBuffer.allocate(channel.length));
            }
            try {
                int read = channel.channel.read(channel.buffer);
                if (read == -1) {
                    throw new IOException("End of stream!");
                }
                if (read > 0) {
                    channel.lastActive = System.currentTimeMillis();
                }
                if (channel.buffer.hasRemaining()) return;
                if (MultiplexingTcpHostHarvester.this.ssltcp && !channel.sslHandshakeRead) {
                    byte[] bytesRead = new byte[GoogleTurnSSLCandidateHarvester.SSL_CLIENT_HANDSHAKE.length];
                    channel.buffer.flip();
                    channel.buffer.get(bytesRead);
                    channel.buffer = null;
                    channel.sslHandshakeRead = true;
                    if (!Arrays.equals(bytesRead, GoogleTurnSSLCandidateHarvester.SSL_CLIENT_HANDSHAKE)) throw new IOException("Expected a pseudo ssl handshake, but received something else.");
                    ByteBuffer byteBuffer = ByteBuffer.wrap(GoogleTurnSSLCandidateHarvester.SSL_SERVER_HANDSHAKE);
                    channel.channel.write(byteBuffer);
                    return;
                } else if (channel.length == -1) {
                    channel.buffer.flip();
                    byte fb = channel.buffer.get();
                    byte sb = channel.buffer.get();
                    channel.length = (fb & 0xFF) << 8 | sb & 0xFF;
                    channel.buffer = null;
                    return;
                } else {
                    byte[] bytesRead = new byte[channel.length];
                    channel.buffer.flip();
                    channel.buffer.get(bytesRead);
                    Message stunMessage = Message.decode(bytesRead, '\u0000', (char)bytesRead.length);
                    if (stunMessage.getMessageType() != '\u0001') {
                        throw new IOException("Not a binding request");
                    }
                    UsernameAttribute usernameAttribute = (UsernameAttribute)stunMessage.getAttribute('\u0006');
                    if (usernameAttribute == null) {
                        throw new IOException("No USERNAME attribute present.");
                    }
                    String usernameString = new String(usernameAttribute.getUsername());
                    String localUfrag = usernameString.split(":")[0];
                    Component component = MultiplexingTcpHostHarvester.this.getComponent(localUfrag);
                    if (component == null) {
                        throw new IOException("No component found.");
                    }
                    key.cancel();
                    channel.channel.configureBlocking(true);
                    DatagramPacket p = new DatagramPacket(bytesRead, bytesRead.length);
                    Socket socket = channel.channel.socket();
                    p.setAddress(socket.getInetAddress());
                    p.setPort(socket.getPort());
                    this.handSocketToComponent(socket, component, p);
                }
                return;
            }
            catch (IOException ioe) {
                logger.info("Failed to handle TCP socket " + channel.channel.socket() + ": " + ioe);
                key.cancel();
                MultiplexingTcpHostHarvester.closeNoExceptions(channel.channel);
                return;
            }
            catch (StunException se) {
                logger.info("Failed to handle TCP socket " + channel.channel.socket() + ": " + se);
                key.cancel();
                MultiplexingTcpHostHarvester.closeNoExceptions(channel.channel);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Iterator<SelectionKey> iterator;
            while (true) {
                iterator = MultiplexingTcpHostHarvester.this;
                synchronized (iterator) {
                    if (MultiplexingTcpHostHarvester.this.close) {
                        break;
                    }
                }
                this.cleanup();
                this.checkForNewChannels();
                for (SelectionKey selectionKey : MultiplexingTcpHostHarvester.this.readSelector.keys()) {
                    if (!selectionKey.isValid()) continue;
                    ChannelDesc channelDesc = (ChannelDesc)selectionKey.attachment();
                    this.readFromChannel(channelDesc, selectionKey);
                }
                MultiplexingTcpHostHarvester.this.readSelector.selectedKeys().clear();
                try {
                    MultiplexingTcpHostHarvester.this.readSelector.select(7500L);
                }
                catch (IOException ioe) {
                    logger.info("Failed to select a read-ready channel.");
                }
            }
            iterator = MultiplexingTcpHostHarvester.this.newChannels;
            synchronized (iterator) {
                for (SelectableChannel channel : MultiplexingTcpHostHarvester.this.newChannels) {
                    MultiplexingTcpHostHarvester.closeNoExceptions(channel);
                }
                MultiplexingTcpHostHarvester.this.newChannels.clear();
            }
            for (SelectionKey selectionKey : MultiplexingTcpHostHarvester.this.readSelector.keys()) {
                SelectableChannel channel;
                if (!selectionKey.isValid() || !(channel = selectionKey.channel()).isOpen()) continue;
                MultiplexingTcpHostHarvester.closeNoExceptions(channel);
            }
            try {
                MultiplexingTcpHostHarvester.this.readSelector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class PushBackIceSocketWrapper
    extends IceSocketWrapper {
        private DatagramPacket datagramPacket;
        private final IceSocketWrapper wrapped;

        public PushBackIceSocketWrapper(IceSocketWrapper wrappedWrapper, DatagramPacket datagramPacket) {
            this.wrapped = wrappedWrapper;
            this.datagramPacket = datagramPacket;
        }

        public void close() {
            this.wrapped.close();
        }

        public InetAddress getLocalAddress() {
            return this.wrapped.getLocalAddress();
        }

        public int getLocalPort() {
            return this.wrapped.getLocalPort();
        }

        public SocketAddress getLocalSocketAddress() {
            return this.wrapped.getLocalSocketAddress();
        }

        public Socket getTCPSocket() {
            return this.wrapped.getTCPSocket();
        }

        public DatagramSocket getUDPSocket() {
            return this.wrapped.getUDPSocket();
        }

        public void receive(DatagramPacket p) throws IOException {
            if (this.datagramPacket != null) {
                int len = Math.min(p.getLength(), this.datagramPacket.getLength());
                System.arraycopy(this.datagramPacket.getData(), 0, p.getData(), 0, len);
                p.setAddress(this.datagramPacket.getAddress());
                p.setPort(this.datagramPacket.getPort());
                this.datagramPacket = null;
            } else {
                this.wrapped.receive(p);
            }
        }

        public void send(DatagramPacket p) throws IOException {
            this.wrapped.send(p);
        }
    }

    private static class ChannelDesc {
        public final SocketChannel channel;
        long lastActive = System.currentTimeMillis();
        ByteBuffer buffer = null;
        boolean sslHandshakeRead = false;
        int length = -1;

        public ChannelDesc(SocketChannel channel) {
            this.channel = channel;
        }
    }

    private class AcceptThread
    extends Thread {
        private final Selector selector;

        public AcceptThread() throws IOException {
            this.setName("MultiplexingTcpHostHarvester AcceptThread");
            this.setDaemon(true);
            this.selector = Selector.open();
            for (ServerSocketChannel channel : MultiplexingTcpHostHarvester.this.serverSocketChannels) {
                channel.configureBlocking(false);
                channel.register(this.selector, 16);
            }
        }

        private void notifyReadThread() {
            MultiplexingTcpHostHarvester.this.readSelector.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!MultiplexingTcpHostHarvester.this.close) {
                IOException exception = null;
                LinkedList<SocketChannel> channelsToAdd = new LinkedList<SocketChannel>();
                long selectTimeout = 3000L;
                for (SelectionKey key : this.selector.keys()) {
                    SocketChannel channel;
                    if (!key.isValid()) continue;
                    boolean acceptable = key.isAcceptable();
                    try {
                        channel = ((ServerSocketChannel)key.channel()).accept();
                    }
                    catch (IOException ioe) {
                        exception = ioe;
                        break;
                    }
                    if (channel != null) {
                        channelsToAdd.add(channel);
                        continue;
                    }
                    if (!acceptable) continue;
                    selectTimeout = 100L;
                }
                this.selector.selectedKeys().clear();
                if (!channelsToAdd.isEmpty()) {
                    List list = MultiplexingTcpHostHarvester.this.newChannels;
                    synchronized (list) {
                        MultiplexingTcpHostHarvester.this.newChannels.addAll(channelsToAdd);
                    }
                    this.notifyReadThread();
                }
                if (exception != null) {
                    logger.info("Failed to accept a socket, which should have been ready to accept: " + exception);
                    break;
                }
                try {
                    this.selector.select(selectTimeout);
                }
                catch (IOException ioe) {
                    logger.info("Failed to select an accept-ready socket: " + ioe);
                    break;
                }
            }
            for (ServerSocketChannel serverSocketChannel : MultiplexingTcpHostHarvester.this.serverSocketChannels) {
                MultiplexingTcpHostHarvester.closeNoExceptions(serverSocketChannel);
            }
            try {
                this.selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

