/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.selectors.BaseSelector;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.IdentityMapper;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class MappingSelector
extends BaseSelector {
    protected File targetdir;
    protected Mapper mapperElement;
    protected FileNameMapper map;
    protected int granularity;

    public void setTargetdir(File file) {
        this.targetdir = file;
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper");
        }
        this.mapperElement = new Mapper(this.getProject());
        return this.mapperElement;
    }

    public void verifySettings() {
        if (this.targetdir == null) {
            this.setError("The targetdir attribute is required.");
        }
        this.map = this.mapperElement == null ? new IdentityMapper() : this.mapperElement.getImplementation();
        if (this.map == null) {
            this.setError("Could not set <mapper> element.");
        }
    }

    public boolean isSelected(File file, String string, File file2) {
        this.validate();
        String[] stringArray = this.map.mapFileName(string);
        if (stringArray == null) {
            return false;
        }
        if (stringArray.length != 1 || stringArray[0] == null) {
            throw new BuildException("Invalid destination file results for " + this.targetdir.getName() + " with filename " + string);
        }
        String string2 = stringArray[0];
        File file3 = new File(this.targetdir, string2);
        boolean bl = this.selectionTest(file2, file3);
        return bl;
    }

    protected abstract boolean selectionTest(File var1, File var2);

    public void setGranularity(int n) {
        this.granularity = n;
    }

    private final /* synthetic */ void this() {
        this.targetdir = null;
        this.mapperElement = null;
        this.map = null;
        this.granularity = 0;
    }

    public MappingSelector() {
        this.this();
        this.granularity = (int)FileUtils.newFileUtils().getFileTimestampGranularity();
    }
}

