/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.packet;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import gnu.inet.encoding.IDNA;
import gnu.inet.encoding.Stringprep;
import gnu.inet.encoding.StringprepException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ConcurrentMap;
import net.jcip.annotations.Immutable;
import org.xmpp.util.ValueWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class JID
implements Comparable<JID>,
Serializable {
    private static final long serialVersionUID = 8135170608402192877L;
    private static final ConcurrentMap<String, ValueWrapper<String>> NODEPREP_CACHE = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(10000).build();
    private static final ConcurrentMap<String, ValueWrapper<String>> DOMAINPREP_CACHE = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(500).build();
    private static final ConcurrentMap<String, ValueWrapper<String>> RESOURCEPREP_CACHE = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(10000).build();
    private final String node;
    private final String domain;
    private final String resource;

    public static String escapeNode(String node) {
        if (node == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(node.length() + 8);
        int n = node.length();
        block11: for (int i = 0; i < n; ++i) {
            char c = node.charAt(i);
            switch (c) {
                case '\"': {
                    buf.append("\\22");
                    continue block11;
                }
                case '&': {
                    buf.append("\\26");
                    continue block11;
                }
                case '\'': {
                    buf.append("\\27");
                    continue block11;
                }
                case '/': {
                    buf.append("\\2f");
                    continue block11;
                }
                case ':': {
                    buf.append("\\3a");
                    continue block11;
                }
                case '<': {
                    buf.append("\\3c");
                    continue block11;
                }
                case '>': {
                    buf.append("\\3e");
                    continue block11;
                }
                case '@': {
                    buf.append("\\40");
                    continue block11;
                }
                case '\\': {
                    int c3;
                    int c2 = i + 1 < n ? (int)node.charAt(i + 1) : -1;
                    int n2 = c3 = i + 2 < n ? (int)node.charAt(i + 2) : -1;
                    if (c2 == 50 && (c3 == 48 || c3 == 50 || c3 == 54 || c3 == 55 || c3 == 102) || c2 == 51 && (c3 == 97 || c3 == 99 || c3 == 101) || c2 == 52 && c3 == 48 || c2 == 53 && c3 == 99) {
                        buf.append("\\5c");
                        continue block11;
                    }
                    buf.append(c);
                    continue block11;
                }
                default: {
                    if (Character.isWhitespace(c)) {
                        buf.append("\\20");
                        continue block11;
                    }
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public static String unescapeNode(String node) {
        if (node == null) {
            return null;
        }
        char[] nodeChars = node.toCharArray();
        StringBuilder buf = new StringBuilder(nodeChars.length);
        int n = nodeChars.length;
        block12: for (int i = 0; i < n; ++i) {
            char c = node.charAt(i);
            if (c == '\\' && i + 2 < n) {
                char c2 = nodeChars[i + 1];
                char c3 = nodeChars[i + 2];
                if (c2 == '2') {
                    switch (c3) {
                        case '0': {
                            buf.append(' ');
                            i += 2;
                            continue block12;
                        }
                        case '2': {
                            buf.append('\"');
                            i += 2;
                            continue block12;
                        }
                        case '6': {
                            buf.append('&');
                            i += 2;
                            continue block12;
                        }
                        case '7': {
                            buf.append('\'');
                            i += 2;
                            continue block12;
                        }
                        case 'f': {
                            buf.append('/');
                            i += 2;
                            continue block12;
                        }
                    }
                } else if (c2 == '3') {
                    switch (c3) {
                        case 'a': {
                            buf.append(':');
                            i += 2;
                            continue block12;
                        }
                        case 'c': {
                            buf.append('<');
                            i += 2;
                            continue block12;
                        }
                        case 'e': {
                            buf.append('>');
                            i += 2;
                            continue block12;
                        }
                    }
                } else if (c2 == '4') {
                    if (c3 == '0') {
                        buf.append("@");
                        i += 2;
                        continue;
                    }
                } else if (c2 == '5' && c3 == 'c') {
                    buf.append("\\");
                    i += 2;
                    continue;
                }
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String nodeprep(String node) {
        String answer;
        if (node == null) {
            return null;
        }
        ValueWrapper cachedResult = (ValueWrapper)NODEPREP_CACHE.get(node);
        if (cachedResult == null) {
            try {
                answer = Stringprep.nodeprep((String)node);
                if (answer != null && answer.getBytes("UTF-8").length > 1023) {
                    throw new IllegalArgumentException("Node cannot be larger than 1023 bytes. Size is " + answer.getBytes("UTF-8").length + " bytes.");
                }
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalStateException("Unable to construct a JID node.", ex);
            }
            catch (Exception ex) {
                NODEPREP_CACHE.put(node, new ValueWrapper(ValueWrapper.Representation.ILLEGAL));
                throw new IllegalArgumentException("The input is not a valid JID node: " + node, ex);
            }
            NODEPREP_CACHE.put(answer, new ValueWrapper(ValueWrapper.Representation.USE_KEY));
            if (!node.equals(answer)) {
                NODEPREP_CACHE.put(node, new ValueWrapper<String>(answer));
            }
        } else {
            switch (cachedResult.getRepresentation()) {
                case USE_KEY: {
                    answer = node;
                    break;
                }
                case USE_VALUE: {
                    answer = (String)cachedResult.getValue();
                    break;
                }
                case ILLEGAL: {
                    throw new IllegalArgumentException("The input is not a valid JID node: " + node);
                }
                default: {
                    throw new IllegalStateException("The implementation of JID#nodeprep(String) is broken.");
                }
            }
        }
        return answer;
    }

    public static String domainprep(String domain) throws StringprepException {
        String answer;
        if (domain == null) {
            throw new IllegalArgumentException("Argument 'domain' cannot be null.");
        }
        ValueWrapper cachedResult = (ValueWrapper)DOMAINPREP_CACHE.get(domain);
        if (cachedResult == null) {
            try {
                answer = Stringprep.nameprep((String)IDNA.toASCII((String)domain), (boolean)false);
                if (answer != null && answer.getBytes("UTF-8").length > 1023) {
                    throw new IllegalArgumentException("Domain cannot be larger than 1023 bytes. Size is " + answer.getBytes("UTF-8").length + " bytes.");
                }
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalStateException("Unable to construct a JID domain.", ex);
            }
            catch (Exception ex) {
                DOMAINPREP_CACHE.put(domain, new ValueWrapper(ValueWrapper.Representation.ILLEGAL));
                throw new IllegalArgumentException("The input is not a valid JID domain part: " + domain, ex);
            }
            DOMAINPREP_CACHE.put(answer, new ValueWrapper(ValueWrapper.Representation.USE_KEY));
            if (!domain.equals(answer)) {
                DOMAINPREP_CACHE.put(domain, new ValueWrapper<String>(answer));
            }
        } else {
            switch (cachedResult.getRepresentation()) {
                case USE_KEY: {
                    answer = domain;
                    break;
                }
                case USE_VALUE: {
                    answer = (String)cachedResult.getValue();
                    break;
                }
                case ILLEGAL: {
                    throw new IllegalArgumentException("The input is not a valid JID domain part: " + domain);
                }
                default: {
                    throw new IllegalStateException("The implementation of JID#domainprep(String) is broken.");
                }
            }
        }
        return answer;
    }

    public static String resourceprep(String resource) throws StringprepException {
        String answer;
        if (resource == null) {
            return null;
        }
        ValueWrapper cachedResult = (ValueWrapper)RESOURCEPREP_CACHE.get(resource);
        if (cachedResult == null) {
            try {
                answer = Stringprep.resourceprep((String)resource);
                if (answer != null && answer.getBytes("UTF-8").length > 1023) {
                    throw new IllegalArgumentException("Resource cannot be larger than 1023 bytes. Size is " + answer.getBytes("UTF-8").length + " bytes.");
                }
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalStateException("Unable to construct a JID resource.", ex);
            }
            catch (Exception ex) {
                RESOURCEPREP_CACHE.put(resource, new ValueWrapper(ValueWrapper.Representation.ILLEGAL));
                throw new IllegalArgumentException("The input is not a valid JID resource: " + resource, ex);
            }
            RESOURCEPREP_CACHE.put(answer, new ValueWrapper(ValueWrapper.Representation.USE_KEY));
            if (!resource.equals(answer)) {
                RESOURCEPREP_CACHE.put(resource, new ValueWrapper<String>(answer));
            }
        } else {
            switch (cachedResult.getRepresentation()) {
                case USE_KEY: {
                    answer = resource;
                    break;
                }
                case USE_VALUE: {
                    answer = (String)cachedResult.getValue();
                    break;
                }
                case ILLEGAL: {
                    throw new IllegalArgumentException("The input is not a valid JID resource part: " + resource);
                }
                default: {
                    throw new IllegalStateException("The implementation of JID#resourceprep(String) is broken.");
                }
            }
        }
        return answer;
    }

    public JID(String jid) {
        this(JID.getParts(jid), false);
    }

    public JID(String jid, boolean skipStringPrep) {
        this(JID.getParts(jid), skipStringPrep);
    }

    private JID(String[] parts, boolean skipStringPrep) {
        this(parts[0], parts[1], parts[2], skipStringPrep);
    }

    public JID(String node, String domain, String resource) {
        this(node, domain, resource, false);
    }

    public JID(String node, String domain, String resource, boolean skipStringprep) {
        if (domain == null) {
            throw new NullPointerException("Domain cannot be null");
        }
        if (skipStringprep) {
            this.node = node;
            this.domain = domain;
            this.resource = resource;
        } else {
            if (node != null && node.equals("")) {
                node = null;
            }
            if (resource != null && resource.equals("")) {
                resource = null;
            }
            try {
                this.node = JID.nodeprep(node);
                this.domain = JID.domainprep(domain);
                this.resource = JID.resourceprep(resource);
            }
            catch (Exception e) {
                StringBuilder buf = new StringBuilder();
                if (node != null) {
                    buf.append(node).append("@");
                }
                buf.append(domain);
                if (resource != null) {
                    buf.append("/").append(resource);
                }
                throw new IllegalArgumentException("Illegal JID: " + buf.toString(), e);
            }
        }
    }

    static String[] getParts(String jid) {
        if (jid == null) {
            throw new IllegalArgumentException("Argument cannot be null.");
        }
        int slashIndex = jid.indexOf("/");
        int atIndex = jid.indexOf("@");
        if (slashIndex > -1 && atIndex > slashIndex) {
            atIndex = -1;
        }
        if (atIndex == 0) {
            throw new IllegalArgumentException("Existing at-character at the first character of the string indicates that an empty node part is provided. This is illegal.");
        }
        if (slashIndex == jid.length() - 1) {
            throw new IllegalArgumentException("Existing slash at the very end of the string indicates that an empty resource part is provided. This is illegal.");
        }
        String node = null;
        if (atIndex > 0) {
            node = jid.substring(0, atIndex);
        }
        String domain = null;
        if (atIndex + 1 > jid.length()) {
            throw new IllegalArgumentException("JID with empty domain not valid");
        }
        domain = atIndex < 0 ? (slashIndex > 0 ? jid.substring(0, slashIndex) : jid) : (slashIndex > 0 ? jid.substring(atIndex + 1, slashIndex) : jid.substring(atIndex + 1));
        String resource = null;
        resource = slashIndex + 1 > jid.length() || slashIndex < 0 ? null : jid.substring(slashIndex + 1);
        String[] parts = new String[]{node, domain, resource};
        return parts;
    }

    public String getNode() {
        return this.node;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getResource() {
        return this.resource;
    }

    public String toBareJID() {
        StringBuilder sb = new StringBuilder();
        if (this.node != null) {
            sb.append(this.node);
            sb.append('@');
        }
        sb.append(this.domain);
        return sb.toString();
    }

    public String toFullJID() {
        if (this.resource == null) {
            throw new IllegalStateException("This JID was instantiated without a resource identifier. A full JID representation is not available for: " + this.toString());
        }
        StringBuilder sb = new StringBuilder();
        if (this.node != null) {
            sb.append(this.node);
            sb.append('@');
        }
        sb.append(this.domain);
        if (this.resource != null) {
            sb.append('/');
            sb.append(this.resource);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.node != null) {
            sb.append(this.node);
            sb.append('@');
        }
        sb.append(this.domain);
        if (this.resource != null) {
            sb.append('/');
            sb.append(this.resource);
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof JID)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        JID jid = (JID)object;
        if (this.node != null ? !this.node.equals(jid.node) : jid.node != null) {
            return false;
        }
        if (!this.domain.equals(jid.domain)) {
            return false;
        }
        return !(this.resource != null ? !this.resource.equals(jid.resource) : jid.resource != null);
    }

    @Override
    public int compareTo(JID jid) {
        int compare = this.domain.compareTo(jid.domain);
        if (compare == 0) {
            String myNode = this.node != null ? this.node : "";
            String hisNode = jid.node != null ? jid.node : "";
            compare = myNode.compareTo(hisNode);
        }
        if (compare == 0) {
            String myResource = this.resource != null ? this.resource : "";
            String hisResource = jid.resource != null ? jid.resource : "";
            compare = myResource.compareTo(hisResource);
        }
        return compare;
    }

    public static boolean equals(String jid1, String jid2) {
        return new JID(jid1).equals(new JID(jid2));
    }
}

