/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd.getfile;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.rvcmd.AbstractRequestRvCmd;
import net.kano.joscar.rvcmd.RvConnectionInfo;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;

public class GetFileReqRvCmd
extends AbstractRequestRvCmd {
    public static final String CHARSET_DEFAULT = "us-ascii";
    public static final int CODE_DEFAULT = 18;
    public static final int PROTOVERSION_DEFAULT = 2;
    public static final int PROTOVERSION_OLD = 1;
    public static final long FLAG_EXPAND_DYNAMIC = 1L;
    public static final ByteBlock EXTRABLOCK_DEFAULT = ByteBlock.wrap(new byte[]{0});
    private static final int TYPE_CHARSET = 10002;
    private final RvConnectionInfo connInfo;
    private final String charset;
    private final int code;
    private final int protoVersion;
    private final long flags;
    private final ByteBlock extraBlock;

    public GetFileReqRvCmd(RecvRvIcbm recvRvIcbm) {
        super(recvRvIcbm);
        TlvChain tlvChain = this.getRvTlvs();
        this.connInfo = RvConnectionInfo.readConnectionInfo(tlvChain);
        this.charset = tlvChain.getString(10002);
        ByteBlock byteBlock = this.getServiceData();
        if (byteBlock == null) {
            this.code = -1;
            this.protoVersion = -1;
            this.flags = -1L;
            this.extraBlock = null;
        } else {
            this.code = BinaryTools.getUShort(byteBlock, 0);
            this.protoVersion = BinaryTools.getUShort(byteBlock, 2);
            this.flags = BinaryTools.getUInt(byteBlock, 4);
            this.extraBlock = byteBlock.getLength() > 8 ? ByteBlock.wrap(byteBlock.subBlock(8).toByteArray()) : null;
        }
    }

    public GetFileReqRvCmd(RvConnectionInfo rvConnectionInfo) {
        this(rvConnectionInfo, 1L);
    }

    public GetFileReqRvCmd(RvConnectionInfo rvConnectionInfo, long l) {
        this(1, rvConnectionInfo, CHARSET_DEFAULT, 18, 2, l, EXTRABLOCK_DEFAULT);
    }

    public GetFileReqRvCmd(int n, RvConnectionInfo rvConnectionInfo) {
        this(n, rvConnectionInfo, CHARSET_DEFAULT, 18, 2, 1L, EXTRABLOCK_DEFAULT);
    }

    public GetFileReqRvCmd(int n, RvConnectionInfo rvConnectionInfo, String string, int n2, int n3, long l, ByteBlock byteBlock) {
        super(CapabilityBlock.BLOCK_FILE_GET, n);
        DefensiveTools.checkRange(n2, "code", -1);
        DefensiveTools.checkRange(n3, "protoVersion", -1);
        DefensiveTools.checkRange(l, "flags", -1);
        this.connInfo = rvConnectionInfo;
        this.charset = string;
        this.code = n2;
        this.protoVersion = n3;
        this.flags = l;
        this.extraBlock = byteBlock;
    }

    public final RvConnectionInfo getConnInfo() {
        return this.connInfo;
    }

    public final String getCharset() {
        return this.charset;
    }

    public final int getCode() {
        return this.code;
    }

    public final int getProtoVersion() {
        return this.protoVersion;
    }

    public final long getFlags() {
        return this.flags;
    }

    public final ByteBlock getExtraBlock() {
        return this.extraBlock;
    }

    protected void writeRvTlvs(OutputStream outputStream) throws IOException {
        if (this.connInfo != null) {
            this.connInfo.write(outputStream);
        }
        if (this.charset != null) {
            Tlv.getStringInstance(10002, this.charset).write(outputStream);
        }
    }

    protected boolean hasServiceData() {
        return true;
    }

    protected void writeServiceData(OutputStream outputStream) throws IOException {
        if (this.code != -1 && this.protoVersion != -1 && this.flags != -1L) {
            BinaryTools.writeUShort(outputStream, this.code);
            BinaryTools.writeUShort(outputStream, this.protoVersion);
            BinaryTools.writeUInt(outputStream, this.flags);
            if (this.extraBlock != null) {
                this.extraBlock.write(outputStream);
            }
        }
    }

    public String toString() {
        return "GetFileReqRvCmd: connInfo=<" + this.connInfo + ">, code=0x" + Integer.toHexString(this.code) + ", proto=0x" + Integer.toHexString(this.protoVersion) + ", flags=0x" + Long.toHexString(this.flags) + ", extraBlock=" + (this.extraBlock == null ? null : BinaryTools.describeData(this.extraBlock));
    }
}

