/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;

public class DelegatingServerSocket
extends ServerSocket {
    protected final ServerSocketChannel channel;
    protected final ServerSocket delegate;

    public DelegatingServerSocket(ServerSocket delegate) throws IOException {
        this(delegate, delegate.getChannel());
    }

    public DelegatingServerSocket(ServerSocket delegate, ServerSocketChannel channel) throws IOException {
        this.delegate = delegate;
        this.channel = channel;
    }

    public Socket accept() throws IOException {
        return this.delegate.accept();
    }

    public void bind(SocketAddress endpoint) throws IOException {
        this.delegate.bind(endpoint);
    }

    public void bind(SocketAddress endpoint, int backlog) throws IOException {
        this.delegate.bind(endpoint, backlog);
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public ServerSocketChannel getChannel() {
        ServerSocketChannel channel = this.channel;
        return channel == null ? this.delegate.getChannel() : channel;
    }

    public InetAddress getInetAddress() {
        return this.delegate.getInetAddress();
    }

    public int getLocalPort() {
        return this.delegate.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.delegate.getLocalSocketAddress();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.delegate.getReceiveBufferSize();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.delegate.getReuseAddress();
    }

    public int getSoTimeout() throws IOException {
        return this.delegate.getSoTimeout();
    }

    public boolean isBound() {
        return this.delegate.isBound();
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.delegate.setPerformancePreferences(connectionTime, latency, bandwidth);
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.delegate.setReceiveBufferSize(size);
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.delegate.setReuseAddress(on);
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.delegate.setSoTimeout(timeout);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

