/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.filtergraph;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.media.Codec;
import javax.media.Format;
import javax.media.Multiplexer;
import javax.media.PlugIn;
import javax.media.PlugInManager;
import javax.media.Renderer;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import net.sf.fmj.filtergraph.GraphInspector;
import net.sf.fmj.filtergraph.GraphNode;
import net.sf.fmj.media.BasicPlugIn;
import net.sf.fmj.media.BasicTrackControl;
import net.sf.fmj.media.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleGraphBuilder {
    protected int STAGES = 5;
    protected Hashtable<String, GraphNode> plugIns = new Hashtable(40);
    protected GraphNode[] targetPlugins = null;
    protected Vector targetPluginNames = null;
    protected int targetType = -1;
    protected int indent = 0;
    public static GraphInspector inspector;

    public static PlugIn createPlugIn(String string, int n) {
        Object obj;
        try {
            Class<?> clazz = BasicPlugIn.getClassForName(string);
            obj = clazz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
        catch (Error error) {
            return null;
        }
        if (SimpleGraphBuilder.verifyClass(obj, n)) {
            return (PlugIn)obj;
        }
        return null;
    }

    public static Codec findCodec(Format format, Format format2, Format[] formatArray, Format[] formatArray2) {
        Vector vector = PlugInManager.getPlugInList(format, format2, 2);
        if (vector == null) {
            return null;
        }
        Codec codec = null;
        for (int i = 0; i < vector.size(); ++i) {
            Format[] formatArray3;
            Format format3;
            codec = (Codec)SimpleGraphBuilder.createPlugIn((String)vector.elementAt(i), 2);
            if (codec == null || (format3 = SimpleGraphBuilder.matches(format, formatArray3 = codec.getSupportedInputFormats(), null, (PlugIn)codec)) == null) continue;
            if (formatArray != null && formatArray.length > 0) {
                formatArray[0] = format3;
            }
            if ((formatArray3 = codec.getSupportedOutputFormats(format3)) == null || formatArray3.length == 0) continue;
            boolean bl = false;
            for (int j = 0; j < formatArray3.length; ++j) {
                if (format2 != null) {
                    if (!format2.matches(formatArray3[j]) || (format3 = format2.intersects(formatArray3[j])) == null) {
                        continue;
                    }
                } else {
                    format3 = formatArray3[j];
                }
                if (codec.setOutputFormat(format3) == null) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            try {
                codec.open();
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                // empty catch block
            }
            if (formatArray2 != null && formatArray2.length > 0) {
                formatArray2[0] = format3;
            }
            return codec;
        }
        return null;
    }

    public static Renderer findRenderer(Format format) {
        Vector vector = PlugInManager.getPlugInList(format, null, 4);
        if (vector == null) {
            return null;
        }
        Renderer renderer = null;
        for (int i = 0; i < vector.size(); ++i) {
            Format[] formatArray;
            Format format2;
            renderer = (Renderer)SimpleGraphBuilder.createPlugIn((String)vector.elementAt(i), 4);
            if (renderer == null || (format2 = SimpleGraphBuilder.matches(format, formatArray = renderer.getSupportedInputFormats(), null, (PlugIn)renderer)) == null) continue;
            try {
                renderer.open();
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                // empty catch block
            }
            return renderer;
        }
        return null;
    }

    public static Vector findRenderingChain(Format format, Vector vector) {
        SimpleGraphBuilder simpleGraphBuilder = new SimpleGraphBuilder();
        GraphNode graphNode = simpleGraphBuilder.buildGraph(format);
        if (graphNode == null) {
            return null;
        }
        Vector<PlugIn> vector2 = new Vector<PlugIn>(10);
        while (graphNode != null && graphNode.plugin != null) {
            vector2.addElement(graphNode.plugin);
            if (vector != null) {
                vector.addElement(graphNode.input);
            }
            graphNode = graphNode.prev;
        }
        return vector2;
    }

    public static GraphNode getPlugInNode(String string, int n, Map<String, GraphNode> map) {
        GraphNode graphNode = null;
        if (map == null || (graphNode = map.get(string)) == null) {
            PlugIn plugIn = SimpleGraphBuilder.createPlugIn(string, n);
            graphNode = new GraphNode(string, plugIn, null, null, 0);
            if (map != null) {
                map.put(string, graphNode);
            }
            if (plugIn == null) {
                graphNode.failed = true;
                return null;
            }
            return graphNode;
        }
        if (graphNode.failed) {
            return null;
        }
        if (SimpleGraphBuilder.verifyClass(graphNode.plugin, n)) {
            return graphNode;
        }
        return null;
    }

    public static Format matches(Format[] formatArray, Format[] formatArray2, PlugIn plugIn, PlugIn plugIn2) {
        if (formatArray == null) {
            return null;
        }
        for (int i = 0; i < formatArray.length; ++i) {
            Format format = SimpleGraphBuilder.matches(formatArray[i], formatArray2, plugIn, plugIn2);
            if (format == null) continue;
            return format;
        }
        return null;
    }

    public static Format matches(Format format, Format[] formatArray, PlugIn plugIn, PlugIn plugIn2) {
        if (format == null || formatArray == null) {
            return null;
        }
        for (int i = 0; i < formatArray.length; ++i) {
            Format format2;
            if (formatArray[i] == null || !formatArray[i].getClass().isAssignableFrom(format.getClass()) || !format.matches(formatArray[i]) || (format2 = format.intersects(formatArray[i])) == null || plugIn2 != null && (format2 = SimpleGraphBuilder.verifyInput(plugIn2, format2)) == null) continue;
            Format format3 = format2;
            if (plugIn != null && (format3 = SimpleGraphBuilder.verifyOutput(plugIn, format2)) == null || plugIn2 != null && format3 != format2 && SimpleGraphBuilder.verifyInput(plugIn2, format3) == null) continue;
            return format3;
        }
        return null;
    }

    public static Format matches(Format[] formatArray, Format format, PlugIn plugIn, PlugIn plugIn2) {
        Format[] formatArray2 = new Format[]{format};
        return SimpleGraphBuilder.matches(formatArray, formatArray2, plugIn, plugIn2);
    }

    public static boolean verifyClass(Object object, int n) {
        Class clazz;
        switch (n) {
            case 2: {
                clazz = Codec.class;
                break;
            }
            case 4: {
                clazz = Renderer.class;
                break;
            }
            case 5: {
                clazz = Multiplexer.class;
                break;
            }
            default: {
                clazz = PlugIn.class;
            }
        }
        return clazz.isInstance(object);
    }

    public static Format verifyInput(PlugIn plugIn, Format format) {
        if (plugIn instanceof Codec) {
            return ((Codec)plugIn).setInputFormat(format);
        }
        if (plugIn instanceof Renderer) {
            return ((Renderer)plugIn).setInputFormat(format);
        }
        return null;
    }

    public static Format verifyOutput(PlugIn plugIn, Format format) {
        if (plugIn instanceof Codec) {
            return ((Codec)plugIn).setOutputFormat(format);
        }
        return null;
    }

    public static void setGraphInspector(GraphInspector graphInspector) {
        inspector = graphInspector;
    }

    public boolean buildGraph(BasicTrackControl basicTrackControl) {
        Log.comment("Input: " + basicTrackControl.getOriginalFormat());
        Vector<GraphNode> vector = new Vector<GraphNode>();
        GraphNode graphNode = new GraphNode(null, null, basicTrackControl.getOriginalFormat(), null, 0);
        this.indent = 1;
        Log.setIndent(this.indent);
        if (!this.setDefaultTargets(basicTrackControl.getOriginalFormat())) {
            return false;
        }
        vector.addElement(graphNode);
        while ((graphNode = this.buildGraph(vector)) != null) {
            GraphNode graphNode2 = this.buildTrackFromGraph(basicTrackControl, graphNode);
            if (graphNode2 == null) {
                this.indent = 0;
                Log.setIndent(this.indent);
                return true;
            }
            this.removeFailure(vector, graphNode2, basicTrackControl.getOriginalFormat());
        }
        this.indent = 0;
        Log.setIndent(this.indent);
        return false;
    }

    GraphNode buildGraph(Format format) {
        Log.comment("Input: " + format);
        Vector<GraphNode> vector = new Vector<GraphNode>();
        GraphNode graphNode = new GraphNode(null, null, format, null, 0);
        this.indent = 1;
        Log.setIndent(this.indent);
        if (!this.setDefaultTargets(format)) {
            return null;
        }
        vector.addElement(graphNode);
        while ((graphNode = this.buildGraph(vector)) != null) {
            GraphNode graphNode2 = this.verifyGraph(graphNode);
            if (graphNode2 == null) {
                this.indent = 0;
                Log.setIndent(this.indent);
                return graphNode;
            }
            this.removeFailure(vector, graphNode2, format);
        }
        this.indent = 0;
        Log.setIndent(this.indent);
        return graphNode;
    }

    protected GraphNode buildGraph(Vector vector) {
        GraphNode graphNode;
        while ((graphNode = this.doBuildGraph(vector)) == null && !vector.isEmpty()) {
        }
        return graphNode;
    }

    protected GraphNode buildTrackFromGraph(BasicTrackControl basicTrackControl, GraphNode graphNode) {
        return null;
    }

    GraphNode doBuildGraph(Vector vector) {
        Format format;
        Format[] formatArray;
        if (vector.isEmpty()) {
            return null;
        }
        GraphNode graphNode = (GraphNode)vector.firstElement();
        vector.removeElementAt(0);
        if (!(graphNode.input != null || graphNode.plugin != null && graphNode.plugin instanceof Codec)) {
            Log.error("Internal error: doBuildGraph");
            return null;
        }
        int n = this.indent;
        Log.setIndent(graphNode.level + 1);
        if (graphNode.plugin != null && SimpleGraphBuilder.verifyInput(graphNode.plugin, graphNode.input) == null) {
            return null;
        }
        GraphNode graphNode2 = this.findTarget(graphNode);
        if (graphNode2 != null) {
            this.indent = n;
            Log.setIndent(this.indent);
            return graphNode2;
        }
        if (graphNode.level >= this.STAGES) {
            this.indent = n;
            Log.setIndent(this.indent);
            return null;
        }
        boolean bl = false;
        if (graphNode.plugin != null) {
            if (graphNode.output != null) {
                formatArray = new Format[]{graphNode.output};
            } else {
                formatArray = graphNode.getSupportedOutputs(graphNode.input);
                if (formatArray == null || formatArray.length == 0) {
                    this.indent = n;
                    Log.setIndent(this.indent);
                    return null;
                }
            }
            format = graphNode.input;
        } else {
            formatArray = new Format[]{graphNode.input};
            format = null;
        }
        boolean bl2 = false;
        for (int i = 0; i < formatArray.length; ++i) {
            Vector vector2;
            if (!graphNode.custom && format != null && format.equals(formatArray[i])) continue;
            if (graphNode.plugin != null) {
                if (SimpleGraphBuilder.verifyOutput(graphNode.plugin, formatArray[i]) == null) {
                    if (inspector == null || !inspector.detailMode()) continue;
                    inspector.verifyOutputFailed(graphNode.plugin, formatArray[i]);
                    continue;
                }
                if (inspector != null && !inspector.verify((Codec)graphNode.plugin, graphNode.input, formatArray[i])) continue;
            }
            if ((vector2 = PlugInManager.getPlugInList(formatArray[i], null, 2)) == null || vector2.size() == 0) continue;
            for (int j = 0; j < vector2.size(); ++j) {
                GraphNode graphNode3 = SimpleGraphBuilder.getPlugInNode((String)vector2.elementAt(j), 2, this.plugIns);
                if (graphNode3 == null || graphNode3.checkAttempted(formatArray[i])) continue;
                Format[] formatArray2 = graphNode3.getSupportedInputs();
                Format format2 = SimpleGraphBuilder.matches(formatArray[i], formatArray2, null, graphNode3.plugin);
                if (format2 == null) {
                    if (inspector == null || !inspector.detailMode()) continue;
                    inspector.verifyInputFailed(graphNode3.plugin, formatArray[i]);
                    continue;
                }
                if (inspector != null && inspector.detailMode() && !inspector.verify((Codec)graphNode3.plugin, format2, null)) continue;
                graphNode2 = new GraphNode(graphNode3, format2, graphNode, graphNode.level + 1);
                vector.addElement(graphNode2);
                bl2 = true;
            }
        }
        this.indent = n;
        Log.setIndent(this.indent);
        return null;
    }

    protected GraphNode findTarget(GraphNode graphNode) {
        GraphNode graphNode2;
        Format[] formatArray;
        if (graphNode.plugin == null) {
            formatArray = new Format[]{graphNode.input};
        } else if (graphNode.output != null) {
            formatArray = new Format[]{graphNode.output};
        } else {
            formatArray = graphNode.getSupportedOutputs(graphNode.input);
            if (formatArray == null || formatArray.length == 0) {
                return null;
            }
        }
        if (this.targetPlugins != null && (graphNode2 = this.verifyTargetPlugins(graphNode, formatArray)) != null) {
            return graphNode2;
        }
        return null;
    }

    void removeFailure(Vector vector, GraphNode graphNode, Format format) {
        if (graphNode.plugin == null) {
            return;
        }
        Log.comment("Failed to open plugin " + graphNode.plugin + ". Will re-build the graph allover again");
        vector.removeAllElements();
        GraphNode graphNode2 = new GraphNode(null, null, format, null, 0);
        this.indent = 1;
        Log.setIndent(this.indent);
        vector.addElement(graphNode2);
        graphNode.failed = true;
        this.plugIns.put(graphNode.plugin.getClass().getName(), graphNode);
        Enumeration<String> enumeration = this.plugIns.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            GraphNode graphNode3 = this.plugIns.get(string);
            if (graphNode3.failed) continue;
            this.plugIns.remove(string);
        }
    }

    public void reset() {
        Enumeration<GraphNode> enumeration = this.plugIns.elements();
        while (enumeration.hasMoreElements()) {
            GraphNode graphNode = enumeration.nextElement();
            graphNode.resetAttempted();
        }
    }

    protected boolean setDefaultTargetRenderer(Format format) {
        this.targetPluginNames = format instanceof AudioFormat ? PlugInManager.getPlugInList(new AudioFormat(null, -1.0, -1, -1, -1, -1, -1, -1.0, null), null, 4) : (format instanceof VideoFormat ? PlugInManager.getPlugInList(new VideoFormat(null, null, -1, null, -1.0f), null, 4) : PlugInManager.getPlugInList(null, null, 4));
        if (this.targetPluginNames == null || this.targetPluginNames.size() == 0) {
            return false;
        }
        this.targetPlugins = new GraphNode[this.targetPluginNames.size()];
        this.targetType = 4;
        return true;
    }

    protected boolean setDefaultTargets(Format format) {
        return this.setDefaultTargetRenderer(format);
    }

    protected GraphNode verifyGraph(GraphNode graphNode) {
        Format format = null;
        Vector<PlugIn> vector = new Vector<PlugIn>(5);
        if (graphNode.plugin == null) {
            return null;
        }
        Log.setIndent(this.indent++);
        while (graphNode != null && graphNode.plugin != null) {
            if (vector.contains(graphNode.plugin)) {
                PlugIn plugIn;
                if (graphNode.cname == null || (plugIn = SimpleGraphBuilder.createPlugIn(graphNode.cname, -1)) == null) {
                    Log.write("Failed to instantiate " + graphNode.cname);
                    return graphNode;
                }
                graphNode.plugin = plugIn;
            } else {
                vector.addElement(graphNode.plugin);
            }
            if ((graphNode.type == -1 || graphNode.type == 4) && graphNode.plugin instanceof Renderer) {
                ((Renderer)graphNode.plugin).setInputFormat(graphNode.input);
            } else if ((graphNode.type == -1 || graphNode.type == 2) && graphNode.plugin instanceof Codec) {
                ((Codec)graphNode.plugin).setInputFormat(graphNode.input);
                if (format != null) {
                    ((Codec)graphNode.plugin).setOutputFormat(format);
                } else if (graphNode.output != null) {
                    ((Codec)graphNode.plugin).setOutputFormat(graphNode.output);
                }
            }
            if (graphNode.type != -1 && graphNode.type != 4 || !(graphNode.plugin instanceof Renderer)) {
                try {
                    graphNode.plugin.open();
                }
                catch (Exception exception) {
                    Log.warning("Failed to open: " + graphNode.plugin);
                    graphNode.failed = true;
                    return graphNode;
                }
            }
            format = graphNode.input;
            graphNode = graphNode.prev;
        }
        Log.setIndent(this.indent--);
        return null;
    }

    protected GraphNode verifyTargetPlugins(GraphNode graphNode, Format[] formatArray) {
        for (int i = 0; i < this.targetPlugins.length; ++i) {
            Format format;
            GraphNode graphNode2 = this.targetPlugins[i];
            if (graphNode2 == null) {
                Format[] formatArray2;
                String string = (String)this.targetPluginNames.elementAt(i);
                if (string == null || SimpleGraphBuilder.matches(formatArray, formatArray2 = PlugInManager.getSupportedInputFormats(string, this.targetType), null, null) == null) continue;
                graphNode2 = SimpleGraphBuilder.getPlugInNode(string, this.targetType, this.plugIns);
                if (graphNode2 == null) {
                    this.targetPluginNames.setElementAt(null, i);
                    continue;
                }
                this.targetPlugins[i] = graphNode2;
            }
            if ((format = SimpleGraphBuilder.matches(formatArray, graphNode2.getSupportedInputs(), graphNode.plugin, graphNode2.plugin)) == null || inspector != null && (graphNode.plugin != null && !inspector.verify((Codec)graphNode.plugin, graphNode.input, format) || ((graphNode2.type == -1 || graphNode2.type == 2) && graphNode2.plugin instanceof Codec ? !inspector.verify((Codec)graphNode2.plugin, format, null) : (graphNode2.type == -1 || graphNode2.type == 4) && graphNode2.plugin instanceof Renderer && !inspector.verify((Renderer)graphNode2.plugin, format)))) continue;
            return new GraphNode(graphNode2, format, graphNode, graphNode.level + 1);
        }
        return null;
    }
}

