/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.packets.out._05;

import java.nio.ByteBuffer;
import net.sf.jqql.beans.QQUser;
import net.sf.jqql.packets.PacketParseException;
import net.sf.jqql.packets._05OutPacket;
import org.apache.commons.codec.digest.DigestUtils;

public class TransferPacket
extends _05OutPacket {
    private int sessionId;
    private byte[] md5;
    private int imageLength;
    private String fileName;
    private byte[] fragment;
    private boolean data;
    private boolean last;
    private boolean requestSend;
    private boolean dataReply;

    public TransferPacket(QQUser qQUser, boolean bl, boolean bl2) {
        super('#', bl ? bl2 : true, qQUser);
        this.data = bl;
        this.last = bl2;
        this.requestSend = true;
    }

    public TransferPacket(QQUser qQUser) {
        super('#', false, qQUser);
        this.requestSend = false;
        this.dataReply = false;
    }

    public TransferPacket(ByteBuffer byteBuffer, int n, QQUser qQUser) throws PacketParseException {
        super(byteBuffer, n, qQUser);
    }

    public String getPacketName() {
        return "Transfer _08Packet";
    }

    protected void putBody(ByteBuffer byteBuffer) {
        if (!this.requestSend) {
            byteBuffer.putLong(0x100000000000000L);
            byteBuffer.putInt(this.sessionId);
            byteBuffer.putInt(0);
            if (this.dataReply) {
                byteBuffer.putChar('\u0001');
                byteBuffer.put((byte)2);
            } else {
                byteBuffer.putChar('\u0004');
                byteBuffer.putInt(0);
            }
        } else if (this.data) {
            if (this.last) {
                byteBuffer.putLong(0x100000000000000L);
            } else {
                byteBuffer.putLong(0x100000000000001L);
            }
            byteBuffer.putInt(this.sessionId);
            byteBuffer.putInt(0);
            byteBuffer.putChar((char)this.fragment.length);
            byteBuffer.put(this.fragment);
        } else {
            byteBuffer.putLong(0x100000000000000L);
            byteBuffer.putInt(this.sessionId);
            byteBuffer.putInt(0);
            byteBuffer.putChar('\u0000');
            int n = byteBuffer.position();
            byteBuffer.putChar('\u0000');
            byteBuffer.put(this.md5);
            byte[] byArray = this.fileName.getBytes();
            byteBuffer.put(DigestUtils.md5((byte[])byArray));
            byteBuffer.putInt(this.imageLength);
            byteBuffer.putChar((char)this.fileName.length());
            byteBuffer.put(byArray);
            byteBuffer.putLong(0L);
            char c = (char)(byteBuffer.position() - n);
            byteBuffer.putChar(n - 2, c);
            byteBuffer.putChar(n, c);
        }
    }

    public int getImageLength() {
        return this.imageLength;
    }

    public void setImageLength(int n) {
        this.imageLength = n;
    }

    public byte[] getMd5() {
        return this.md5;
    }

    public void setMd5(byte[] byArray) {
        this.md5 = byArray;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(int n) {
        this.sessionId = n;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public byte[] getFragment() {
        return this.fragment;
    }

    public void setFragment(byte[] byArray) {
        this.fragment = byArray;
    }

    public boolean isRequestSend() {
        return this.requestSend;
    }

    public void setRequestSend(boolean bl) {
        this.requestSend = bl;
    }

    public boolean isDataReply() {
        return this.dataReply;
    }

    public void setDataReply(boolean bl) {
        this.dataReply = bl;
    }
}

