/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.srtp;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.jitsi.impl.neomedia.transform.srtp.OpenSSLDigest;
import org.jitsi.util.JNIUtils;

public class OpenSSLHMAC
implements Mac {
    private static long EVP_sha1;
    private static boolean loadLibrary;
    private final String algorithmName;
    private long ctx;
    private byte[] key;
    private final int macSize;
    private final long md;

    private static native int EVP_MD_size(long var0);

    private static native long EVP_sha1();

    private static native void HMAC_CTX_cleanup(long var0);

    private static native long HMAC_CTX_create();

    private static native void HMAC_CTX_destroy(long var0);

    private static native int HMAC_Final(long var0, byte[] var2, int var3, int var4);

    private static native boolean HMAC_Init_ex(long var0, byte[] var2, int var3, long var4, long var6);

    private static native boolean HMAC_Update(long var0, byte[] var2, int var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenSSLHMAC(int digestAlgorithm) {
        if (digestAlgorithm != 1) {
            throw new IllegalArgumentException("digestAlgorithm " + digestAlgorithm);
        }
        this.algorithmName = "SHA-1/HMAC";
        Class<OpenSSLDigest> clazz = OpenSSLDigest.class;
        synchronized (OpenSSLDigest.class) {
            long EVP_sha1;
            if (loadLibrary) {
                try {
                    JNIUtils.loadLibrary("jnopenssl", OpenSSLHMAC.class.getClassLoader());
                    OpenSSLHMAC.EVP_sha1 = OpenSSLHMAC.EVP_sha1();
                }
                finally {
                    loadLibrary = false;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (digestAlgorithm == 1) {
                EVP_sha1 = OpenSSLHMAC.EVP_sha1;
                if (EVP_sha1 == 0L) {
                    throw new IllegalStateException("EVP_sha1");
                }
            } else {
                throw new IllegalArgumentException("digestAlgorithm " + digestAlgorithm);
            }
            long md = EVP_sha1;
            this.md = md;
            long ctx = OpenSSLHMAC.HMAC_CTX_create();
            if (ctx == 0L) {
                throw new RuntimeException("HMAC_CTX_create");
            }
            boolean ok = false;
            this.ctx = ctx;
            try {
                this.reset();
                this.macSize = OpenSSLHMAC.EVP_MD_size(md);
                ok = true;
            }
            finally {
                if (!ok) {
                    if (this.ctx == ctx) {
                        this.ctx = 0L;
                    }
                    OpenSSLHMAC.HMAC_CTX_destroy(ctx);
                }
            }
            return;
        }
    }

    public int doFinal(byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (out == null) {
            throw new NullPointerException("out");
        }
        if (outOff < 0 || out.length <= outOff) {
            throw new ArrayIndexOutOfBoundsException(outOff);
        }
        int outLen = out.length - outOff;
        int macSize = this.getMacSize();
        if (outLen < macSize) {
            throw new DataLengthException("Space in out must be at least " + macSize + "bytes but is " + outLen + " bytes!");
        }
        long ctx = this.ctx;
        if (ctx == 0L) {
            throw new IllegalStateException("ctx");
        }
        if ((outLen = OpenSSLHMAC.HMAC_Final(ctx, out, outOff, outLen)) < 0) {
            throw new RuntimeException("HMAC_Final");
        }
        this.reset();
        return outLen;
    }

    protected void finalize() throws Throwable {
        try {
            long ctx = this.ctx;
            if (ctx != 0L) {
                this.ctx = 0L;
                OpenSSLHMAC.HMAC_CTX_destroy(ctx);
            }
        }
        finally {
            super.finalize();
        }
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public int getMacSize() {
        return this.macSize;
    }

    public void init(CipherParameters params) throws IllegalArgumentException {
        byte[] key = params instanceof KeyParameter ? ((KeyParameter)params).getKey() : null;
        this.key = key;
        this.reset();
    }

    public void reset() {
        long ctx = this.ctx;
        if (ctx == 0L) {
            throw new IllegalStateException("ctx");
        }
        OpenSSLHMAC.HMAC_CTX_cleanup(ctx);
        if (!OpenSSLHMAC.HMAC_Init_ex(ctx, this.key, this.key == null ? 0 : this.key.length, this.md, 0L)) {
            throw new RuntimeException("HMAC_Init_ex(" + this.getAlgorithmName() + ")");
        }
    }

    public void update(byte in) throws IllegalStateException {
    }

    public void update(byte[] in, int off, int len) throws DataLengthException, IllegalStateException {
        if (len != 0) {
            if (in == null) {
                throw new NullPointerException("in");
            }
            if (off < 0 || in.length <= off) {
                throw new ArrayIndexOutOfBoundsException(off);
            }
            if (len < 0 || in.length < off + len) {
                throw new IllegalArgumentException("len " + len);
            }
            long ctx = this.ctx;
            if (ctx == 0L) {
                throw new IllegalStateException("ctx");
            }
            if (!OpenSSLHMAC.HMAC_Update(ctx, in, off, len)) {
                throw new RuntimeException("HMAC_Update");
            }
        }
    }

    static {
        loadLibrary = true;
    }
}

