/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.video;

import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Effect;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.codec.FFmpeg;
import org.jitsi.impl.neomedia.codec.video.AVFrame;
import org.jitsi.impl.neomedia.codec.video.AVFrameFormat;
import org.jitsi.util.Logger;

public class HFlip
extends AbstractCodec2
implements Effect {
    private static final Logger logger = Logger.getLogger(HFlip.class);
    private static final Format[] SUPPORTED_FORMATS = new Format[]{new AVFrameFormat()};
    private static final String VSINK_FFSINK_NAME = "nullsink";
    private static final String VSRC_BUFFER_NAME = "buffer";
    private long buffer;
    private long ffsink;
    private long graph = 0L;
    private boolean graphIsPending = true;
    private int height;
    private long outputFilterBufferRef;
    private long outputFrame;
    private int pixFmt = -1;
    private int width;

    public HFlip() {
        super("FFmpeg HFlip Filter", AVFrameFormat.class, SUPPORTED_FORMATS);
    }

    @Override
    protected synchronized void doClose() {
        try {
            if (this.outputFrame != 0L) {
                FFmpeg.avcodec_free_frame(this.outputFrame);
                this.outputFrame = 0L;
            }
        }
        finally {
            this.reset();
        }
    }

    @Override
    protected synchronized void doOpen() throws ResourceUnavailableException {
        this.outputFrame = FFmpeg.avcodec_alloc_frame();
        if (this.outputFrame == 0L) {
            String reason = "avcodec_alloc_frame: " + this.outputFrame;
            logger.error(reason);
            throw new ResourceUnavailableException(reason);
        }
    }

    @Override
    protected synchronized int doProcess(Buffer inputBuffer, Buffer outputBuffer) {
        if (this.outputFilterBufferRef != 0L) {
            FFmpeg.avfilter_unref_buffer(this.outputFilterBufferRef);
            this.outputFilterBufferRef = 0L;
        }
        AVFrameFormat format = (AVFrameFormat)inputBuffer.getFormat();
        Dimension size = format.getSize();
        int pixFmt = format.getPixFmt();
        if (this.width != size.width || this.height != size.height || this.pixFmt != pixFmt) {
            this.reset();
        }
        if (this.graph == 0L) {
            String errorReason = null;
            int error = 0;
            long buffer = 0L;
            long ffsink = 0L;
            if (this.graphIsPending) {
                this.graphIsPending = false;
                this.graph = FFmpeg.avfilter_graph_alloc();
                if (this.graph == 0L) {
                    errorReason = "avfilter_graph_alloc";
                } else {
                    long log_ctx;
                    String filters = "buffer=" + size.width + ":" + size.height + ":" + pixFmt + ":1:1000000:1:1,hflip," + VSINK_FFSINK_NAME;
                    error = FFmpeg.avfilter_graph_parse(this.graph, filters, 0L, 0L, log_ctx = 0L);
                    if (error == 0) {
                        String parsedFilterNameFormat = "Parsed_%2$s_%1$d";
                        String parsedFilterName = String.format(parsedFilterNameFormat, 0, VSRC_BUFFER_NAME);
                        buffer = FFmpeg.avfilter_graph_get_filter(this.graph, parsedFilterName);
                        if (buffer == 0L) {
                            errorReason = "avfilter_graph_get_filter: buffer/" + parsedFilterName;
                        } else {
                            parsedFilterName = String.format(parsedFilterNameFormat, 2, VSINK_FFSINK_NAME);
                            ffsink = FFmpeg.avfilter_graph_get_filter(this.graph, parsedFilterName);
                            if (ffsink == 0L) {
                                errorReason = "avfilter_graph_get_filter: nullsink/" + parsedFilterName;
                            } else {
                                error = FFmpeg.avfilter_graph_config(this.graph, log_ctx);
                                if (error != 0) {
                                    errorReason = "avfilter_graph_config";
                                }
                            }
                        }
                    } else {
                        errorReason = "avfilter_graph_parse";
                    }
                    if (errorReason != null || error != 0) {
                        FFmpeg.avfilter_graph_free(this.graph);
                        this.graph = 0L;
                    }
                }
            }
            if (this.graph == 0L) {
                if (errorReason != null) {
                    StringBuilder msg = new StringBuilder(errorReason);
                    if (error != 0) {
                        msg.append(": ").append(error);
                    }
                    msg.append(", format ").append(format);
                    logger.error(msg);
                }
                return 1;
            }
            this.width = size.width;
            this.height = size.height;
            this.pixFmt = pixFmt;
            this.buffer = buffer;
            this.ffsink = ffsink;
        }
        long inputFrame = ((AVFrame)inputBuffer.getData()).getPtr();
        this.outputFilterBufferRef = FFmpeg.get_filtered_video_frame(inputFrame, this.width, this.height, this.pixFmt, this.buffer, this.ffsink, this.outputFrame);
        if (this.outputFilterBufferRef == 0L) {
            if (logger.isDebugEnabled()) {
                logger.debug("get_filtered_video_frame");
            }
            return 1;
        }
        Object out = outputBuffer.getData();
        if (!(out instanceof AVFrame) || ((AVFrame)out).getPtr() != this.outputFrame) {
            outputBuffer.setData(new AVFrame(this.outputFrame));
        }
        outputBuffer.setDiscard(inputBuffer.isDiscard());
        outputBuffer.setDuration(inputBuffer.getDuration());
        outputBuffer.setEOM(inputBuffer.isEOM());
        outputBuffer.setFlags(inputBuffer.getFlags());
        outputBuffer.setFormat(format);
        outputBuffer.setHeader(inputBuffer.getHeader());
        outputBuffer.setLength(inputBuffer.getLength());
        outputBuffer.setSequenceNumber(inputBuffer.getSequenceNumber());
        outputBuffer.setTimeStamp(inputBuffer.getTimeStamp());
        return 0;
    }

    @Override
    public synchronized void reset() {
        if (this.outputFilterBufferRef != 0L) {
            FFmpeg.avfilter_unref_buffer(this.outputFilterBufferRef);
            this.outputFilterBufferRef = 0L;
        }
        if (this.graph != 0L) {
            FFmpeg.avfilter_graph_free(this.graph);
            this.graph = 0L;
            this.graphIsPending = true;
            this.width = 0;
            this.height = 0;
            this.pixFmt = -1;
            this.buffer = 0L;
            this.ffsink = 0L;
        }
    }
}

