/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import javax.media.Buffer;
import javax.media.control.BufferControl;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.rtp.JitterBuffer;
import net.sf.fmj.media.rtp.JitterBufferBehaviour;
import net.sf.fmj.media.rtp.JitterBufferStats;
import net.sf.fmj.media.rtp.RTPRawReceiver;
import net.sf.fmj.media.rtp.RTPSourceStream;

class BasicJitterBufferBehaviour
implements JitterBufferBehaviour {
    protected final JitterBuffer q;
    private int recvBufSize;
    protected final JitterBufferStats stats;
    protected final RTPSourceStream stream;

    protected BasicJitterBufferBehaviour(RTPSourceStream stream) {
        this.stream = stream;
        this.q = this.stream.q;
        this.stats = this.stream.stats;
    }

    protected void dropFirstPkt() {
        this.q.dropFirstFill();
    }

    public void dropPkt() {
        this.dropFirstPkt();
    }

    public int getAbsoluteMaximumDelay() {
        return this.getMaximumDelay();
    }

    protected BufferControl getBufferControl() {
        return this.stream.getBufferControl();
    }

    public int getMaximumDelay() {
        return 65535;
    }

    public int getNominalDelay() {
        return 0;
    }

    protected void grow(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("capacity");
        }
        int qCapacity = this.q.getCapacity();
        if (capacity == qCapacity) {
            return;
        }
        if (capacity < qCapacity) {
            throw new IllegalArgumentException("capacity");
        }
        Log.info("Growing packet queue to " + capacity);
        this.stats.incrementNbGrow();
        this.q.setCapacity(capacity);
    }

    public boolean isAdaptive() {
        return false;
    }

    protected int monitorQSize(Buffer buffer) {
        return 0;
    }

    public boolean preAdd(Buffer buffer, RTPRawReceiver rtprawreceiver) {
        this.stats.updateSizePerPacket(buffer);
        int aprxBufferLengthInPkts = this.monitorQSize(buffer);
        if (aprxBufferLengthInPkts > 0) {
            this.setRecvBufSize(rtprawreceiver, aprxBufferLengthInPkts);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Buffer buffer) {
        if (this.q.getFillCount() == 0) {
            buffer.setDiscard(true);
        } else {
            Buffer bufferFromQueue = this.q.getFill();
            try {
                Object bufferData = buffer.getData();
                Object bufferHeader = buffer.getHeader();
                buffer.copy(bufferFromQueue);
                bufferFromQueue.setData(bufferData);
                bufferFromQueue.setHeader(bufferHeader);
            }
            finally {
                this.q.returnFree(bufferFromQueue);
            }
        }
    }

    public void reset() {
    }

    protected void setRecvBufSize(RTPRawReceiver rtprawreceiver, int aprxBufferLengthInPkts) {
        int sizePerPkt = this.stats.getSizePerPacket();
        int aprxThresholdInBytes = aprxBufferLengthInPkts * sizePerPkt / 2;
        if (rtprawreceiver != null && aprxThresholdInBytes > this.recvBufSize) {
            rtprawreceiver.setRecvBufSize(aprxThresholdInBytes);
            int recvBufSize = rtprawreceiver.getRecvBufSize();
            this.recvBufSize = recvBufSize < aprxThresholdInBytes ? Integer.MAX_VALUE : aprxThresholdInBytes;
            Log.comment("RTP socket receive buffer size: " + recvBufSize + " bytes.\n");
        }
    }

    public boolean willReadBlock() {
        return this.q.noMoreFill();
    }
}

