/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.util;

public class MediaThread
extends Thread {
    private static ThreadGroup threadGroup;
    static boolean securityPrivilege;
    private static final boolean debug = false;
    private static int controlPriority;
    private static int audioPriority;
    private static int videoPriority;
    private static int networkPriority;
    private static int videoNetworkPriority;
    private static int defaultMaxPriority;
    private String androidThreadPriority;

    public static int getAudioPriority() {
        return audioPriority;
    }

    public static int getControlPriority() {
        return controlPriority;
    }

    public static int getNetworkPriority() {
        return networkPriority;
    }

    private static ThreadGroup getRootThreadGroup() {
        ThreadGroup threadGroup = null;
        try {
            ThreadGroup threadGroup2 = threadGroup = Thread.currentThread().getThreadGroup();
            while (threadGroup2.getParent() != null) {
                threadGroup2 = threadGroup2.getParent();
            }
            return threadGroup2;
        }
        catch (Exception exception) {
            return null;
        }
        catch (Error error) {
            return null;
        }
    }

    public static int getVideoNetworkPriority() {
        return videoNetworkPriority;
    }

    public static int getVideoPriority() {
        return videoPriority;
    }

    public MediaThread() {
        this("FMJ Thread");
    }

    public MediaThread(Runnable runnable) {
        this(runnable, "FMJ Thread");
    }

    public MediaThread(Runnable runnable, String string) {
        super(threadGroup, runnable, string);
    }

    public MediaThread(String string) {
        super(threadGroup, string);
    }

    private void checkPriority(String string, int n, boolean bl, int n2) {
        if (n != n2) {
            System.out.println("MediaThread: " + string + " privilege? " + bl + "  ask pri: " + n + " got pri:  " + n2);
        }
    }

    public void run() {
        block7: {
            if (this.androidThreadPriority != null) {
                try {
                    String string;
                    String string2 = System.getProperty("os.name");
                    if (string2 != null && string2.startsWith("Linux") && (string = System.getProperty("java.vm.name")) != null && string.equalsIgnoreCase("Dalvik")) {
                        Class<?> clazz = Class.forName("android.os.Process");
                        int n = clazz.getField(this.androidThreadPriority).getInt(null);
                        clazz.getMethod("setThreadPriority", Integer.class).invoke(null, n);
                        int n2 = 10 - Math.round((float)(n + 20) / 40.0f * 10.0f);
                        if (n2 < 1) {
                            n2 = 1;
                        } else if (n2 > 10) {
                            n2 = 10;
                        }
                        this.setPriority(n2);
                    }
                }
                catch (Throwable throwable) {
                    if (!(throwable instanceof ThreadDeath)) break block7;
                    throw (ThreadDeath)throwable;
                }
            }
        }
        super.run();
    }

    private void useAndroidThreadPriority(String string) {
        this.androidThreadPriority = string;
    }

    public void useAudioPriority() {
        this.usePriority(audioPriority);
        this.useAndroidThreadPriority("THREAD_PRIORITY_URGENT_AUDIO");
    }

    public void useControlPriority() {
        this.usePriority(controlPriority);
    }

    public void useNetworkPriority() {
        this.usePriority(networkPriority);
    }

    private void usePriority(int n) {
        try {
            this.setPriority(n);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void useVideoNetworkPriority() {
        this.usePriority(videoNetworkPriority);
    }

    public void useVideoPriority() {
        this.usePriority(videoPriority);
        this.useAndroidThreadPriority("THREAD_PRIORITY_URGENT_DISPLAY");
    }

    static {
        securityPrivilege = true;
        controlPriority = 9;
        audioPriority = 5;
        videoPriority = 3;
        networkPriority = audioPriority + 1;
        videoNetworkPriority = networkPriority - 1;
        defaultMaxPriority = 4;
        try {
            defaultMaxPriority = Thread.currentThread().getPriority();
            defaultMaxPriority = Thread.currentThread().getThreadGroup().getMaxPriority();
        }
        catch (Throwable throwable) {
            securityPrivilege = false;
            controlPriority = defaultMaxPriority;
            audioPriority = defaultMaxPriority;
            videoPriority = defaultMaxPriority - 1;
            networkPriority = defaultMaxPriority;
            videoNetworkPriority = defaultMaxPriority;
        }
        threadGroup = securityPrivilege ? MediaThread.getRootThreadGroup() : null;
    }
}

