/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.audio.alaw;

import com.lti.utils.UnsignedUtils;

public class ALawEncoderUtil {
    public static final int MAX = Short.MAX_VALUE;
    private static byte[] pcmToALawMap = new byte[65536];

    public static void aLawEncode(boolean bl, byte[] byArray, int n, int n2, byte[] byArray2) {
        if (bl) {
            ALawEncoderUtil.aLawEncodeBigEndian(byArray, n, n2, byArray2);
        } else {
            ALawEncoderUtil.aLawEncodeLittleEndian(byArray, n, n2, byArray2);
        }
    }

    public static byte aLawEncode(int n) {
        return pcmToALawMap[UnsignedUtils.uShortToInt((short)(n & 0xFFFF))];
    }

    public static byte aLawEncode(short s) {
        return pcmToALawMap[UnsignedUtils.uShortToInt(s)];
    }

    public static void aLawEncodeBigEndian(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3 = n2 / 2;
        for (int i = 0; i < n3; ++i) {
            byArray2[i] = ALawEncoderUtil.aLawEncode(byArray[n + 2 * i + 1] & 0xFF | (byArray[n + 2 * i] & 0xFF) << 8);
        }
    }

    public static void aLawEncodeLittleEndian(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3 = n2 / 2;
        for (int i = 0; i < n3; ++i) {
            byArray2[i] = ALawEncoderUtil.aLawEncode((byArray[n + 2 * i + 1] & 0xFF) << 8 | byArray[n + 2 * i] & 0xFF);
        }
    }

    private static byte encode(int n) {
        int n2 = (n & 0x8000) >> 8;
        if (n2 != 0) {
            n = -n;
        }
        if (n > Short.MAX_VALUE) {
            n = Short.MAX_VALUE;
        }
        int n3 = 7;
        int n4 = 16384;
        while ((n & n4) == 0 && n3 > 0) {
            --n3;
            n4 >>= 1;
        }
        n4 = n >> (n3 == 0 ? 4 : n3 + 3) & 0xF;
        byte by = (byte)(n2 | n3 << 4 | n4);
        return (byte)(by ^ 0xD5);
    }

    static {
        for (int i = Short.MIN_VALUE; i <= Short.MAX_VALUE; ++i) {
            ALawEncoderUtil.pcmToALawMap[UnsignedUtils.uShortToInt((short)((short)i))] = ALawEncoderUtil.encode(i);
        }
    }
}

