/*
 * Decompiled with CFR 0.152.
 */
package com.lti.utils;

import com.lti.utils.UnsignedUtils;
import net.iharder.Base64;

public final class StringUtils {
    private static final int MAX_STANDARD_ASCII = 255;
    private static final int RADIX_16 = 16;

    public static String byteArrayToBase64String(byte[] byArray) {
        return Base64.encodeBytes(byArray);
    }

    public static String byteArrayToHexString(byte[] byArray) {
        return StringUtils.byteArrayToHexString(byArray, byArray.length);
    }

    public static String byteArrayToHexString(byte[] byArray, int n) {
        return StringUtils.byteArrayToHexString(byArray, n, 0);
    }

    public static String byteArrayToHexString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            String string = Integer.toHexString(UnsignedUtils.uByteToInt(byArray[n2 + i]));
            if (string.length() == 1) {
                string = "0" + string;
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String byteToHexString_ZeroPad(byte by) {
        String string = Integer.toHexString(UnsignedUtils.uByteToInt(by));
        if (string.length() == 1) {
            string = "0" + string;
        }
        return string;
    }

    public static String dump(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 32;
        while (n < n2) {
            int n4;
            int n5 = 0;
            if (n + n3 > n2) {
                n3 = n2 - n;
                n5 = 32 - n3;
            }
            stringBuffer.append(StringUtils.byteArrayToHexString(byArray, n3, n));
            for (n4 = 0; n4 < n5; ++n4) {
                stringBuffer.append("  ");
            }
            stringBuffer.append(" | ");
            for (n4 = 0; n4 < n3; ++n4) {
                byte by = byArray[n + n4];
                if (by >= 32 && by <= 126) {
                    stringBuffer.append((char)by);
                    continue;
                }
                stringBuffer.append('.');
            }
            stringBuffer.append('\n');
            n += n3;
        }
        return stringBuffer.toString();
    }

    public static byte hexStringToByte(String string) {
        return (byte)Integer.parseInt(string, 16);
    }

    public static byte[] hexStringToByteArray(String string) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = StringUtils.hexStringToByte(string.substring(i * 2, i * 2 + 2));
        }
        return byArray;
    }

    public static String replaceSpecialUrlChars(String string) {
        return StringUtils.replaceSpecialUrlChars(string, false);
    }

    public static String replaceSpecialUrlChars(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.' || c == '-' || c == '_' || c == '~' || bl && (c == '/' || c == ':' || c == '\\')) {
                stringBuffer.append(c);
                continue;
            }
            if (i > 255) {
                throw new IllegalArgumentException();
            }
            stringBuffer.append('%');
            stringBuffer.append(StringUtils.byteToHexString_ZeroPad((byte)c));
        }
        return stringBuffer.toString();
    }

    public static String replaceSpecialXMLChars(String string) {
        return StringUtils.replaceSpecialXMLChars_Core(string, true);
    }

    private static String replaceSpecialXMLChars_Core(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '&') {
                stringBuilder.append("&amp;");
                continue;
            }
            if (c == '<') {
                stringBuilder.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuilder.append("&gt;");
                continue;
            }
            if (c == '\"') {
                stringBuilder.append("&quot;");
                continue;
            }
            if (bl && c == '\'') {
                stringBuilder.append("&apos;");
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String restoreSpecialURLChars(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!bl) {
                if (c == '%') {
                    bl = true;
                    stringBuffer2 = new StringBuffer();
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer2.append(c);
            if (stringBuffer2.length() == 2) {
                String string2 = stringBuffer2.toString();
                int n = Integer.parseInt(string2, 16);
                stringBuffer.append((char)n);
                bl = false;
                continue;
            }
            if (stringBuffer2.length() != 1 || stringBuffer2.charAt(0) != '%') continue;
            stringBuffer.append('%');
            bl = false;
        }
        if (bl) {
            stringBuffer.append("&" + stringBuffer2.toString());
        }
        return stringBuffer.toString();
    }

    public static String restoreSpecialXMLChars(String string) {
        return StringUtils.restoreSpecialXMLChars_Core(string, true);
    }

    private static String restoreSpecialXMLChars_Core(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl2 = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!bl2) {
                if (c == '&') {
                    bl2 = true;
                    stringBuilder2 = new StringBuilder();
                    continue;
                }
                stringBuilder.append(c);
                continue;
            }
            if (c == ';') {
                String string2 = stringBuilder2.toString();
                if (string2.equals("amp")) {
                    stringBuilder.append('&');
                } else if (string2.equals("lt")) {
                    stringBuilder.append('<');
                } else if (string2.equals("gt")) {
                    stringBuilder.append('>');
                } else if (string2.equals("quot")) {
                    stringBuilder.append('\"');
                } else if (bl & string2.equals("apos")) {
                    stringBuilder.append('\'');
                } else {
                    stringBuilder.append("&" + string2 + ';');
                }
                bl2 = false;
                continue;
            }
            stringBuilder2.append(c);
        }
        if (bl2) {
            stringBuilder.append("&" + stringBuilder2.toString());
        }
        return stringBuilder.toString();
    }
}

