/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.RTPPushDataSource;
import javax.media.rtp.SessionAddress;
import net.sf.fmj.media.rtp.OverallStats;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.RTCPPacketParser;
import net.sf.fmj.media.rtp.RTCPPacketParserListener;
import net.sf.fmj.media.rtp.RTCPSRPacket;
import net.sf.fmj.media.rtp.StreamSynch;
import net.sf.fmj.media.rtp.util.BadFormatException;
import net.sf.fmj.media.rtp.util.Packet;
import net.sf.fmj.media.rtp.util.PacketFilter;
import net.sf.fmj.media.rtp.util.RTPPacketReceiver;
import net.sf.fmj.media.rtp.util.UDPPacketReceiver;

public class RTCPRawReceiver
extends PacketFilter
implements RTCPPacketParserListener {
    public DatagramSocket socket;
    private StreamSynch streamSynch;
    private OverallStats stats = null;
    private RTCPPacketParser parser;

    public RTCPRawReceiver() {
    }

    public RTCPRawReceiver(DatagramSocket datagramSocket, OverallStats overallStats, StreamSynch streamSynch) {
        this.setSource(new UDPPacketReceiver(datagramSocket, 1000));
        this.stats = overallStats;
        this.streamSynch = streamSynch;
    }

    public RTCPRawReceiver(int n, String string, OverallStats overallStats, StreamSynch streamSynch) throws UnknownHostException, IOException, SocketException {
        this.streamSynch = streamSynch;
        this.stats = overallStats;
        UDPPacketReceiver uDPPacketReceiver = new UDPPacketReceiver(n, string, -1, null, 1000, null);
        this.setSource(uDPPacketReceiver);
        this.socket = uDPPacketReceiver.getSocket();
    }

    public RTCPRawReceiver(RTPConnector rTPConnector, OverallStats overallStats, StreamSynch streamSynch) {
        this.streamSynch = streamSynch;
        try {
            this.setSource(new RTPPacketReceiver(rTPConnector.getControlInputStream()));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.stats = overallStats;
    }

    public RTCPRawReceiver(RTPPushDataSource rTPPushDataSource, OverallStats overallStats, StreamSynch streamSynch) {
        this.streamSynch = streamSynch;
        this.setSource(new RTPPacketReceiver(rTPPushDataSource));
        this.stats = overallStats;
    }

    public RTCPRawReceiver(SessionAddress sessionAddress, SessionAddress sessionAddress2, OverallStats overallStats, StreamSynch streamSynch, DatagramSocket datagramSocket) throws UnknownHostException, IOException, SocketException {
        this.streamSynch = streamSynch;
        this.stats = overallStats;
        UDPPacketReceiver uDPPacketReceiver = new UDPPacketReceiver(sessionAddress.getControlPort(), sessionAddress.getControlHostAddress(), sessionAddress2.getControlPort(), sessionAddress2.getControlHostAddress(), 1000, datagramSocket);
        this.setSource(uDPPacketReceiver);
        this.socket = uDPPacketReceiver.getSocket();
    }

    public void close() {
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.getSource() instanceof RTPPacketReceiver) {
            this.getSource().closeSource();
        }
    }

    public String filtername() {
        return "RTCP Raw Receiver";
    }

    public Packet handlePacket(Packet packet) {
        RTCPPacket rTCPPacket;
        this.stats.update(0, 1);
        this.stats.update(11, 1);
        this.stats.update(1, packet.length);
        if (this.parser == null) {
            this.parser = new RTCPPacketParser();
            this.parser.addRTCPPacketParserListener(this);
        }
        try {
            rTCPPacket = this.parser.parse(packet);
        }
        catch (BadFormatException badFormatException) {
            this.stats.update(13, 1);
            return null;
        }
        return rTCPPacket;
    }

    public Packet handlePacket(Packet packet, int n) {
        return null;
    }

    public Packet handlePacket(Packet packet, SessionAddress sessionAddress) {
        return null;
    }

    public Packet handlePacket(Packet packet, SessionAddress sessionAddress, boolean bl) {
        return null;
    }

    public void enterSenderReport() {
        this.stats.update(12, 1);
    }

    public void malformedSenderReport() {
        this.stats.update(18, 1);
    }

    public void malformedReceiverReport() {
        this.stats.update(15, 1);
    }

    public void malformedSourceDescription() {
        this.stats.update(16, 1);
    }

    public void malformedEndOfParticipation() {
        this.stats.update(17, 1);
    }

    public void uknownPayloadType() {
        this.stats.update(14, 1);
    }

    public void visitSendeReport(RTCPSRPacket rTCPSRPacket) {
        this.streamSynch.update(rTCPSRPacket.ssrc, rTCPSRPacket.rtptimestamp, rTCPSRPacket.ntptimestampmsw, rTCPSRPacket.ntptimestamplsw);
    }
}

