/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.cdp.javasound;

import java.util.logging.Logger;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;
import net.sf.fmj.media.protocol.javasound.DataSource;
import net.sf.fmj.utility.LoggerSingleton;

public class CaptureDevicePlugger {
    private static final Logger logger = LoggerSingleton.logger;

    public void addCaptureDevices() {
        int n = 0;
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            Mixer mixer = AudioSystem.getMixer(infoArray[i]);
            Format[] formatArray = DataSource.querySupportedFormats(i);
            if (null == formatArray || formatArray.length <= 0) continue;
            CaptureDeviceInfo captureDeviceInfo = new CaptureDeviceInfo("javasound:" + infoArray[i].getName() + ":" + n, new MediaLocator("javasound:#" + i), formatArray);
            ++n;
            if (CaptureDeviceManager.getDevice(captureDeviceInfo.getName()) == null) {
                CaptureDeviceManager.addDevice(captureDeviceInfo);
                logger.fine("CaptureDevicePlugger: Added " + captureDeviceInfo.getLocator());
                continue;
            }
            logger.fine("CaptureDevicePlugger: Already present, skipping " + captureDeviceInfo.getLocator());
        }
    }
}

