/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.media;

import com.lti.utils.synchronization.CloseableThread;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import net.sf.fmj.utility.LoggerSingleton;

public class ControllerEventQueue
extends CloseableThread {
    private static final Logger logger = LoggerSingleton.logger;
    Vector eventQueue = new Vector();
    Vector listeners;

    public ControllerEventQueue(Vector vector, String string) {
        this.setName(string);
        this.listeners = vector;
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvent(ControllerEvent controllerEvent) {
        Vector vector;
        Vector vector2 = this.listeners;
        synchronized (vector2) {
            vector = (Vector)this.listeners.clone();
        }
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (!(e instanceof ControllerListener)) continue;
            ControllerListener controllerListener = (ControllerListener)e;
            try {
                controllerListener.controllerUpdate(controllerEvent);
                continue;
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Exception occurred during event dispatching:" + exception, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitorEvents() throws InterruptedException {
        while (!this.isClosing()) {
            Vector vector;
            ControllerEventQueue controllerEventQueue = this;
            synchronized (controllerEventQueue) {
                while (this.eventQueue.size() == 0) {
                    this.wait();
                }
                vector = (Vector)this.eventQueue.clone();
                this.eventQueue.removeAllElements();
            }
            for (int i = 0; i < vector.size(); ++i) {
                ControllerEvent controllerEvent = (ControllerEvent)vector.elementAt(i);
                this.dispatchEvent(controllerEvent);
            }
        }
    }

    public synchronized void postEvent(ControllerEvent controllerEvent) {
        this.eventQueue.addElement(controllerEvent);
        this.notify();
    }

    public void run() {
        try {
            this.monitorEvents();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setClosed();
    }
}

