/*
 * Decompiled with CFR 0.152.
 */
package javax.media;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Format;
import net.sf.fmj.utility.LoggerSingleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlugInManager {
    private static final Logger logger = LoggerSingleton.logger;
    public static final int DEMULTIPLEXER = 1;
    public static final int CODEC = 2;
    public static final int EFFECT = 3;
    public static final int RENDERER = 4;
    public static final int MULTIPLEXER = 5;
    private static Class<?> implClass;
    private static Method getPlugInListMethod;
    private static Method setPlugInListMethod;
    private static Method commitMethod;
    private static Method addPlugInMethod;
    private static Method removePlugInMethod;
    private static Method getSupportedInputFormatsMethod;
    private static Method getSupportedOutputFormatsMethod;

    public static boolean addPlugIn(String string, Format[] formatArray, Format[] formatArray2, int n) {
        if (!PlugInManager.init()) {
            return false;
        }
        return (Boolean)PlugInManager.callImpl(addPlugInMethod, new Object[]{string, formatArray, formatArray2, n});
    }

    private static Object callImpl(Method method, Object[] objectArray) {
        try {
            return method.invoke(null, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.log(Level.WARNING, "" + illegalArgumentException, illegalArgumentException);
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.log(Level.WARNING, "" + illegalAccessException, illegalAccessException);
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.log(Level.WARNING, "" + invocationTargetException, invocationTargetException);
            return null;
        }
    }

    public static void commit() throws IOException {
        if (!PlugInManager.init()) {
            return;
        }
        PlugInManager.callImpl(commitMethod, new Object[0]);
    }

    public static Vector getPlugInList(Format format, Format format2, int n) {
        if (!PlugInManager.init()) {
            return null;
        }
        return (Vector)PlugInManager.callImpl(getPlugInListMethod, new Object[]{format, format2, n});
    }

    private static Method getStaticMethodOnImplClass(String string, Class<?>[] classArray, Class<?> clazz) throws Exception {
        Method method = implClass.getMethod(string, classArray);
        if (method.getReturnType() != clazz) {
            throw new Exception("Expected return type of method " + string + " to be " + clazz + ", was " + method.getReturnType());
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new Exception("Expected method " + string + " to be static");
        }
        return method;
    }

    public static Format[] getSupportedInputFormats(String string, int n) {
        if (!PlugInManager.init()) {
            return null;
        }
        return (Format[])PlugInManager.callImpl(getSupportedInputFormatsMethod, new Object[]{string, n});
    }

    public static Format[] getSupportedOutputFormats(String string, int n) {
        if (!PlugInManager.init()) {
            return null;
        }
        return (Format[])PlugInManager.callImpl(getSupportedOutputFormatsMethod, new Object[]{string, n});
    }

    private static synchronized boolean init() {
        if (implClass != null) {
            return true;
        }
        try {
            implClass = Class.forName("javax.media.pim.PlugInManager");
            if (!PlugInManager.class.isAssignableFrom(implClass)) {
                throw new Exception("javax.media.pim.PlugInManager not subclass of " + PlugInManager.class.getName());
            }
            getPlugInListMethod = PlugInManager.getStaticMethodOnImplClass("getPlugInList", new Class[]{Format.class, Format.class, Integer.TYPE}, Vector.class);
            setPlugInListMethod = PlugInManager.getStaticMethodOnImplClass("setPlugInList", new Class[]{Vector.class, Integer.TYPE}, Void.TYPE);
            commitMethod = PlugInManager.getStaticMethodOnImplClass("commit", new Class[0], Void.TYPE);
            addPlugInMethod = PlugInManager.getStaticMethodOnImplClass("addPlugIn", new Class[]{String.class, Format[].class, Format[].class, Integer.TYPE}, Boolean.TYPE);
            removePlugInMethod = PlugInManager.getStaticMethodOnImplClass("removePlugIn", new Class[]{String.class, Integer.TYPE}, Boolean.TYPE);
            getSupportedInputFormatsMethod = PlugInManager.getStaticMethodOnImplClass("getSupportedInputFormats", new Class[]{String.class, Integer.TYPE}, Format[].class);
            getSupportedOutputFormatsMethod = PlugInManager.getStaticMethodOnImplClass("getSupportedOutputFormats", new Class[]{String.class, Integer.TYPE}, Format[].class);
        }
        catch (Throwable throwable) {
            implClass = null;
            logger.log(Level.SEVERE, "Unable to initialize javax.media.pim.PlugInManager: " + throwable, throwable);
            return false;
        }
        return true;
    }

    public static boolean removePlugIn(String string, int n) {
        if (!PlugInManager.init()) {
            return false;
        }
        return (Boolean)PlugInManager.callImpl(removePlugInMethod, new Object[]{string, n});
    }

    public static void setPlugInList(Vector vector, int n) {
        if (!PlugInManager.init()) {
            return;
        }
        PlugInManager.callImpl(setPlugInListMethod, new Object[]{vector, n});
    }
}

