/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.address;

import gov.nist.javax.sip.address.NetObject;

public final class UserInfo
extends NetObject {
    private static final long serialVersionUID = 7268593273924256144L;
    protected String user;
    protected String password;
    protected int userType;
    public static final int TELEPHONE_SUBSCRIBER = 1;
    public static final int USER = 2;

    public boolean equals(Object object) {
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UserInfo userInfo = (UserInfo)object;
        if (this.userType != userInfo.userType) {
            return false;
        }
        if (!this.user.equalsIgnoreCase(userInfo.user)) {
            return false;
        }
        if (this.password != null && userInfo.password == null) {
            return false;
        }
        if (userInfo.password != null && this.password == null) {
            return false;
        }
        if (this.password == userInfo.password) {
            return true;
        }
        return this.password.equals(userInfo.password);
    }

    public String encode() {
        if (this.password != null) {
            return this.user + ":" + this.password;
        }
        return this.user;
    }

    public void clearPassword() {
        this.password = null;
    }

    public int getUserType() {
        return this.userType;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUser(String string) {
        this.user = string;
        if (string != null && (string.indexOf("#") >= 0 || string.indexOf(";") >= 0)) {
            this.setUserType(1);
        } else {
            this.setUserType(2);
        }
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setUserType(int n) throws IllegalArgumentException {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("Parameter not in range");
        }
        this.userType = n;
    }
}

