/*
 * Decompiled with CFR 0.152.
 */
package ymsg.support;

import java.awt.Color;
import java.awt.Font;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import ymsg.support.MessageElement;

public class MutableMessageElement
extends MessageElement
implements List {
    private static IllegalStateException wrongType = new IllegalStateException("Incorrect element type for operation");
    private static String esc = "\u001b[";
    private static String boldOn = esc + "1m";
    private static String boldOff = esc + "x1m";
    private static String italicOn = esc + "2m";
    private static String italicOff = esc + "x2m";
    private static String underlineOn = esc + "4m";
    private static String underlineOff = esc + "x4m";
    protected int idxColour;
    protected String namedColour;
    private boolean container = true;

    private MutableMessageElement(int n) {
        super(null, n);
    }

    private MutableMessageElement(int n, boolean bl) {
        this(n);
        this.container = bl;
    }

    public static MutableMessageElement createRoot() {
        return new MutableMessageElement(-1);
    }

    public static MutableMessageElement createText(String string) {
        MutableMessageElement mutableMessageElement = new MutableMessageElement(0, false);
        mutableMessageElement.setText(string);
        return mutableMessageElement;
    }

    public static MutableMessageElement createBold() {
        return new MutableMessageElement(1);
    }

    public static MutableMessageElement createItalic() {
        return new MutableMessageElement(2);
    }

    public static MutableMessageElement createIndexedColour(int n) {
        MutableMessageElement mutableMessageElement = new MutableMessageElement(3, false);
        mutableMessageElement.setIndexedColour(n);
        return mutableMessageElement;
    }

    public static MutableMessageElement createNamedColour(String string) {
        MutableMessageElement mutableMessageElement = new MutableMessageElement(9, false);
        mutableMessageElement.setNamedColour(string);
        return mutableMessageElement;
    }

    public static MutableMessageElement createAbsoluteColour(Color color) {
        MutableMessageElement mutableMessageElement = new MutableMessageElement(8, false);
        mutableMessageElement.setAbsoluteColour(color);
        return mutableMessageElement;
    }

    public static MutableMessageElement createUnderline() {
        return new MutableMessageElement(4);
    }

    public static MutableMessageElement createFont(Font font) {
        MutableMessageElement mutableMessageElement = new MutableMessageElement(5);
        mutableMessageElement.setFont(font);
        return mutableMessageElement;
    }

    public static MutableMessageElement createFade(Color[] colorArray) {
        MutableMessageElement mutableMessageElement = new MutableMessageElement(6);
        mutableMessageElement.setTransition(colorArray);
        return mutableMessageElement;
    }

    public static MutableMessageElement createAlt(Color[] colorArray) {
        MutableMessageElement mutableMessageElement = new MutableMessageElement(7);
        mutableMessageElement.setTransition(colorArray);
        return mutableMessageElement;
    }

    public int getType() {
        return this.type;
    }

    public String getText() throws IllegalStateException {
        this._checkType(0);
        return this.text;
    }

    public void setText(String string) throws IllegalStateException {
        this._checkType(0);
        this.text = string;
    }

    public int getIndexedColour() throws IllegalStateException {
        this._checkType(3);
        return this.idxColour;
    }

    public void setIndexedColour(int n) throws IllegalStateException {
        this._checkType(3);
        this.idxColour = n;
        this.colour = COLOUR_OBJECTS[n];
    }

    public String getNamedColour() throws IllegalStateException {
        this._checkType(9);
        return this.namedColour;
    }

    public void setNamedColour(String string) throws IllegalStateException {
        this._checkType(9);
        this.namedColour = string;
        this.colour = COLOUR_OBJECTS[MessageElement.whichColourName(string)];
    }

    public Color getAbsoluteColour() throws IllegalStateException {
        this._checkType(8);
        return this.colour;
    }

    public void setAbsoluteColour(Color color) throws IllegalStateException {
        this._checkType(8);
        this.colour = color;
    }

    public Font getFont() throws IllegalStateException {
        this._checkType(5);
        return new Font(this.fontFace, 0, this.fontSize);
    }

    public void setFont(Font font) throws IllegalStateException {
        this._checkType(5);
        this.fontFace = font.getFamily();
        this.fontSize = font.getSize();
    }

    public Color[] getTransition() throws IllegalStateException {
        if (this.type != 6 && this.type != 7) {
            throw wrongType;
        }
        return this.transition;
    }

    public void setTransition(Color[] colorArray) throws IllegalStateException {
        if (this.type != 6 && this.type != 7) {
            throw wrongType;
        }
        this.transition = colorArray;
    }

    private void _checkType(int n) throws IllegalStateException {
        if (this.type != n) {
            throw wrongType;
        }
    }

    public void add(int n, Object object) {
        this.children.add(n, object);
    }

    public boolean add(Object object) {
        return this.children.add(object);
    }

    public boolean addAll(Collection collection) {
        return this.children.addAll(collection);
    }

    public boolean addAll(int n, Collection collection) {
        return this.children.addAll(n, collection);
    }

    public void clear() {
        this.children.clear();
    }

    public boolean contains(Object object) {
        return this.children.contains(object);
    }

    public boolean containsAll(Collection collection) {
        return this.children.containsAll(collection);
    }

    public boolean equals(Object object) {
        return this.children.equals(object);
    }

    public Object get(int n) {
        return this.children.get(n);
    }

    public int hashCode() {
        return this.children.hashCode();
    }

    public int indexOf(Object object) {
        return this.children.indexOf(object);
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    public Iterator iterator() {
        return this.children.iterator();
    }

    public int lastIndexOf(Object object) {
        return this.children.lastIndexOf(object);
    }

    public ListIterator listIterator() {
        return this.children.listIterator();
    }

    public ListIterator listIterator(int n) {
        return this.children.listIterator(n);
    }

    public Object remove(int n) {
        return this.children.remove(n);
    }

    public boolean remove(Object object) {
        return this.children.remove(object);
    }

    public boolean removeAll(Collection collection) {
        return this.children.removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        return this.children.retainAll(collection);
    }

    public Object set(int n, Object object) {
        return this.children.set(n, object);
    }

    public int size() {
        return this.children.size();
    }

    public List subList(int n, int n2) {
        return this.children.subList(n, n2);
    }

    public Object[] toArray() {
        return this.children.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.children.toArray(objectArray);
    }

    public String toYahooIM() {
        return this.toYahooIM(false);
    }

    public String toYahooIM(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        Stack stack = bl ? new Stack() : null;
        this.toYahooIM(stringBuffer, stack);
        return stringBuffer.toString();
    }

    private void toYahooIM(StringBuffer stringBuffer, Stack stack) {
        switch (this.type) {
            case -2: {
                break;
            }
            case 0: {
                stringBuffer.append(this.text);
                break;
            }
            case 1: {
                stringBuffer.append(boldOn);
                break;
            }
            case 2: {
                stringBuffer.append(italicOn);
                break;
            }
            case 3: {
                stringBuffer.append(this._colIdx1(this.idxColour, stack));
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 4: {
                stringBuffer.append(underlineOn);
                break;
            }
            case 5: {
                stringBuffer.append("<font face=\"" + this.fontFace + "\" size=\"" + this.fontSize + "\">");
                break;
            }
            case 6: {
                break;
            }
        }
        for (int i = 0; i < this.children.size(); ++i) {
            MutableMessageElement mutableMessageElement = (MutableMessageElement)this.children.elementAt(i);
            mutableMessageElement.toYahooIM(stringBuffer, stack);
        }
        switch (this.type) {
            case -2: {
                break;
            }
            case 1: {
                stringBuffer.append(boldOff);
                break;
            }
            case 2: {
                stringBuffer.append(italicOff);
                break;
            }
            case 3: {
                if (stack == null) break;
                stringBuffer.append(this._colPop(stack));
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 4: {
                stringBuffer.append(underlineOff);
                break;
            }
            case 5: {
                stringBuffer.append("</font>");
                break;
            }
            case 6: {
                break;
            }
        }
    }

    public String toYahooChat() {
        return this.toYahooChat(false);
    }

    public String toYahooChat(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        Stack stack = bl ? new Stack() : null;
        this.toYahooChat(stringBuffer, stack);
        return stringBuffer.toString();
    }

    private void toYahooChat(StringBuffer stringBuffer, Stack stack) {
        switch (this.type) {
            case -2: {
                break;
            }
            case 0: {
                stringBuffer.append(this.text);
                break;
            }
            case 1: {
                stringBuffer.append(boldOn);
                break;
            }
            case 2: {
                stringBuffer.append(italicOn);
                break;
            }
            case 3: {
                stringBuffer.append(this._colIdx1(this.idxColour, stack));
                break;
            }
            case 8: {
                stringBuffer.append(this._colAbs1(this.colour, stack));
                break;
            }
            case 9: {
                stringBuffer.append("<" + this.namedColour + ">");
                break;
            }
            case 4: {
                stringBuffer.append(underlineOn);
                break;
            }
            case 5: {
                stringBuffer.append("<font face=\"" + this.fontFace + "\" size=\"" + this.fontSize + "\">");
                break;
            }
            case 6: {
                stringBuffer.append("<fade " + this._toTransition(this.transition) + ">");
                break;
            }
            case 7: {
                stringBuffer.append("<alt " + this._toTransition(this.transition) + ">");
            }
        }
        for (int i = 0; i < this.children.size(); ++i) {
            MutableMessageElement mutableMessageElement = (MutableMessageElement)this.children.elementAt(i);
            mutableMessageElement.toYahooChat(stringBuffer, stack);
        }
        switch (this.type) {
            case -2: {
                break;
            }
            case 1: {
                stringBuffer.append(boldOff);
                break;
            }
            case 2: {
                stringBuffer.append(italicOff);
                break;
            }
            case 3: {
                if (stack == null) break;
                stringBuffer.append(this._colPop(stack));
                break;
            }
            case 8: {
                if (stack == null) break;
                stringBuffer.append(this._colPop(stack));
                break;
            }
            case 9: {
                stringBuffer.append("</" + this.namedColour + ">");
                break;
            }
            case 4: {
                stringBuffer.append(underlineOff);
                break;
            }
            case 5: {
                stringBuffer.append("</font>");
                break;
            }
            case 6: {
                stringBuffer.append("</fade>");
                break;
            }
            case 7: {
                stringBuffer.append("</alt>");
            }
        }
    }

    private String _colIdx1(int n, Stack stack) {
        String string = esc + "3" + (char)(48 + n) + "m";
        if (stack != null) {
            stack.push(string);
        }
        return string;
    }

    private String _colAbs1(Color color, Stack stack) {
        String string = esc + "3#" + this._to6HexDigits(color) + "m";
        if (stack != null) {
            stack.push(string);
        }
        return string;
    }

    private String _colPop(Stack stack) {
        stack.pop();
        if (!stack.empty()) {
            return (String)stack.peek();
        }
        return "";
    }

    private String _to6HexDigits(Color color) {
        StringBuffer stringBuffer = new StringBuffer(Integer.toString(color.getRGB() & 0xFFFFFF, 16));
        while (stringBuffer.length() < 6) {
            stringBuffer.insert(0, '0');
        }
        return new String(stringBuffer);
    }

    private String _toTransition(Color[] colorArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < colorArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append('#').append(this._to6HexDigits(colorArray[i]));
        }
        return new String(stringBuffer);
    }
}

