/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logicalcobwebs.proxool.ConnectionPool;
import org.logicalcobwebs.proxool.ConnectionPoolDefinition;
import org.logicalcobwebs.proxool.ConnectionPoolManager;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;

public class ProxoolDataSource
implements DataSource,
ObjectFactory {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$logicalcobwebs$proxool$ProxoolDataSource == null ? (class$org$logicalcobwebs$proxool$ProxoolDataSource = ProxoolDataSource.class$("org.logicalcobwebs.proxool.ProxoolDataSource")) : class$org$logicalcobwebs$proxool$ProxoolDataSource));
    private int loginTimeout;
    private PrintWriter logWriter;
    private String alias;
    private String driver;
    private String fatalSqlExceptionWrapperClass;
    private long houseKeepingSleepTime;
    private String houseKeepingTestSql;
    private long maximumActiveTime;
    private int maximumConnectionCount;
    private long maximumConnectionLifetime;
    private int minimumConnectionCount;
    private long overloadWithoutRefusalLifetime;
    private String password;
    private int prototypeCount;
    private long recentlyStartedThreshold;
    private int simultaneousBuildThrottle;
    private String statistics;
    private String statisticsLogLevel;
    private boolean trace;
    private String driverUrl;
    private String user;
    private boolean verbose;
    private boolean jmx;
    private String jmxAgentId;
    private boolean testBeforeUse;
    private boolean testAfterUse;
    private Properties delegateProperties = new Properties();
    private String fatalSqlExceptionsAsString;
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$ProxoolDataSource;

    public ProxoolDataSource() {
        this.reset();
    }

    public ProxoolDataSource(String alias) {
        this.alias = alias;
    }

    public Connection getConnection() throws SQLException {
        ConnectionPool cp = null;
        try {
            if (!ConnectionPoolManager.getInstance().isPoolExists(this.alias)) {
                this.registerPool();
            }
            cp = ConnectionPoolManager.getInstance().getConnectionPool(this.alias);
            return cp.getConnection();
        }
        catch (ProxoolException e) {
            LOG.error((Object)"Problem getting connection", (Throwable)e);
            throw new SQLException(e.toString());
        }
    }

    private synchronized void registerPool() throws ProxoolException {
        if (!ConnectionPoolManager.getInstance().isPoolExists(this.alias)) {
            ConnectionPoolDefinition cpd = new ConnectionPoolDefinition();
            cpd.setAlias(this.getAlias());
            cpd.setDriver(this.getDriver());
            cpd.setFatalSqlExceptionsAsString(this.getFatalSqlExceptionsAsString());
            cpd.setFatalSqlExceptionWrapper(this.getFatalSqlExceptionWrapperClass());
            cpd.setHouseKeepingSleepTime(this.getHouseKeepingSleepTime());
            cpd.setHouseKeepingTestSql(this.getHouseKeepingTestSql());
            cpd.setMaximumActiveTime(this.getMaximumActiveTime());
            cpd.setMaximumConnectionCount(this.getMaximumConnectionCount());
            cpd.setMaximumConnectionLifetime(this.getMaximumConnectionLifetime());
            cpd.setMinimumConnectionCount(this.getMinimumConnectionCount());
            cpd.setOverloadWithoutRefusalLifetime(this.getOverloadWithoutRefusalLifetime());
            cpd.setPrototypeCount(this.getPrototypeCount());
            cpd.setRecentlyStartedThreshold(this.getRecentlyStartedThreshold());
            cpd.setSimultaneousBuildThrottle(this.getSimultaneousBuildThrottle());
            cpd.setStatistics(this.getStatistics());
            cpd.setStatisticsLogLevel(this.getStatisticsLogLevel());
            cpd.setTrace(this.isTrace());
            cpd.setUrl(this.getDriverUrl());
            cpd.setVerbose(this.isVerbose());
            cpd.setJmx(this.isJmx());
            cpd.setJmxAgentId(this.getJmxAgentId());
            cpd.setTestAfterUse(this.isTestAfterUse());
            cpd.setTestBeforeUse(this.isTestBeforeUse());
            cpd.setDelegateProperties(this.delegateProperties);
            cpd.setUser(this.getUser());
            cpd.setPassword(this.getPassword());
            ProxoolFacade.registerConnectionPool(cpd);
        }
    }

    public Object getObjectInstance(Object refObject, Name name, Context context, Hashtable hashtable) throws Exception {
        if (!(refObject instanceof Reference)) {
            return null;
        }
        Reference reference = (Reference)refObject;
        if (!ConnectionPoolManager.getInstance().isPoolExists(reference.get("proxool.alias").toString())) {
            this.populatePropertiesFromReference(reference);
        }
        return this;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getDriverUrl() {
        return this.driverUrl;
    }

    public void setDriverUrl(String url) {
        this.driverUrl = url;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public long getMaximumConnectionLifetime() {
        return this.maximumConnectionLifetime;
    }

    public void setMaximumConnectionLifetime(int maximumConnectionLifetime) {
        this.maximumConnectionLifetime = maximumConnectionLifetime;
    }

    public int getPrototypeCount() {
        return this.prototypeCount;
    }

    public void setPrototypeCount(int prototypeCount) {
        this.prototypeCount = prototypeCount;
    }

    public int getMinimumConnectionCount() {
        return this.minimumConnectionCount;
    }

    public void setMinimumConnectionCount(int minimumConnectionCount) {
        this.minimumConnectionCount = minimumConnectionCount;
    }

    public int getMaximumConnectionCount() {
        return this.maximumConnectionCount;
    }

    public void setMaximumConnectionCount(int maximumConnectionCount) {
        this.maximumConnectionCount = maximumConnectionCount;
    }

    public long getHouseKeepingSleepTime() {
        return this.houseKeepingSleepTime;
    }

    public void setHouseKeepingSleepTime(int houseKeepingSleepTime) {
        this.houseKeepingSleepTime = houseKeepingSleepTime;
    }

    public int getSimultaneousBuildThrottle() {
        return this.simultaneousBuildThrottle;
    }

    public void setSimultaneousBuildThrottle(int simultaneousBuildThrottle) {
        this.simultaneousBuildThrottle = simultaneousBuildThrottle;
    }

    public long getRecentlyStartedThreshold() {
        return this.recentlyStartedThreshold;
    }

    public void setRecentlyStartedThreshold(int recentlyStartedThreshold) {
        this.recentlyStartedThreshold = recentlyStartedThreshold;
    }

    public long getOverloadWithoutRefusalLifetime() {
        return this.overloadWithoutRefusalLifetime;
    }

    public void setOverloadWithoutRefusalLifetime(int overloadWithoutRefusalLifetime) {
        this.overloadWithoutRefusalLifetime = overloadWithoutRefusalLifetime;
    }

    public long getMaximumActiveTime() {
        return this.maximumActiveTime;
    }

    public void setMaximumActiveTime(long maximumActiveTime) {
        this.maximumActiveTime = maximumActiveTime;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public String getStatistics() {
        return this.statistics;
    }

    public void setStatistics(String statistics) {
        this.statistics = statistics;
    }

    public String getStatisticsLogLevel() {
        return this.statisticsLogLevel;
    }

    public void setStatisticsLogLevel(String statisticsLogLevel) {
        this.statisticsLogLevel = statisticsLogLevel;
    }

    public String getFatalSqlExceptionsAsString() {
        return this.fatalSqlExceptionsAsString;
    }

    public void setFatalSqlExceptionsAsString(String fatalSqlExceptionsAsString) {
        this.fatalSqlExceptionsAsString = fatalSqlExceptionsAsString;
    }

    public String getFatalSqlExceptionWrapperClass() {
        return this.fatalSqlExceptionWrapperClass;
    }

    public void setFatalSqlExceptionWrapperClass(String fatalSqlExceptionWrapperClass) {
        this.fatalSqlExceptionWrapperClass = fatalSqlExceptionWrapperClass;
    }

    public String getHouseKeepingTestSql() {
        return this.houseKeepingTestSql;
    }

    public void setHouseKeepingTestSql(String houseKeepingTestSql) {
        this.houseKeepingTestSql = houseKeepingTestSql;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isJmx() {
        return this.jmx;
    }

    public void setJmx(boolean jmx) {
        this.jmx = jmx;
    }

    public String getJmxAgentId() {
        return this.jmxAgentId;
    }

    public void setJmxAgentId(String jmxAgentId) {
        this.jmxAgentId = jmxAgentId;
    }

    public boolean isTestBeforeUse() {
        return this.testBeforeUse;
    }

    public void setTestBeforeUse(boolean testBeforeUse) {
        this.testBeforeUse = testBeforeUse;
    }

    public boolean isTestAfterUse() {
        return this.testAfterUse;
    }

    public void setTestAfterUse(boolean testAfterUse) {
        this.testAfterUse = testAfterUse;
    }

    public void setDelegateProperties(String properties) {
        StringTokenizer stOuter = new StringTokenizer(properties, ",");
        while (stOuter.hasMoreTokens()) {
            StringTokenizer stInner = new StringTokenizer(stOuter.nextToken(), "=");
            if (stInner.countTokens() == 1) {
                this.delegateProperties.put(stInner.nextToken().trim(), "");
                continue;
            }
            if (stInner.countTokens() == 2) {
                this.delegateProperties.put(stInner.nextToken().trim(), stInner.nextToken().trim());
                continue;
            }
            throw new IllegalArgumentException("Unexpected delegateProperties value: '" + properties + "'. Expected 'name=value'");
        }
    }

    private void populatePropertiesFromReference(Reference reference) {
        RefAddr property = reference.get("proxool.alias");
        if (property != null) {
            this.setAlias(property.getContent().toString());
        }
        if ((property = reference.get("proxool.driver-class")) != null) {
            this.setDriver(property.getContent().toString());
        }
        if ((property = reference.get("proxool.fatal-sql-exception-wrapper-class")) != null) {
            this.setFatalSqlExceptionWrapperClass(property.getContent().toString());
        }
        if ((property = reference.get("proxool.house-keeping-sleep-time")) != null) {
            this.setHouseKeepingSleepTime(Integer.valueOf(property.getContent().toString()));
        }
        if ((property = reference.get("proxool.house-keeping-test-sql")) != null) {
            this.setHouseKeepingTestSql(property.getContent().toString());
        }
        if ((property = reference.get("proxool.maximum-connection-count")) != null) {
            this.setMaximumConnectionCount(Integer.valueOf(property.getContent().toString()));
        }
        if ((property = reference.get("proxool.maximum-connection-lifetime")) != null) {
            this.setMaximumConnectionLifetime(Integer.valueOf(property.getContent().toString()));
        }
        if ((property = reference.get("proxool.maximum-active-time")) != null) {
            this.setMaximumActiveTime(Long.valueOf(property.getContent().toString()).intValue());
        }
        if ((property = reference.get("proxool.minimum-connection-count")) != null) {
            this.setMinimumConnectionCount(Integer.valueOf(property.getContent().toString()));
        }
        if ((property = reference.get("proxool.overload-without-refusal-lifetime")) != null) {
            this.setOverloadWithoutRefusalLifetime(Integer.valueOf(property.getContent().toString()));
        }
        if ((property = reference.get("password")) != null) {
            this.setPassword(property.getContent().toString());
        }
        if ((property = reference.get("proxool.prototype-count")) != null) {
            this.setPrototypeCount(Integer.valueOf(property.getContent().toString()));
        }
        if ((property = reference.get("proxool.recently-started-threshold")) != null) {
            this.setRecentlyStartedThreshold(Integer.valueOf(property.getContent().toString()));
        }
        if ((property = reference.get("proxool.simultaneous-build-throttle")) != null) {
            this.setSimultaneousBuildThrottle(Integer.valueOf(property.getContent().toString()));
        }
        if ((property = reference.get("proxool.statistics")) != null) {
            this.setStatistics(property.getContent().toString());
        }
        if ((property = reference.get("proxool.statistics-log-level")) != null) {
            this.setStatisticsLogLevel(property.getContent().toString());
        }
        if ((property = reference.get("proxool.trace")) != null) {
            this.setTrace("true".equalsIgnoreCase(property.getContent().toString()));
        }
        if ((property = reference.get("proxool.driver-url")) != null) {
            this.setDriverUrl(property.getContent().toString());
        }
        if ((property = reference.get("user")) != null) {
            this.setUser(property.getContent().toString());
        }
        if ((property = reference.get("proxool.verbose")) != null) {
            this.setVerbose("true".equalsIgnoreCase(property.getContent().toString()));
        }
        if ((property = reference.get("proxool.jmx")) != null) {
            this.setJmx("true".equalsIgnoreCase(property.getContent().toString()));
        }
        if ((property = reference.get("proxool.jmx-agent-id")) != null) {
            this.setJmxAgentId(property.getContent().toString());
        }
        if ((property = reference.get("proxool.test-before-use")) != null) {
            this.setTestBeforeUse("true".equalsIgnoreCase(property.getContent().toString()));
        }
        if ((property = reference.get("proxool.test-after-use")) != null) {
            this.setTestAfterUse("true".equalsIgnoreCase(property.getContent().toString()));
        }
        Enumeration<RefAddr> e = reference.getAll();
        while (e.hasMoreElements()) {
            StringRefAddr stringRefAddr = (StringRefAddr)e.nextElement();
            String name = stringRefAddr.getType();
            String content = stringRefAddr.getContent().toString();
            if (name.indexOf("proxool.") == 0) continue;
            this.delegateProperties.put(name, content);
        }
    }

    private void reset() {
        this.driverUrl = null;
        this.driver = null;
        this.maximumConnectionLifetime = 14400000L;
        this.prototypeCount = 0;
        this.minimumConnectionCount = 0;
        this.maximumConnectionCount = 15;
        this.houseKeepingSleepTime = 30000L;
        this.houseKeepingTestSql = null;
        this.simultaneousBuildThrottle = 10;
        this.recentlyStartedThreshold = 60000L;
        this.overloadWithoutRefusalLifetime = 60000L;
        this.maximumActiveTime = 300000L;
        this.verbose = false;
        this.trace = false;
        this.statistics = null;
        this.statisticsLogLevel = null;
        this.delegateProperties.clear();
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public void setLogWriter(PrintWriter logWriter) throws SQLException {
        this.logWriter = logWriter;
    }

    public void setLoginTimeout(int loginTimeout) throws SQLException {
        this.loginTimeout = loginTimeout;
    }

    public Connection getConnection(String s, String s1) throws SQLException {
        throw new UnsupportedOperationException("You should configure the username and password within the proxool configuration and just call getConnection() instead.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

