/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.parser;

import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jetty.spdy.SessionException;
import org.eclipse.jetty.spdy.api.SessionStatus;
import org.eclipse.jetty.spdy.frames.ControlFrameType;
import org.eclipse.jetty.spdy.frames.CredentialFrame;
import org.eclipse.jetty.spdy.parser.ControlFrameBodyParser;
import org.eclipse.jetty.spdy.parser.ControlFrameParser;

public class CredentialBodyParser
extends ControlFrameBodyParser {
    private final List<Certificate> certificates = new ArrayList<Certificate>();
    private final ControlFrameParser controlFrameParser;
    private State state = State.SLOT;
    private int totalLength;
    private int cursor;
    private short slot;
    private int proofLength;
    private byte[] proof;
    private int certificateLength;
    private byte[] certificate;

    public CredentialBodyParser(ControlFrameParser controlFrameParser) {
        this.controlFrameParser = controlFrameParser;
    }

    @Override
    public boolean parse(ByteBuffer buffer) {
        block12: while (buffer.hasRemaining()) {
            switch (this.state) {
                case SLOT: {
                    if (buffer.remaining() >= 2) {
                        this.slot = buffer.getShort();
                        this.checkSlotValid();
                        this.state = State.PROOF_LENGTH;
                        continue block12;
                    }
                    this.state = State.SLOT_BYTES;
                    this.cursor = 2;
                    continue block12;
                }
                case SLOT_BYTES: {
                    byte currByte = buffer.get();
                    --this.cursor;
                    this.slot = (short)(this.slot + ((currByte & 0xFF) << 8 * this.cursor));
                    if (this.cursor != 0) continue block12;
                    this.checkSlotValid();
                    this.state = State.PROOF_LENGTH;
                    continue block12;
                }
                case PROOF_LENGTH: {
                    if (buffer.remaining() >= 4) {
                        this.proofLength = buffer.getInt() & Integer.MAX_VALUE;
                        this.state = State.PROOF;
                        continue block12;
                    }
                    this.state = State.PROOF_LENGTH_BYTES;
                    this.cursor = 4;
                    continue block12;
                }
                case PROOF_LENGTH_BYTES: {
                    byte currByte = buffer.get();
                    --this.cursor;
                    this.proofLength += (currByte & 0xFF) << 8 * this.cursor;
                    if (this.cursor != 0) continue block12;
                    this.proofLength &= Integer.MAX_VALUE;
                    this.state = State.PROOF;
                    continue block12;
                }
                case PROOF: {
                    this.totalLength = this.controlFrameParser.getLength() - 2 - 4 - this.proofLength;
                    this.proof = new byte[this.proofLength];
                    if (buffer.remaining() >= this.proofLength) {
                        buffer.get(this.proof);
                        this.state = State.CERTIFICATE_LENGTH;
                        if (this.totalLength != 0) continue block12;
                        this.onCredential();
                        return true;
                    }
                    this.state = State.PROOF_BYTES;
                    this.cursor = this.proofLength;
                    continue block12;
                }
                case PROOF_BYTES: {
                    this.proof[this.proofLength - this.cursor] = buffer.get();
                    --this.cursor;
                    if (this.cursor != 0) continue block12;
                    this.state = State.CERTIFICATE_LENGTH;
                    if (this.totalLength != 0) continue block12;
                    this.onCredential();
                    return true;
                }
                case CERTIFICATE_LENGTH: {
                    if (buffer.remaining() >= 4) {
                        this.certificateLength = buffer.getInt() & Integer.MAX_VALUE;
                        this.state = State.CERTIFICATE;
                        continue block12;
                    }
                    this.state = State.CERTIFICATE_LENGTH_BYTES;
                    this.cursor = 4;
                    continue block12;
                }
                case CERTIFICATE_LENGTH_BYTES: {
                    byte currByte = buffer.get();
                    --this.cursor;
                    this.certificateLength += (currByte & 0xFF) << 8 * this.cursor;
                    if (this.cursor != 0) continue block12;
                    this.certificateLength &= Integer.MAX_VALUE;
                    this.state = State.CERTIFICATE;
                    continue block12;
                }
                case CERTIFICATE: {
                    this.totalLength -= 4 + this.certificateLength;
                    this.certificate = new byte[this.certificateLength];
                    if (buffer.remaining() >= this.certificateLength) {
                        buffer.get(this.certificate);
                        if (!this.onCertificate()) continue block12;
                        return true;
                    }
                    this.state = State.CERTIFICATE_BYTES;
                    this.cursor = this.certificateLength;
                    continue block12;
                }
                case CERTIFICATE_BYTES: {
                    this.certificate[this.certificateLength - this.cursor] = buffer.get();
                    --this.cursor;
                    if (this.cursor != 0 || !this.onCertificate()) continue block12;
                    return true;
                }
            }
            throw new IllegalStateException();
        }
        return false;
    }

    private void checkSlotValid() {
        if (this.slot <= 0) {
            throw new SessionException(SessionStatus.PROTOCOL_ERROR, "Invalid slot " + this.slot + " for " + (Object)((Object)ControlFrameType.CREDENTIAL) + " frame");
        }
    }

    private boolean onCertificate() {
        this.certificates.add(this.deserializeCertificate(this.certificate));
        if (this.totalLength == 0) {
            this.onCredential();
            return true;
        }
        this.certificateLength = 0;
        this.state = State.CERTIFICATE_LENGTH;
        return false;
    }

    private Certificate deserializeCertificate(byte[] bytes) {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            return certificateFactory.generateCertificate(new ByteArrayInputStream(bytes));
        }
        catch (CertificateException x) {
            throw new SessionException(SessionStatus.PROTOCOL_ERROR, (Throwable)x);
        }
    }

    private void onCredential() {
        CredentialFrame frame = new CredentialFrame(this.controlFrameParser.getVersion(), this.slot, Arrays.copyOf(this.proof, this.proof.length), this.certificates.toArray(new Certificate[this.certificates.size()]));
        this.controlFrameParser.onControlFrame(frame);
        this.reset();
    }

    private void reset() {
        this.state = State.SLOT;
        this.totalLength = 0;
        this.cursor = 0;
        this.slot = 0;
        this.proofLength = 0;
        this.proof = null;
        this.certificateLength = 0;
        this.certificate = null;
        this.certificates.clear();
    }

    public static enum State {
        SLOT,
        SLOT_BYTES,
        PROOF_LENGTH,
        PROOF_LENGTH_BYTES,
        PROOF,
        PROOF_BYTES,
        CERTIFICATE_LENGTH,
        CERTIFICATE_LENGTH_BYTES,
        CERTIFICATE,
        CERTIFICATE_BYTES;

    }
}

