/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.generator;

import java.nio.ByteBuffer;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.spdy.frames.ControlFrame;
import org.eclipse.jetty.spdy.frames.WindowUpdateFrame;
import org.eclipse.jetty.spdy.generator.ControlFrameGenerator;
import org.eclipse.jetty.util.BufferUtil;

public class WindowUpdateGenerator
extends ControlFrameGenerator {
    public WindowUpdateGenerator(ByteBufferPool bufferPool) {
        super(bufferPool);
    }

    @Override
    public ByteBuffer generate(ControlFrame frame) {
        WindowUpdateFrame windowUpdate = (WindowUpdateFrame)frame;
        int frameBodyLength = 8;
        int totalLength = 8 + frameBodyLength;
        ByteBuffer buffer = this.getByteBufferPool().acquire(totalLength, false);
        BufferUtil.clearToFill((ByteBuffer)buffer);
        this.generateControlFrameHeader(windowUpdate, frameBodyLength, buffer);
        buffer.putInt(windowUpdate.getStreamId() & Integer.MAX_VALUE);
        buffer.putInt(windowUpdate.getWindowDelta() & Integer.MAX_VALUE);
        buffer.flip();
        return buffer;
    }
}

