/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import java.util.StringTokenizer;
import javax.sip.address.Hop;

public class HopImpl
implements Hop {
    protected String host;
    protected int port;
    protected String transport;
    protected boolean defaultRoute;
    protected boolean uriRoute;

    public String toString() {
        return this.host + ":" + this.port + "/" + this.transport;
    }

    public HopImpl(String string, int n, String string2) {
        this.host = string;
        if (this.host.indexOf(":") >= 0 && this.host.indexOf("[") < 0) {
            this.host = "[" + this.host + "]";
        }
        this.port = n;
        this.transport = string2;
    }

    HopImpl(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Null arg!");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string + "/");
        String string2 = stringTokenizer.nextToken("/").trim();
        this.transport = stringTokenizer.nextToken().trim();
        if (this.transport == null) {
            this.transport = "UDP";
        } else if (this.transport == "") {
            this.transport = "UDP";
        }
        if (this.transport.compareToIgnoreCase("UDP") != 0 && this.transport.compareToIgnoreCase("TLS") != 0 && this.transport.compareToIgnoreCase("TCP") != 0) {
            System.out.println("Bad transport string " + this.transport);
            throw new IllegalArgumentException(string);
        }
        String string3 = null;
        if (string2.charAt(0) == '[') {
            int n = string2.indexOf(93);
            if (n == -1) {
                throw new IllegalArgumentException("Bad IPv6 reference spec");
            }
            this.host = string2.substring(0, n + 1);
            int n2 = string2.indexOf(58, n);
            if (n2 != -1) {
                try {
                    string3 = string2.substring(n2 + 1).trim();
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            }
        } else if (string2.indexOf(58) != string2.lastIndexOf(":")) {
            this.host = '[' + string2 + ']';
        } else {
            int n = string2.indexOf(58);
            if (n == -1) {
                this.host = string2;
            } else {
                this.host = string2.substring(0, n).trim();
                try {
                    string3 = string2.substring(n + 1).trim();
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        if (this.host == null || this.host.equals("")) {
            throw new IllegalArgumentException("no host!");
        }
        if (string3 == null || string3.equals("")) {
            this.port = 5060;
        } else {
            try {
                this.port = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Bad port spec");
            }
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getTransport() {
        return this.transport;
    }

    public boolean isURIRoute() {
        return this.uriRoute;
    }

    public void setURIRouteFlag() {
        this.uriRoute = true;
    }
}

