/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ssiitem;

import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.snaccmd.ssi.SsiItem;
import net.kano.joscar.ssiitem.AbstractItemObj;
import net.kano.joscar.ssiitem.SsiItemObjectWithId;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;

public abstract class SimpleNamedItem
extends AbstractItemObj
implements SsiItemObjectWithId {
    private static final int PARENTID_DEFAULT = 0;
    private final String sn;
    private final int id;

    protected SimpleNamedItem(SsiItem item) {
        this(item.getName(), item.getId(), TlvTools.readChain(item.getData()));
    }

    protected SimpleNamedItem(SimpleNamedItem other) {
        this(other.sn, other.id, other.copyExtraTlvs());
    }

    protected SimpleNamedItem(String sn, int id) {
        this(sn, id, null);
    }

    protected SimpleNamedItem(String sn, int id, TlvChain extraTlvs) {
        super(extraTlvs);
        DefensiveTools.checkNull((Object)sn, (String)"sn");
        DefensiveTools.checkRange((int)id, (String)"id", (int)0);
        this.sn = sn;
        this.id = id;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public final int getId() {
        return this.id;
    }

    protected abstract int getItemType();

    public SsiItem toSsiItem() {
        return this.generateItem(this.sn, 0, this.id, this.getItemType(), null);
    }

    public String toString() {
        return MiscTools.getClassName(this) + " for " + this.sn + " (id=0x" + Integer.toHexString(this.id) + ")";
    }
}

