/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.fileinst;

import com.install4j.api.FileOptions;
import com.install4j.api.ProgressInterface;
import com.install4j.api.UserCanceledException;
import com.install4j.runtime.installer.InstallerUtil;
import com.install4j.runtime.installer.fileinst.BackupPair;
import com.install4j.runtime.installer.fileinst.FileLogger;
import com.install4j.runtime.installer.fileinst.InstallFile;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.platform.unix.UnixFileSystem;
import com.install4j.runtime.installer.platform.win32.FileVersion;
import com.install4j.runtime.installer.platform.win32.Registry;
import com.install4j.runtime.installer.platform.win32.WinDel;
import com.install4j.runtime.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FileInstaller {
    public static final int SUCCESS = 0;
    public static final int ERROR = 1;
    public static final int CANCELED = 2;
    private static final String LOG_FILENAME = "files.log";
    private static final String KEY_SHARED_DLLS = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\SharedDLLs";
    private static FileInstaller fileInstaller = new FileInstaller();
    private boolean respondedOverwriteNever = false;
    private boolean respondedOverwriteAlways = false;
    private ProgressInterface defaultProgressInterface = new ProgressAdapter(null, false);
    private File logDir;
    private FileLogger newFileLogger = new FileLogger();
    private FileLogger oldFileLogger = new FileLogger();
    private BackupPair currentBackupPair;
    private List undeletedFiles = new ArrayList();
    private List undeletedDirs = new ArrayList();
    private boolean isUninstalling = false;

    public static FileInstaller getInstance() {
        return fileInstaller;
    }

    private BackupPair backupFile(InstallFile installFile) throws IOException {
        File file = File.createTempFile("i4b", null);
        FileUtil.copyFile(installFile, file);
        BackupPair backupPair = new BackupPair(installFile, file);
        this.newFileLogger.addReplacedFile(backupPair);
        return backupPair;
    }

    private static boolean isFirstFileNewer(File file, File file2) {
        if (InstallerUtil.isWindows()) {
            int n = FileVersion.compare(file, file2);
            if (n == 1) {
                return true;
            }
            if (n == 3) {
                return file.lastModified() > file2.lastModified();
            }
            return false;
        }
        return file.lastModified() > file2.lastModified();
    }

    private boolean checkFile(File file, InstallFile installFile, int n, boolean bl, ProgressInterface progressInterface) throws IOException {
        this.currentBackupPair = null;
        this.createDirectory(installFile.getParentFile());
        if (installFile.exists()) {
            boolean bl2;
            if (n == 0 || (n == 4 || n == 5) && this.respondedOverwriteNever) {
                return false;
            }
            boolean bl3 = bl2 = n != 4 && n != 5;
            if (n == 2 || n == 3) {
                boolean bl4 = FileInstaller.isFirstFileNewer(file, installFile);
                if (!bl4 && (n == 2 || this.respondedOverwriteNever)) {
                    return false;
                }
                bl2 = bl4;
            }
            if (n == 1 || this.respondedOverwriteAlways || bl && n != 5) {
                bl2 = true;
            }
            if (!bl2) {
                switch (progressInterface.askOverwrite(installFile)) {
                    case 4: {
                        this.respondedOverwriteNever = true;
                        return false;
                    }
                    case 1: {
                        return false;
                    }
                    case 3: {
                        this.respondedOverwriteAlways = true;
                    }
                }
            }
            this.currentBackupPair = this.backupFile(installFile);
            this.currentBackupPair.setPreviouslyCreated(bl);
        } else {
            this.newFileLogger.addCreatedFile(installFile);
        }
        return true;
    }

    public void registerUninstallFile(File file) {
        if (file.isDirectory()) {
            this.newFileLogger.addCreatedDir(file);
        } else {
            this.newFileLogger.addCreatedFile(new InstallFile(file, false, false));
        }
    }

    public void createDirectory(File file, boolean bl) throws IOException {
        if (bl) {
            file.mkdirs();
        } else {
            this.createDirectory(file);
        }
    }

    public void createDirectory(File file) throws IOException {
        File file2 = file.getCanonicalFile();
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file3 = file2; file3 != null; file3 = file3.getParentFile()) {
            arrayList.add(file3);
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            File file4 = (File)arrayList.get(i);
            if (!file4.mkdir()) continue;
            this.newFileLogger.addCreatedDir(file4);
        }
    }

    public boolean install(File file, File file2) throws UserCanceledException {
        return this.install(file, file2, new FileOptions(file.lastModified()));
    }

    public boolean install(File file, File file2, FileOptions fileOptions) throws UserCanceledException {
        return this.install(file, file2, fileOptions, null);
    }

    public boolean install(File file, File file2, FileOptions fileOptions, ProgressInterface progressInterface) throws UserCanceledException {
        if (progressInterface == null) {
            progressInterface = this.defaultProgressInterface;
        }
        boolean bl = false;
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            bl = this.install(bufferedInputStream, file2, fileOptions, progressInterface, file.length());
            ((InputStream)bufferedInputStream).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            String string = MessageFormat.format(Messages.getMessages().getString("ErrorInternal2"), "Could not read " + file);
            progressInterface.showFailure(string);
        }
        return bl;
    }

    public boolean install(InputStream inputStream, File file, FileOptions fileOptions) throws UserCanceledException {
        return this.install(inputStream, file, fileOptions, null, 0L);
    }

    private void copyTemp(File file, File file2, FileOptions fileOptions) throws IOException {
        if (file2.exists()) {
            if (!file2.delete()) {
                throw new IOException("could not delete " + file2);
            }
            if (this.currentBackupPair != null) {
                this.currentBackupPair.setOriginalModified(true);
            }
        }
        if (!file.renameTo(file2)) {
            throw new IOException("could not rename " + file + " to " + file2);
        }
        file2.setLastModified(fileOptions.getFileTime());
        if (!InstallerUtil.isWindows()) {
            UnixFileSystem.setMode(fileOptions.getMode(), file2);
        }
    }

    private static Object addSharedCount(Object object, int n) {
        int n2 = 1;
        try {
            if (object instanceof Integer) {
                n2 = (Integer)object + n;
                object = new Integer(n2);
            } else if (object instanceof String) {
                n2 = Integer.parseInt((String)object) + n;
                object = String.valueOf(n2);
            } else if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                if (byArray.length < 1 || byArray.length > 4) {
                    throw new NumberFormatException();
                }
                int[] nArray = new int[4];
                for (int i = 0; i < byArray.length; ++i) {
                    nArray[i] = byArray[i];
                }
                n2 = (nArray[3] << 24) + (nArray[2] << 16) + (nArray[1] << 8) + (nArray[0] << 0);
                byArray[0] = (byte)((n2 += n) >>> 0 & 0xFF);
                byArray[1] = (byte)(n2 >>> 8 & 0xFF);
                byArray[2] = (byte)(n2 >>> 16 & 0xFF);
                byArray[3] = (byte)(n2 >>> 24 & 0xFF);
            }
        }
        catch (NumberFormatException numberFormatException) {
            object = new Integer(n2);
        }
        if (n2 <= 0) {
            return null;
        }
        return object;
    }

    private void registerShared(File file) {
        if (!InstallerUtil.isWindows()) {
            return;
        }
        Object object = Registry.getValue(3, KEY_SHARED_DLLS, file.getAbsolutePath());
        if (object == null) {
            object = new Integer(0);
        }
        object = FileInstaller.addSharedCount(object, 1);
        Registry.setValue(3, KEY_SHARED_DLLS, file.getAbsolutePath(), object);
    }

    private static boolean unregisterShared(File file) {
        if (!InstallerUtil.isWindows()) {
            return true;
        }
        Object object = Registry.getValue(3, KEY_SHARED_DLLS, file.getAbsolutePath());
        if (object == null) {
            return true;
        }
        if ((object = FileInstaller.addSharedCount(object, -1)) == null) {
            Registry.deleteValue(3, KEY_SHARED_DLLS, file.getAbsolutePath());
            return true;
        }
        Registry.setValue(3, KEY_SHARED_DLLS, file.getAbsolutePath(), object);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean install(InputStream inputStream, File file, FileOptions fileOptions, ProgressInterface progressInterface, long l) throws UserCanceledException {
        boolean bl;
        block15: {
            if (progressInterface == null) {
                progressInterface = this.defaultProgressInterface;
            }
            bl = false;
            try {
                this.createDirectory(file.getParentFile());
                File file2 = File.createTempFile("i4j", null, file.getParentFile());
                try {
                    ProgressAdapter progressAdapter = new ProgressAdapter(progressInterface, false);
                    progressAdapter.setMaxCopyProgress(l);
                    FileUtil.extractFile(inputStream, file2, progressAdapter);
                    file2.setLastModified(fileOptions.getFileTime());
                    InstallFile installFile = new InstallFile(file, fileOptions.isShared(), fileOptions.isDontUninstall());
                    boolean bl2 = this.oldFileLogger.containsCreatedFile(file);
                    if (this.checkFile(file2, installFile, fileOptions.getOverwrite(), bl2, progressInterface)) {
                        boolean bl3 = true;
                        while (bl3 && !bl) {
                            try {
                                this.copyTemp(file2, installFile, fileOptions);
                                bl = true;
                            }
                            catch (IOException iOException) {
                                System.err.println(iOException.getMessage());
                                switch (progressInterface.askRetry(installFile)) {
                                    case 1: {
                                        bl3 = false;
                                        break;
                                    }
                                    case 3: {
                                        throw new UserCanceledException();
                                    }
                                }
                            }
                        }
                    }
                    if (fileOptions.isShared() && !bl2) {
                        this.registerShared(file);
                    }
                }
                finally {
                    file2.delete();
                }
            }
            catch (IOException iOException) {
                if (progressInterface.askContinue(file)) break block15;
                throw new UserCanceledException();
            }
        }
        return bl;
    }

    public void uninstall(ProgressInterface progressInterface) throws IOException {
        File file = InstallerUtil.getInstallerFile(LOG_FILENAME);
        FileLogger fileLogger = new FileLogger();
        fileLogger.read(file);
        this.deleteFile(file);
        this.isUninstalling = true;
        if (InstallerUtil.isWindows()) {
            WinDel.prepareDeletion();
        }
        this.rollback(progressInterface, fileLogger);
        if (InstallerUtil.isWindows() && (this.undeletedFiles.size() > 0 || this.undeletedDirs.size() > 0)) {
            WinDel.scheduleDeletion(this.undeletedFiles, this.undeletedDirs);
        }
    }

    public void rollback(ProgressInterface progressInterface) {
        this.rollback(progressInterface, this.newFileLogger);
    }

    public void rollback(ProgressInterface progressInterface, FileLogger fileLogger) {
        Object object;
        int n = fileLogger.getCreatedFilesSize() + fileLogger.getCreatedDirsSize() + fileLogger.getReplacedFilesSize();
        int n2 = 0;
        Iterator iterator = fileLogger.getCreatedFilesIterator();
        while (iterator.hasNext()) {
            object = (InstallFile)iterator.next();
            if (!this.isUninstalling || !((InstallFile)object).isDontUninstall()) {
                if (((InstallFile)object).isShared()) {
                    if (FileInstaller.unregisterShared((File)object)) {
                        this.deleteFile((File)object);
                    }
                } else {
                    this.deleteFile((File)object);
                }
            }
            progressInterface.setPercentCompleted(++n2 * 100 / n);
        }
        iterator = fileLogger.getCreatedDirsIterator();
        while (iterator.hasNext()) {
            object = (File)iterator.next();
            this.deleteDir((File)object);
            progressInterface.setPercentCompleted(++n2 * 100 / n);
        }
        iterator = fileLogger.getReplacedFilesIterator();
        while (iterator.hasNext()) {
            object = (BackupPair)iterator.next();
            if (((BackupPair)object).isOriginalModified()) {
                try {
                    FileUtil.copyFile(((BackupPair)object).getBackupFile(), ((BackupPair)object).getOriginalFile());
                    ((BackupPair)object).getOriginalFile().setLastModified(((BackupPair)object).getModTime());
                }
                catch (IOException iOException) {
                    String string = MessageFormat.format(Messages.getMessages().getString("ErrorInternal2"), "Could not restore " + ((BackupPair)object).getOriginalFile());
                    progressInterface.showFailure(string);
                }
            }
            progressInterface.setPercentCompleted(++n2 * 100 / n);
        }
    }

    public void deleteFile(File file) {
        if (!file.delete() && file.exists()) {
            this.undeletedFiles.add(file);
        }
    }

    public void deleteDir(File file) {
        if (!file.delete() && file.exists()) {
            this.undeletedDirs.add(file);
        }
    }

    public void cleanup(ProgressInterface progressInterface) {
        int n = this.newFileLogger.getReplacedFilesSize();
        int n2 = 0;
        Iterator iterator = this.newFileLogger.getReplacedFilesIterator();
        while (iterator.hasNext()) {
            BackupPair backupPair = (BackupPair)iterator.next();
            backupPair.getBackupFile().delete();
            progressInterface.setPercentCompleted(++n2 * 100 / n);
        }
    }

    public void setDefaultProgressInterface(ProgressInterface progressInterface) {
        this.defaultProgressInterface = new ProgressAdapter(progressInterface, true);
    }

    public void setLogDir(File file) {
        this.logDir = file;
        try {
            this.oldFileLogger.read(new File(file, LOG_FILENAME));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeLog() throws IOException {
        this.newFileLogger.write(new File(this.logDir, LOG_FILENAME), this.oldFileLogger);
    }

    public void addCreatedDirRecursive(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory()) {
                    this.addCreatedDirRecursive(file2);
                    continue;
                }
                this.newFileLogger.addCreatedFile(new InstallFile(file2, false, false));
            }
        }
        this.newFileLogger.addCreatedDir(file);
    }

    public void addCreatedFile(File file) {
        this.newFileLogger.addCreatedFile(new InstallFile(file, false, false));
    }

    public List getUndeletedFiles() {
        return this.undeletedFiles;
    }

    public List getUndeletedDirs() {
        return this.undeletedDirs;
    }
}

