/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceFactory;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.ResourceUtils;

public class SourceFileScanner
implements ResourceFactory {
    protected Task task;
    private FileUtils fileUtils;
    private File destDir;

    public String[] restrict(String[] stringArray, File file, File file2, FileNameMapper fileNameMapper) {
        return this.restrict(stringArray, file, file2, fileNameMapper, this.fileUtils.getFileTimestampGranularity());
    }

    public String[] restrict(String[] stringArray, File file, File file2, FileNameMapper fileNameMapper, long l) {
        Resource[] resourceArray;
        this.destDir = file2;
        Vector<Resource> vector = new Vector<Resource>();
        int n = 0;
        while (n < stringArray.length) {
            resourceArray = this.fileUtils.resolveFile(file, stringArray[n]);
            vector.addElement(new Resource(stringArray[n], resourceArray.exists(), resourceArray.lastModified(), resourceArray.isDirectory()));
            ++n;
        }
        Object[] objectArray = new Resource[vector.size()];
        vector.copyInto(objectArray);
        resourceArray = ResourceUtils.selectOutOfDateSources(this.task, (Resource[])objectArray, fileNameMapper, this, l);
        String[] stringArray2 = new String[resourceArray.length];
        int n2 = 0;
        while (n2 < resourceArray.length) {
            stringArray2[n2] = resourceArray[n2].getName();
            ++n2;
        }
        return stringArray2;
    }

    public File[] restrictAsFiles(String[] stringArray, File file, File file2, FileNameMapper fileNameMapper) {
        return this.restrictAsFiles(stringArray, file, file2, fileNameMapper, this.fileUtils.getFileTimestampGranularity());
    }

    public File[] restrictAsFiles(String[] stringArray, File file, File file2, FileNameMapper fileNameMapper, long l) {
        String[] stringArray2 = this.restrict(stringArray, file, file2, fileNameMapper, l);
        File[] fileArray = new File[stringArray2.length];
        int n = 0;
        while (n < stringArray2.length) {
            fileArray[n] = new File(file, stringArray2[n]);
            ++n;
        }
        return fileArray;
    }

    public Resource getResource(String string) {
        File file = this.fileUtils.resolveFile(this.destDir, string);
        return new Resource(string, file.exists(), file.lastModified(), file.isDirectory());
    }

    public SourceFileScanner(Task task) {
        this.task = task;
        this.fileUtils = FileUtils.newFileUtils();
    }
}

