/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.protocol.msnslp;

import java.nio.ByteBuffer;
import net.sf.jml.net.Message;
import net.sf.jml.util.ByteBufferUtils;
import net.sf.jml.util.Charset;
import net.sf.jml.util.StringHolder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class MsnslpMessage
implements Message {
    private static final Log logger = LogFactory.getLog(MsnslpMessage.class);
    private static final String KEY_TO = "To";
    private static final String KEY_FROM = "From";
    private static final String KEY_VIA = "Via";
    private static final String KEY_CSEQ = "CSeq";
    private static final String KEY_CALL_ID = "Call-ID";
    private static final String KEY_MAX_FORWARDS = "Max-Forwards";
    private static final String KEY_CONTENT_TYPE = "Content-Type";
    private static final String KEY_CONTENT_LENGTH = "Content-Length";
    private int majorVersion = 1;
    private int minorVersion = 0;
    protected final StringHolder headers = new StringHolder();
    protected final StringHolder bodys = new StringHolder();
    private String body = "";
    private static final ByteBuffer SPLIT = Charset.encode("\r\n\r\n");

    public final int getMajorVersion() {
        return this.majorVersion;
    }

    public final void setMajorVersion(int n) {
        this.majorVersion = n;
    }

    public final int getMinorVersion() {
        return this.minorVersion;
    }

    public final void setMinorVersion(int n) {
        this.minorVersion = n;
    }

    public final StringHolder getHeaders() {
        return this.headers;
    }

    public final StringHolder getBodys() {
        return this.bodys;
    }

    public final void setTo(String string) {
        this.headers.setProperty(KEY_TO, string);
    }

    public final String getTo() {
        return this.headers.getProperty(KEY_TO);
    }

    public final void setFrom(String string) {
        this.headers.setProperty(KEY_FROM, string);
    }

    public final String getFrom() {
        return this.headers.getProperty(KEY_FROM);
    }

    public final void setVia(String string) {
        this.headers.setProperty(KEY_VIA, string);
    }

    public final String getVia() {
        return this.headers.getProperty(KEY_VIA);
    }

    public final void setCSeq(int n) {
        this.headers.setProperty(KEY_CSEQ, n + " ");
    }

    public final int getCSeq() {
        return this.headers.getIntProperty(KEY_CSEQ);
    }

    public final void setCallId(String string) {
        this.headers.setProperty(KEY_CALL_ID, string);
    }

    public final String getCallId() {
        return this.headers.getProperty(KEY_CALL_ID);
    }

    public final void setMaxForwards(int n) {
        this.headers.setProperty(KEY_MAX_FORWARDS, String.valueOf(n));
    }

    public final int getMaxForwards() {
        return this.headers.getIntProperty(KEY_MAX_FORWARDS);
    }

    public final void setContentType(String string) {
        this.headers.setProperty(KEY_CONTENT_TYPE, string);
    }

    public final String getContentType() {
        return this.headers.getProperty(KEY_CONTENT_TYPE);
    }

    private void setContentLength(int n) {
        if (n <= 0) {
            this.headers.removeProperty(KEY_CONTENT_LENGTH);
        } else {
            this.headers.setProperty(KEY_CONTENT_LENGTH, String.valueOf(n));
        }
    }

    private int getContentLength() {
        return this.headers.getIntProperty(KEY_CONTENT_LENGTH);
    }

    public final String getBody() {
        return this.body;
    }

    public final void setBody(String string) {
        if (string == null) {
            string = "";
        }
        this.body = string;
        this.bodys.parseString(string);
        this.setContentLength(Charset.encode(string).remaining());
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.writeFirstLine(stringBuffer);
        stringBuffer.append("\r\n");
        stringBuffer.append(this.headers);
        stringBuffer.append("\r\n");
        stringBuffer.append(this.body);
        return stringBuffer.toString();
    }

    public ByteBuffer[] toByteBuffer() {
        return new ByteBuffer[]{Charset.encode(this.toString())};
    }

    public boolean readFromBuffer(ByteBuffer byteBuffer) {
        int n = ByteBufferUtils.indexOf(byteBuffer, SPLIT);
        if (n < 0) {
            return false;
        }
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer2.limit(n - byteBuffer.position());
        int n2 = byteBuffer2.remaining() + SPLIT.remaining();
        String string = Charset.decode(byteBuffer2);
        n = string.indexOf("\r\n");
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(0, n);
        if (this.readFirstLine(string2)) {
            this.headers.parseString(string.substring(n));
            try {
                this.setBody(Charset.decode((ByteBuffer)byteBuffer.slice().position(n2).limit(byteBuffer.remaining())));
                byteBuffer.position(byteBuffer.remaining());
                return true;
            }
            catch (Exception exception) {
                logger.error((Object)"Cannot parse slpMessage body", (Throwable)exception);
                return false;
            }
        }
        return false;
    }

    protected abstract boolean readFirstLine(String var1);

    protected abstract void writeFirstLine(StringBuffer var1);
}

