/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.stream;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.xml.sax.ContentHandler;
import weblogic.xml.babel.stream.CanonicalWriter;
import weblogic.xml.babel.stream.DOMOutputStream;
import weblogic.xml.babel.stream.SAXOutputStream;
import weblogic.xml.babel.stream.XMLDataWriter;
import weblogic.xml.babel.stream.XMLOutputStreamBase;
import weblogic.xml.babel.stream.XMLWriter;
import weblogic.xml.stream.XMLInputOutputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLOutputStreamFactory;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.stream.util.XMLInputOutputStreamBase;

public class XMLOutputStreamFactoryImpl
extends XMLOutputStreamFactory {
    public XMLOutputStream newOutputStream(OutputStream outputStream) throws XMLStreamException {
        return this.newOutputStream(new OutputStreamWriter(outputStream));
    }

    public XMLOutputStream newOutputStream(Writer writer) throws XMLStreamException {
        XMLWriter xMLWriter = XMLWriter.getSymmetricWriter(writer);
        return new XMLOutputStreamBase(xMLWriter);
    }

    public XMLOutputStream newOutputStream(Document document) throws XMLStreamException {
        return new DOMOutputStream(document);
    }

    public XMLOutputStream newOutputStream(Document document, DocumentFragment documentFragment) throws XMLStreamException {
        return new DOMOutputStream(document, documentFragment);
    }

    public XMLOutputStream newOutputStream(ContentHandler contentHandler) throws XMLStreamException {
        return new SAXOutputStream(contentHandler);
    }

    public XMLInputOutputStream newInputOutputStream() throws XMLStreamException {
        return new XMLInputOutputStreamBase();
    }

    public XMLOutputStream newDebugOutputStream(Writer writer) throws XMLStreamException {
        XMLWriter xMLWriter = XMLDataWriter.getDebugWriter(writer);
        return new XMLOutputStreamBase(xMLWriter);
    }

    public XMLOutputStream newDebugOutputStream(OutputStream outputStream) throws XMLStreamException {
        return this.newDebugOutputStream(new OutputStreamWriter(outputStream));
    }

    public XMLOutputStream newCanonicalOutputStream(Writer writer) throws XMLStreamException {
        return this.newCanonicalOutputStream(writer, null);
    }

    public XMLOutputStream newCanonicalOutputStream(OutputStream outputStream) throws XMLStreamException {
        return this.newCanonicalOutputStream(outputStream, null);
    }

    public XMLOutputStream newCanonicalOutputStream(Writer writer, Map map) throws XMLStreamException {
        CanonicalWriter canonicalWriter = new CanonicalWriter(writer, map);
        return new XMLOutputStreamBase(canonicalWriter);
    }

    public XMLOutputStream newCanonicalOutputStream(OutputStream outputStream, Map map) throws XMLStreamException {
        try {
            return this.newCanonicalOutputStream(new OutputStreamWriter(outputStream, "utf-8"), map);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new XMLStreamException("Unable to instantiate the output stream: ", (Throwable)unsupportedEncodingException);
        }
    }

    public XMLOutputStream newOutputStream(OutputStream outputStream, boolean bl) throws XMLStreamException {
        return this.newOutputStream(new OutputStreamWriter(outputStream), bl);
    }

    public XMLOutputStream newOutputStream(Writer writer, boolean bl) throws XMLStreamException {
        XMLWriter xMLWriter = XMLWriter.getSymmetricWriter(writer);
        XMLOutputStreamBase xMLOutputStreamBase = new XMLOutputStreamBase(xMLWriter);
        xMLOutputStreamBase.setWriteEmptyTags(bl);
        return xMLOutputStreamBase;
    }
}

