/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.dtd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import weblogic.xml.babel.baseparser.BaseParser;
import weblogic.xml.babel.baseparser.ParseException;
import weblogic.xml.babel.dtd.AttributeDefinition;
import weblogic.xml.babel.dtd.AttributeListDeclaration;
import weblogic.xml.babel.dtd.Children;
import weblogic.xml.babel.dtd.Declaration;
import weblogic.xml.babel.dtd.Name;
import weblogic.xml.babel.scanner.ScannerException;

public class ElementDeclaration
extends Declaration {
    private Map attributeDeclarations;
    private List defaultAttributeDeclarations;
    private boolean empty;
    private boolean any;
    private boolean mixed;
    private boolean hasChildren;
    private Children children;
    private Name name;

    public ElementDeclaration() {
        this.init();
    }

    public ElementDeclaration(String string) {
        this.init();
        this.name.setLocalName(string);
        this.any = true;
    }

    public void init() {
        super.init();
        this.name = new Name();
        this.children = new Children();
        this.hasChildren = false;
        this.mixed = false;
        this.any = false;
        this.empty = false;
    }

    public boolean hasAttributeDefinitions() {
        return this.attributeDeclarations != null;
    }

    public boolean hasDefaultAttributeDeclarations() {
        return this.defaultAttributeDeclarations != null;
    }

    public void addAttributeList(AttributeListDeclaration attributeListDeclaration) {
        Iterator iterator = attributeListDeclaration.getDefinitions().iterator();
        while (iterator.hasNext()) {
            this.addAttributeDefinition((AttributeDefinition)iterator.next());
        }
    }

    public void addAttributeDefinition(AttributeDefinition attributeDefinition) {
        if (this.attributeDeclarations == null) {
            this.attributeDeclarations = new HashMap();
        }
        this.attributeDeclarations.put(attributeDefinition.getRawName(), attributeDefinition);
        if (attributeDefinition.hasDefault()) {
            this.addDefaultAttributeDefinition(attributeDefinition);
        }
    }

    public List getDefaultAttributes() {
        return this.defaultAttributeDeclarations;
    }

    public AttributeDefinition getAttributeDefinition(String string) {
        return (AttributeDefinition)this.attributeDeclarations.get(string);
    }

    public void addDefaultAttributeDefinition(AttributeDefinition attributeDefinition) {
        if (this.defaultAttributeDeclarations == null) {
            this.defaultAttributeDeclarations = new ArrayList();
        }
        this.defaultAttributeDeclarations.add(attributeDefinition);
    }

    public boolean isMixed() {
        return this.mixed;
    }

    public boolean isAny() {
        return this.any;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void parse(BaseParser baseParser) throws IOException, ScannerException, ParseException {
        this.init();
        baseParser.accept(38);
        this.name.parse(baseParser);
        switch (baseParser.getCurrentToken().tokenType) {
            case 28: {
                this.empty = true;
                baseParser.accept();
                break;
            }
            case 29: {
                this.any = true;
                baseParser.accept();
                break;
            }
            case 59: {
                this.mixed = true;
                this.hasChildren = true;
            }
            default: {
                this.hasChildren = true;
                this.children.parse(baseParser);
            }
        }
        baseParser.accept(39);
        this.type = 10;
    }

    public Children getChildren() {
        return this.children;
    }

    private String wrap(String string) {
        return "<!ELEMENT " + string + ">";
    }

    public String toString() {
        if (this.empty) {
            return this.wrap(this.name + " " + "EMPTY");
        }
        if (this.any) {
            return this.wrap(this.name + " " + "ANY");
        }
        return this.wrap(this.name + " " + this.children);
    }

    public String getRawName() {
        return this.name.getRawName();
    }
}

