/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.InternalErrorHandler;
import gov.nist.core.LogWriter;
import gov.nist.core.NameValueList;
import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.header.Contact;
import gov.nist.javax.sip.header.RecordRoute;
import gov.nist.javax.sip.header.RecordRouteList;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.header.RouteList;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.PendingRecord;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import gov.nist.javax.sip.stack.TCPMessageChannel;
import gov.nist.javax.sip.stack.TLSMessageChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.TimerTask;
import javax.sip.ClientTransaction;
import javax.sip.SipException;
import javax.sip.TransactionState;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.message.Request;

public class SIPClientTransaction
extends SIPTransaction
implements ServerResponseInterface,
ClientTransaction,
PendingRecord {
    private static final int MAX_PENDING_RESPONSES = 4;
    private LinkedList pendingResponses;
    private SIPRequest lastRequest;
    private int viaPort;
    private String viaHost;
    private ServerResponseInterface respondTo;

    protected SIPClientTransaction(SIPTransactionStack newSIPStack, MessageChannel newChannelToUse) {
        super(newSIPStack, newChannelToUse);
        this.setBranch(Utils.generateBranchId());
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("Creating clientTransaction " + this);
            this.sipStack.logWriter.logStackTrace();
        }
        this.pendingResponses = new LinkedList();
    }

    public void setResponseInterface(ServerResponseInterface newRespondTo) {
        this.respondTo = newRespondTo;
    }

    public String getProcessingInfo() {
        return this.respondTo.getProcessingInfo();
    }

    public MessageChannel getRequestChannel() {
        return this;
    }

    public boolean isMessagePartOfTransaction(SIPMessage messageToTest) {
        ViaList viaHeaders = messageToTest.getViaHeaders();
        String messageBranch = ((Via)viaHeaders.getFirst()).getBranch();
        boolean rfc3261Compliant = this.getBranch() != null && messageBranch != null && this.getBranch().startsWith("z9hG4bK") && messageBranch.startsWith("z9hG4bK");
        boolean transactionMatches = false;
        if (TransactionState.COMPLETED == this.getState()) {
            transactionMatches = rfc3261Compliant ? this.getBranch().equals(((Via)viaHeaders.getFirst()).getBranch()) && this.getMethod().equals(messageToTest.getCSeq().getMethod()) : this.getBranch().equals(messageToTest.getTransactionId());
        } else if (!this.isTerminated()) {
            if (rfc3261Compliant) {
                if (viaHeaders != null && this.getBranch().equals(((Via)viaHeaders.getFirst()).getBranch())) {
                    transactionMatches = this.getOriginalRequest().getCSeq().getMethod().equals(messageToTest.getCSeq().getMethod());
                }
            } else {
                transactionMatches = this.getBranch() != null ? this.getBranch().equals(messageToTest.getTransactionId()) : this.getOriginalRequest().getTransactionId().equals(messageToTest.getTransactionId());
            }
        }
        return transactionMatches;
    }

    public void sendRawMessage(byte[] messageBytes, InetAddress ia, int port) throws IOException {
        super.sendMessage(messageBytes, ia, port, true);
    }

    public void sendMessage(SIPMessage messageToSend) throws IOException {
        SIPRequest transactionRequest = (SIPRequest)messageToSend;
        Via topVia = (Via)transactionRequest.getViaHeaders().getFirst();
        try {
            topVia.setBranch(this.getBranch());
        }
        catch (ParseException ex) {
            // empty catch block
        }
        if ((TransactionState.PROCEEDING == this.getState() || TransactionState.CALLING == this.getState()) && transactionRequest.getMethod().equals("ACK")) {
            if (this.isReliable()) {
                this.setState(TransactionState.TERMINATED);
            } else {
                this.setState(TransactionState.COMPLETED);
            }
            super.sendMessage(transactionRequest);
            return;
        }
        try {
            this.lastRequest = transactionRequest;
            if (this.getState() == null) {
                this.setOriginalRequest(transactionRequest);
                if (transactionRequest.getMethod().equals("INVITE")) {
                    this.setState(TransactionState.CALLING);
                } else if (transactionRequest.getMethod().equals("ACK")) {
                    this.setState(TransactionState.TERMINATED);
                } else {
                    this.setState(TransactionState.TRYING);
                }
                if (!this.isReliable()) {
                    this.enableRetransmissionTimer();
                }
                if (this.isInviteTransaction()) {
                    this.enableTimeoutTimer(64);
                } else {
                    this.enableTimeoutTimer(64);
                }
            }
            super.sendMessage(transactionRequest);
        }
        catch (IOException e) {
            this.setState(TransactionState.TERMINATED);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void processResponse(SIPResponse transactionResponse, MessageChannel sourceChannel) {
        if (this.sipStack.serverLog.needsLogging(16)) {
            this.logResponse(transactionResponse, System.currentTimeMillis(), "normal processing");
        }
        if (this.getState() == null) {
            return;
        }
        if (TransactionState.COMPLETED == this.getState() && transactionResponse.getStatusCode() / 100 == 1) {
            return;
        }
        if (TransactionState.PROCEEDING == this.getState() && transactionResponse.getStatusCode() == 100) {
            this.processPending();
        }
        if (this.eventPending) {
            if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logMessage("Discarding early arriving Response " + transactionResponse.getFirstLine());
            }
            LinkedList linkedList = this.pendingResponses;
            synchronized (linkedList) {
                if (this.pendingResponses.size() < 4) {
                    this.pendingResponses.add(new PendingResponse(transactionResponse, sourceChannel));
                }
            }
            this.sipStack.putPending(this);
            return;
        }
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("processing " + transactionResponse.getFirstLine() + "current state = " + this.getState());
        }
        this.lastResponse = transactionResponse;
        if (this.dialog != null) {
            this.dialog.addRoute(transactionResponse);
        }
        String method = transactionResponse.getCSeq().getMethod();
        if (this.dialog != null) {
            boolean added = false;
            SIPTransactionStack sipStackImpl = (SIPTransactionStack)this.getSIPStack();
            if (this.dialog.getRemoteTag() == null && transactionResponse.getTo().getTag() != null) {
                if (transactionResponse.getStatusCode() != 100) {
                    this.dialog.setRemoteTag(transactionResponse.getToTag());
                }
                String dialogId = transactionResponse.getDialogId(false);
                this.dialog.setDialogId(dialogId);
                if (sipStackImpl.isDialogCreated(method) && transactionResponse.getStatusCode() != 100) {
                    sipStackImpl.putDialog(this.dialog);
                    added = true;
                }
            } else if (this.dialog.getRemoteTag() != null && transactionResponse.getToTag() != null && !this.dialog.getRemoteTag().equals(transactionResponse.getToTag())) {
                String dialogId = transactionResponse.getDialogId(false);
                this.dialog.setRemoteTag(transactionResponse.getToTag());
                this.dialog.setDialogId(dialogId);
                if (sipStackImpl.isDialogCreated(method)) {
                    sipStackImpl.putDialog(this.dialog);
                    added = true;
                }
            }
            if (sipStackImpl.isDialogCreated(method)) {
                if (this.dialog.getState() == null && transactionResponse.getStatusCode() / 100 == 1) {
                    this.dialog.setState(0);
                } else if (transactionResponse.getToTag() != null && transactionResponse.getStatusCode() / 100 == 2) {
                    this.dialog.setRemoteTag(transactionResponse.getToTag());
                    this.dialog.setState(1);
                } else if (transactionResponse.getStatusCode() >= 300 && transactionResponse.getStatusCode() <= 699 && (this.dialog.getState() == null || this.dialog.getMethod().equals(this.getMethod()) && this.dialog.getState().getValue() == 0)) {
                    this.dialog.setState(3);
                }
            }
            if (this.getMethod().equals("BYE") && transactionResponse.getStatusCode() == 200) {
                this.dialog.setState(3);
            }
        }
        try {
            if (this.isInviteTransaction()) {
                this.inviteClientTransaction(transactionResponse, sourceChannel);
            } else {
                this.nonInviteClientTransaction(transactionResponse, sourceChannel);
            }
        }
        catch (IOException ex) {
            this.setState(TransactionState.TERMINATED);
            this.raiseErrorEvent(2);
        }
    }

    private void nonInviteClientTransaction(SIPResponse transactionResponse, MessageChannel sourceChannel) throws IOException {
        int statusCode = transactionResponse.getStatusCode();
        if (TransactionState.TRYING == this.getState()) {
            if (statusCode / 100 == 1) {
                this.setState(TransactionState.PROCEEDING);
                this.enableRetransmissionTimer(8);
                this.enableTimeoutTimer(64);
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this);
                }
            } else if (200 <= statusCode && statusCode <= 699) {
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this);
                }
                if (!this.isReliable()) {
                    this.setState(TransactionState.COMPLETED);
                    this.enableTimeoutTimer(10);
                } else {
                    this.setState(TransactionState.TERMINATED);
                }
            }
        } else if (TransactionState.PROCEEDING == this.getState()) {
            if (statusCode / 100 == 1) {
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this);
                }
            } else if (200 <= statusCode && statusCode <= 699) {
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this);
                }
                this.disableRetransmissionTimer();
                this.disableTimeoutTimer();
                if (!this.isReliable()) {
                    this.setState(TransactionState.COMPLETED);
                    this.enableTimeoutTimer(10);
                } else {
                    this.setState(TransactionState.TERMINATED);
                }
            }
        } else if (LogWriter.needsLogging) {
            this.getSIPStack().logWriter.logMessage(" Not sending response to TU! " + this.getState());
        }
    }

    private void inviteClientTransaction(SIPResponse transactionResponse, MessageChannel sourceChannel) throws IOException {
        int statusCode = transactionResponse.getStatusCode();
        if (TransactionState.TERMINATED == this.getState()) {
            return;
        }
        if (TransactionState.CALLING == this.getState()) {
            if (statusCode / 100 == 2) {
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this);
                }
                this.disableRetransmissionTimer();
                this.disableTimeoutTimer();
                this.setState(TransactionState.TERMINATED);
            } else if (statusCode / 100 == 1) {
                this.disableRetransmissionTimer();
                this.disableTimeoutTimer();
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this);
                }
                this.setState(TransactionState.PROCEEDING);
            } else if (300 <= statusCode && statusCode <= 699) {
                try {
                    this.sendMessage((SIPRequest)this.createAck());
                }
                catch (SipException ex) {
                    InternalErrorHandler.handleException((Exception)((Object)ex));
                }
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this);
                }
                if (!this.isReliable()) {
                    this.setState(TransactionState.COMPLETED);
                    this.enableTimeoutTimer(64);
                } else {
                    this.setState(TransactionState.TERMINATED);
                }
            }
        } else if (TransactionState.PROCEEDING == this.getState()) {
            if (statusCode / 100 == 1) {
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this);
                }
            } else if (statusCode / 100 == 2) {
                this.setState(TransactionState.TERMINATED);
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this);
                }
            } else if (300 <= statusCode && statusCode <= 699) {
                try {
                    this.sendMessage((SIPRequest)this.createAck());
                }
                catch (SipException ex) {
                    InternalErrorHandler.handleException((Exception)((Object)ex));
                }
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this);
                }
                if (!this.isReliable()) {
                    this.setState(TransactionState.COMPLETED);
                    this.enableTimeoutTimer(64);
                } else {
                    this.setState(TransactionState.TERMINATED);
                }
            }
        } else if (TransactionState.COMPLETED == this.getState() && 300 <= statusCode && statusCode <= 699) {
            try {
                this.sendMessage((SIPRequest)this.createAck());
            }
            catch (SipException ex) {
                InternalErrorHandler.handleException((Exception)((Object)ex));
            }
        }
    }

    public void sendRequest() throws SipException {
        SIPRequest sipRequest = this.getOriginalRequest();
        try {
            this.sendMessage(sipRequest);
        }
        catch (IOException ex) {
            throw new SipException(ex.getMessage());
        }
    }

    protected void fireRetransmissionTimer() {
        try {
            if (this.getState() == null || !this.isMapped) {
                return;
            }
            if (TransactionState.CALLING == this.getState() || TransactionState.TRYING == this.getState()) {
                if (!((SIPTransactionStack)this.getSIPStack()).retransmissionFilter && this.isInviteTransaction()) {
                    this.raiseErrorEvent(3);
                } else if (this.lastRequest != null) {
                    super.sendMessage(this.lastRequest);
                }
            }
        }
        catch (IOException e) {
            this.setState(TransactionState.TERMINATED);
            this.raiseErrorEvent(2);
        }
    }

    protected void fireTimeoutTimer() {
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("fireTimeoutTimer " + this);
        }
        SIPDialog dialogImpl = this.dialog;
        if ((TransactionState.CALLING == this.getState() || TransactionState.TRYING == this.getState() || TransactionState.PROCEEDING == this.getState()) && dialogImpl != null) {
            if (((SIPTransactionStack)this.getSIPStack()).isDialogCreated(this.getOriginalRequest().getMethod())) {
                dialogImpl.setState(3);
            } else if (this.getOriginalRequest().getMethod().equalsIgnoreCase("BYE")) {
                dialogImpl.setState(3);
            }
        }
        if (TransactionState.COMPLETED != this.getState()) {
            this.raiseErrorEvent(1);
        } else {
            this.setState(TransactionState.TERMINATED);
        }
    }

    public Request createCancel() throws SipException {
        SIPRequest originalRequest = this.getOriginalRequest();
        if (originalRequest == null) {
            throw new SipException("Bad state " + this.getState());
        }
        if (originalRequest.getMethod().equalsIgnoreCase("ACK")) {
            throw new SipException("Cannot Cancel ACK!");
        }
        return originalRequest.createCancelRequest();
    }

    public Request createAck() throws SipException {
        SIPRequest originalRequest = this.getOriginalRequest();
        if (originalRequest == null) {
            throw new SipException("bad state " + this.getState());
        }
        if (this.getMethod().equalsIgnoreCase("ACK")) {
            throw new SipException("Cannot ACK an ACK!");
        }
        if (this.lastResponse == null) {
            throw new SipException("bad Transaction state");
        }
        if (this.lastResponse.getStatusCode() < 200) {
            if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logMessage("lastResponse = " + this.lastResponse);
            }
            throw new SipException("Cannot ACK a provisional response!");
        }
        SIPRequest ackRequest = originalRequest.createAckRequest((To)this.lastResponse.getTo());
        RecordRouteList recordRouteList = this.lastResponse.getRecordRouteHeaders();
        if (recordRouteList == null) {
            Contact contact = null;
            if (this.lastResponse.getContactHeaders() != null) {
                contact = (Contact)this.lastResponse.getContactHeaders().getFirst();
                URI uri = (URI)contact.getAddress().getURI().clone();
                ackRequest.setRequestURI(uri);
            }
            return ackRequest;
        }
        ackRequest.removeHeader("Route");
        RouteList routeList = new RouteList();
        ListIterator li = recordRouteList.listIterator(recordRouteList.size());
        while (li.hasPrevious()) {
            RecordRoute rr = (RecordRoute)li.previous();
            AddressImpl addr = (AddressImpl)rr.getAddress();
            Route route = new Route();
            route.setAddress((AddressImpl)((AddressImpl)rr.getAddress()).clone());
            route.setParameters((NameValueList)rr.getParameters().clone());
            routeList.add(route);
        }
        Contact contact = null;
        if (this.lastResponse.getContactHeaders() != null) {
            contact = (Contact)this.lastResponse.getContactHeaders().getFirst();
        }
        if (!((SipURI)((Route)routeList.getFirst()).getAddress().getURI()).hasLrParam()) {
            Route route = null;
            if (contact != null) {
                route = new Route();
                route.setAddress((AddressImpl)((AddressImpl)contact.getAddress()).clone());
            }
            Route firstRoute = (Route)routeList.getFirst();
            routeList.removeFirst();
            URI uri = firstRoute.getAddress().getURI();
            ackRequest.setRequestURI(uri);
            if (route != null) {
                routeList.add(route);
            }
            ackRequest.addHeader(routeList);
        } else if (contact != null) {
            URI uri = (URI)contact.getAddress().getURI().clone();
            ackRequest.setRequestURI(uri);
            ackRequest.addHeader(routeList);
        }
        return ackRequest;
    }

    protected void setViaPort(int port) {
        this.viaPort = port;
    }

    protected void setViaHost(String host) {
        this.viaHost = host;
    }

    public int getViaPort() {
        return this.viaPort;
    }

    public String getViaHost() {
        return this.viaHost;
    }

    public Via getOutgoingViaHeader() {
        return this.getMessageProcessor().getViaHeader();
    }

    public boolean isSecure() {
        return this.encapsulatedChannel.isSecure();
    }

    public void clearState() {
        this.lastRequest = null;
        this.originalRequest = null;
        this.lastResponse = null;
    }

    public void setState(TransactionState newState) {
        if (newState == TransactionState.TERMINATED && this.isReliable() && !this.getSIPStack().cacheClientConnections) {
            this.collectionTime = 64;
        }
        super.setState(newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPending() {
        PendingResponse pr;
        LinkedList linkedList = this.pendingResponses;
        synchronized (linkedList) {
            if (this.pendingResponses.isEmpty()) {
                return;
            }
            pr = (PendingResponse)this.pendingResponses.removeFirst();
        }
        this.processResponse(pr.sipResponse, pr.messageChannel);
        this.eventPending = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPending() {
        LinkedList linkedList = this.pendingResponses;
        synchronized (linkedList) {
            return !this.pendingResponses.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPending() {
        boolean toNotify = false;
        LinkedList linkedList = this.pendingResponses;
        synchronized (linkedList) {
            super.clearPending();
            if (this.isTerminated() || !this.pendingResponses.isEmpty()) {
                if (LogWriter.needsLogging) {
                    this.sipStack.logWriter.logMessage("signaling pending response scanner!");
                }
                toNotify = true;
            }
        }
        if (toNotify) {
            this.sipStack.notifyPendingRecordScanner();
        }
    }

    protected void startTransactionTimer() {
        this.myTimer = new TransactionTimer(this);
        this.sipStack.timer.schedule(this.myTimer, 500L, 500L);
    }

    public class TransactionTimer
    extends TimerTask {
        protected SIPClientTransaction clientTransaction;
        protected SIPTransactionStack sipStack;

        public TransactionTimer(SIPClientTransaction clientTransaction) {
            this.clientTransaction = clientTransaction;
            this.sipStack = clientTransaction.sipStack;
        }

        public void run() {
            if (this.clientTransaction.isTerminated()) {
                block10: {
                    if (LogWriter.needsLogging) {
                        this.sipStack.logWriter.logMessage("removing  = " + this.clientTransaction + " isReliable " + this.clientTransaction.isReliable());
                    }
                    this.sipStack.removeTransaction(this.clientTransaction);
                    try {
                        this.cancel();
                    }
                    catch (IllegalStateException ex) {
                        if (this.sipStack.isAlive()) break block10;
                        return;
                    }
                }
                if (!this.sipStack.cacheClientConnections && this.clientTransaction.isReliable()) {
                    int newUseCount = this.clientTransaction.encapsulatedChannel instanceof TCPMessageChannel ? --((TCPMessageChannel)this.clientTransaction.encapsulatedChannel).useCount : --((TLSMessageChannel)this.clientTransaction.encapsulatedChannel).useCount;
                    if (newUseCount == 0) {
                        this.clientTransaction.myTimer = new SIPTransaction.LingerTimer(SIPClientTransaction.this, this.clientTransaction);
                        this.sipStack.timer.schedule(SIPClientTransaction.this.myTimer, 32000L);
                    }
                } else if (LogWriter.needsLogging && this.clientTransaction.isReliable()) {
                    int UseCount = this.clientTransaction.encapsulatedChannel instanceof TCPMessageChannel ? ((TCPMessageChannel)this.clientTransaction.encapsulatedChannel).useCount : ((TLSMessageChannel)this.clientTransaction.encapsulatedChannel).useCount;
                    if (LogWriter.needsLogging) {
                        this.sipStack.logWriter.logMessage("Client Use Count = " + UseCount);
                    }
                }
            } else {
                this.clientTransaction.fireTimer();
            }
        }
    }

    class PendingResponse {
        protected SIPResponse sipResponse;
        protected MessageChannel messageChannel;

        public PendingResponse(SIPResponse sipResponse, MessageChannel messageChannel) {
            this.sipResponse = sipResponse;
            this.messageChannel = messageChannel;
        }
    }
}

